/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AsciiConstant;
import at.dms.classfile.Attribute;
import at.dms.classfile.ClassConstant;
import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.ConstantPool;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class PostconditionAttribute
extends Attribute {
    public static final String NAME = "Postcondition";
    private static AsciiConstant attr = new AsciiConstant("Postcondition");
    private ClassConstant oldValueClass;

    int getTag() {
        return 103;
    }

    int getSize() {
        return 8;
    }

    public String getOldValueStore() {
        return this.oldValueClass == null ? null : this.oldValueClass.getName();
    }

    void resolveConstants(ConstantPool constantPool) throws ClassFileFormatException {
        constantPool.addItem(attr);
        if (this.oldValueClass != null) {
            constantPool.addItem(this.oldValueClass);
        }
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(attr.getIndex());
        dataOutput.writeInt(2);
        int n = 0;
        if (this.oldValueClass != null) {
            n = this.oldValueClass.getIndex();
        }
        dataOutput.writeShort(n);
    }

    public PostconditionAttribute() {
        this(null);
    }

    public PostconditionAttribute(String string) {
        this.oldValueClass = string == null ? null : new ClassConstant(string);
    }

    public PostconditionAttribute(DataInput dataInput, ConstantPool constantPool) throws IOException, ClassFileFormatException {
        if (dataInput.readInt() != 2) {
            throw new ClassFileFormatException("bad attribute length (Postcondition Attribute)");
        }
        int n = dataInput.readUnsignedShort();
        this.oldValueClass = n == 0 ? null : (ClassConstant)constantPool.getEntryAt(n);
    }
}

