/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AsciiConstant;
import at.dms.classfile.Attribute;
import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.ConstantPool;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SignatureAttribute
extends Attribute {
    public static final String NAME = "Signature";
    private static AsciiConstant attr = new AsciiConstant("Signature");
    private AsciiConstant signature;

    int getTag() {
        return 105;
    }

    int getSize() {
        return 8;
    }

    String getSignature() {
        return this.signature.getValue();
    }

    void resolveConstants(ConstantPool constantPool) throws ClassFileFormatException {
        constantPool.addItem(attr);
        constantPool.addItem(this.signature);
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(attr.getIndex());
        dataOutput.writeInt(2);
        dataOutput.writeShort(this.signature.getIndex());
    }

    public SignatureAttribute(String string) {
        this.signature = new AsciiConstant(string);
    }

    public SignatureAttribute(DataInput dataInput, ConstantPool constantPool) throws IOException, ClassFileFormatException {
        if (dataInput.readInt() != 2) {
            throw new ClassFileFormatException("bad attribute length (Signature Attribute)");
        }
        this.signature = (AsciiConstant)constantPool.getEntryAt(dataInput.readUnsignedShort());
    }
}

