/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AsciiConstant;
import at.dms.classfile.Attribute;
import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.ConstantPool;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SourceFileAttribute
extends Attribute {
    private static AsciiConstant attr = new AsciiConstant("SourceFile");
    private AsciiConstant name;

    int getTag() {
        return 1;
    }

    int getSize() {
        return 8;
    }

    String getValue() {
        return this.name.getValue();
    }

    void resolveConstants(ConstantPool constantPool) throws ClassFileFormatException {
        constantPool.addItem(attr);
        constantPool.addItem(this.name);
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(attr.getIndex());
        dataOutput.writeInt(2);
        dataOutput.writeShort(this.name.getIndex());
    }

    public SourceFileAttribute(String string) {
        this.name = new AsciiConstant(string);
    }

    public SourceFileAttribute(DataInput dataInput, ConstantPool constantPool) throws IOException, ClassFileFormatException {
        if (dataInput.readInt() != 2) {
            throw new ClassFileFormatException("bad attribute length");
        }
        this.name = (AsciiConstant)constantPool.getEntryAt(dataInput.readUnsignedShort());
    }
}

