/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AccessorContainer;
import at.dms.classfile.AccessorTransformer;
import at.dms.classfile.BadAccessorException;
import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.CodeEnv;
import at.dms.classfile.CodePosition;
import at.dms.classfile.ConstantPool;
import at.dms.classfile.Instruction;
import at.dms.classfile.InstructionAccessor;
import at.dms.classfile.InstructionHandle;
import at.dms.util.InconsistencyException;
import at.dms.util.Utils;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;

public class SwitchInstruction
extends Instruction
implements AccessorContainer {
    private boolean selected;
    private int pad;
    private InstructionAccessor deflab;
    private int[] matches;
    private InstructionAccessor[] targets;
    static /* synthetic */ Class class$at$dms$classfile$InstructionAccessor;

    public boolean canComplete() {
        return false;
    }

    public void transformAccessors(AccessorTransformer accessorTransformer) throws BadAccessorException {
        this.deflab = this.deflab.transform(accessorTransformer, this);
        int n = 0;
        while (n < this.targets.length) {
            this.targets[n] = this.targets[n].transform(accessorTransformer, this);
            ++n;
        }
    }

    public void setTarget(InstructionAccessor instructionAccessor, int n) {
        if (this.selected) {
            throw new InconsistencyException("switch type already determined");
        }
        if (n == -1) {
            this.deflab = instructionAccessor;
        } else {
            this.targets[n] = instructionAccessor;
        }
    }

    public int getSwitchCount() {
        return this.matches.length;
    }

    public int getMatch(int n) {
        return this.matches[n];
    }

    public InstructionAccessor getTarget(int n) {
        return n == -1 ? this.deflab : this.targets[n];
    }

    public void setTarget(int n, InstructionAccessor instructionAccessor) {
        if (n == -1) {
            this.deflab = instructionAccessor;
        } else {
            this.targets[n] = instructionAccessor;
        }
    }

    public void selectSwitchType() {
        int[] nArray = this.matches;
        InstructionAccessor[] instructionAccessorArray = this.targets;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            if (instructionAccessorArray[n4] != this.deflab) {
                if (n == 0) {
                    n2 = nArray[n4];
                    n3 = nArray[n4];
                } else {
                    if (nArray[n4] < n2) {
                        n2 = nArray[n4];
                    }
                    if (nArray[n4] > n3) {
                        n3 = nArray[n4];
                    }
                }
                ++n;
            }
            ++n4;
        }
        if (n == 0) {
            this.matches = new int[0];
            this.targets = new InstructionAccessor[0];
            this.setOpcode(171);
            this.selected = true;
        } else {
            long l = (long)n3 - (long)n2 + 1L;
            if (l <= (long)(2 * n)) {
                int n5 = (int)l;
                this.matches = new int[n5];
                this.targets = new InstructionAccessor[n5];
                int n6 = 0;
                while (n6 < this.matches.length) {
                    this.matches[n6] = n2 + n6;
                    this.targets[n6] = this.deflab;
                    ++n6;
                }
                n6 = 0;
                while (n6 < nArray.length) {
                    if (instructionAccessorArray[n6] != this.deflab) {
                        this.targets[nArray[n6] - n2] = instructionAccessorArray[n6];
                    }
                    ++n6;
                }
                this.setOpcode(170);
                this.selected = true;
            } else {
                this.matches = new int[n];
                this.targets = new InstructionAccessor[n];
                int n7 = 0;
                int n8 = 0;
                while (n7 < nArray.length) {
                    if (instructionAccessorArray[n7] != this.deflab) {
                        this.matches[n8] = nArray[n7];
                        this.targets[n8] = instructionAccessorArray[n7];
                        ++n8;
                    }
                    ++n7;
                }
                this.setOpcode(171);
                this.selected = true;
            }
        }
    }

    int getSize() {
        return this.computeSize(this.getAddress());
    }

    public byte getReturnType() {
        return 6;
    }

    void check(CodeEnv codeEnv, int n) throws ClassFileFormatException {
        codeEnv.checkExecutionPath((InstructionHandle)this.deflab, n);
        int n2 = 0;
        while (n2 < this.targets.length) {
            codeEnv.checkExecutionPath((InstructionHandle)this.targets[n2], n);
            ++n2;
        }
    }

    void computeEndAddress(CodePosition codePosition) {
        int n = this.computeSize(codePosition.max);
        codePosition.min += n;
        codePosition.max += n;
    }

    public int getPushedOnStack() {
        return 0;
    }

    public int getStack() {
        return -1;
    }

    void resolveConstants(ConstantPool constantPool) {
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
        dataOutput.writeByte((byte)this.getOpcode());
        int n = 0;
        while (n < this.pad) {
            dataOutput.writeByte(0);
            ++n;
        }
        dataOutput.writeInt(((Instruction)this.deflab).getAddress() - this.getAddress());
        if (!this.selected) {
            throw new InconsistencyException("switch type not yet determined");
        }
        if (this.getOpcode() == 170) {
            dataOutput.writeInt(this.matches[0]);
            dataOutput.writeInt(this.matches[0] + this.targets.length - 1);
            n = 0;
            while (n < this.targets.length) {
                dataOutput.writeInt(((Instruction)this.targets[n]).getAddress() - this.getAddress());
                ++n;
            }
        } else if (this.getOpcode() == 171) {
            dataOutput.writeInt(this.targets.length);
            SwitchInstruction.sort(this.matches, this.targets);
            n = 0;
            while (n < this.targets.length) {
                dataOutput.writeInt(this.matches[n]);
                dataOutput.writeInt(((Instruction)this.targets[n]).getAddress() - this.getAddress());
                ++n;
            }
        } else {
            throw new InconsistencyException("unexpected opcode: " + this.getOpcode());
        }
    }

    private final int computeSize(int n) {
        if (!this.selected) {
            this.selectSwitchType();
        }
        if (this.getOpcode() == 170) {
            int n2 = 13;
            this.pad = (n + 1) % 4 == 0 ? 0 : 4 - (n + 1) % 4;
            n2 += this.pad;
            return n2 += 4 * this.targets.length;
        }
        if (this.getOpcode() == 171) {
            int n3 = 9;
            this.pad = (n + 1) % 4 == 0 ? 0 : 4 - (n + 1) % 4;
            n3 += this.pad;
            if (this.targets != null) {
                n3 += 8 * this.targets.length;
            }
            return n3;
        }
        throw new InconsistencyException("unexpected opcode: " + this.getOpcode());
    }

    private static final void sort(int[] nArray, InstructionAccessor[] instructionAccessorArray) {
        int n = nArray.length;
        while (--n >= 0) {
            int n2 = 0;
            while (n2 < n) {
                if (nArray[n2] > nArray[n2 + 1]) {
                    int n3 = nArray[n2];
                    InstructionAccessor instructionAccessor = instructionAccessorArray[n2];
                    instructionAccessorArray[n2] = instructionAccessorArray[n2 + 1];
                    nArray[n2] = nArray[n2 + 1];
                    instructionAccessorArray[n2 + 1] = instructionAccessor;
                    nArray[n2 + 1] = n3;
                }
                ++n2;
            }
        }
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public SwitchInstruction(int n, InstructionAccessor instructionAccessor, int[] nArray, InstructionAccessor[] instructionAccessorArray) {
        super(n);
        this.selected = false;
        this.deflab = instructionAccessor;
        this.matches = nArray;
        this.targets = instructionAccessorArray;
    }

    public SwitchInstruction(InstructionAccessor instructionAccessor, int[] nArray, InstructionAccessor[] instructionAccessorArray) {
        this(170, instructionAccessor, nArray, instructionAccessorArray);
    }

    public SwitchInstruction(InstructionAccessor instructionAccessor, Vector vector, Vector vector2) {
        int[] nArray = Utils.toIntArray(vector);
        Class clazz = class$at$dms$classfile$InstructionAccessor;
        if (clazz == null) {
            clazz = class$at$dms$classfile$InstructionAccessor = SwitchInstruction.class$("[Lat.dms.classfile.InstructionAccessor;", false);
        }
        this(instructionAccessor, nArray, (InstructionAccessor[])Utils.toArray(vector2, clazz));
    }
}

