/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler;

import at.dms.compiler.CompilerMessages;
import at.dms.compiler.PositionedError;
import at.dms.compiler.UnpositionedError;
import at.dms.util.Message;
import at.dms.util.MessageDescription;
import at.dms.util.Utils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.Vector;

public abstract class Compiler {
    private final String workingDirectory;
    private final PrintWriter diagnosticOutput;
    static /* synthetic */ Class class$java$lang$String;

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public PrintWriter getDiagnosticOutput() {
        return this.diagnosticOutput;
    }

    public abstract int getSourceVersion();

    public File[] verifyFiles(String[] stringArray) throws UnpositionedError {
        Vector<String> vector = new Vector<String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].startsWith("@")) {
                vector.addElement(stringArray[n]);
            } else {
                try {
                    this.readList(vector, this.workingDirectory, stringArray[n]);
                }
                catch (IOException iOException) {
                    throw new UnpositionedError(CompilerMessages.INVALID_LIST_FILE, stringArray[n], iOException.getMessage());
                }
            }
            ++n;
        }
        File[] fileArray = new File[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            String string = this.workingDirectory == null ? (String)vector.elementAt(n2) : this.workingDirectory + File.separatorChar + (String)vector.elementAt(n2);
            File file = new File(string);
            if (!(file.exists() || (file = new File((String)vector.elementAt(n2))).exists() && file.isAbsolute())) {
                throw new UnpositionedError(CompilerMessages.FILE_NOT_FOUND, vector.elementAt(n2), null);
            }
            fileArray[n2] = file;
            ++n2;
        }
        return fileArray;
    }

    public Vector verifyFiles(Vector vector) throws UnpositionedError {
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = Compiler.class$("[Ljava.lang.String;", false);
        }
        return Utils.toVector(this.verifyFiles((String[])Utils.toArray(vector, clazz)));
    }

    private final void readList(Vector vector, String string, String string2) throws IOException, UnpositionedError {
        String string3;
        File file = new File((string == null ? "" : string + File.separatorChar) + string2.substring(1));
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
        while ((string3 = lineNumberReader.readLine()) != null) {
            this.readLine(vector, string2, string3);
        }
    }

    private final void readLine(Vector vector, String string, String string2) throws UnpositionedError {
        char[] cArray = string2.toCharArray();
        int n = 0;
        int n2 = 0;
        while (cArray.length > n) {
            switch (cArray[n]) {
                case '\t': 
                case ' ': {
                    ++n;
                    break;
                }
                case '\'': {
                    n2 = ++n;
                    while (n < cArray.length && cArray[n] != '\'') {
                        ++n;
                    }
                    if (cArray[n] != '\'') {
                        throw new UnpositionedError(CompilerMessages.INVALID_LIST_FILE, string, string2);
                    }
                    vector.add(new String(cArray, n2, n - n2));
                    ++n;
                    break;
                }
                case '\"': {
                    n2 = ++n;
                    while (n < cArray.length && cArray[n] != '\"') {
                        ++n;
                    }
                    if (cArray[n] != '\"') {
                        throw new UnpositionedError(CompilerMessages.INVALID_LIST_FILE, string, string2);
                    }
                    vector.add(new String(cArray, n2, n - n2));
                    ++n;
                    break;
                }
                default: {
                    n2 = n;
                    while (n < cArray.length && cArray[n] != ' ' && cArray[n] != '\t') {
                        ++n;
                    }
                    vector.add(new String(cArray, n2, n - n2));
                }
            }
        }
    }

    protected String checkDestination(String string) {
        if (this.workingDirectory == null) {
            return string;
        }
        if (string == null || string.equals("")) {
            return this.workingDirectory;
        }
        if (new File(string).isAbsolute()) {
            return string;
        }
        return this.workingDirectory + File.separatorChar + string;
    }

    public abstract boolean run(String[] var1);

    public abstract void reportTrouble(PositionedError var1);

    public abstract boolean parseComments();

    public abstract boolean verboseMode();

    public void inform(UnpositionedError unpositionedError) {
        this.inform(unpositionedError.getMessage());
    }

    public void inform(PositionedError positionedError) {
        this.inform(positionedError.getMessage());
    }

    public void inform(Message message) {
        this.inform(message.getMessage());
    }

    public void inform(MessageDescription messageDescription, Object[] objectArray) {
        this.inform(new Message(messageDescription, objectArray));
    }

    public void inform(MessageDescription messageDescription, Object object, Object object2) {
        this.inform(messageDescription, new Object[]{object, object2});
    }

    public void inform(MessageDescription messageDescription, Object object) {
        this.inform(messageDescription, new Object[]{object});
    }

    public void inform(MessageDescription messageDescription) {
        this.inform(messageDescription, null);
    }

    private final void inform(String string) {
        this.diagnosticOutput.println(string);
        this.diagnosticOutput.flush();
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Compiler(String string, PrintWriter printWriter) {
        this.workingDirectory = string;
        this.diagnosticOutput = printWriter == null ? new PrintWriter(System.err) : printWriter;
    }
}

