/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler;

import java.io.PrintWriter;
import java.io.Writer;

public class TabbedPrintWriter {
    private final PrintWriter writer;
    protected int pos;
    protected int line;
    protected int column;

    public void close() {
        this.writer.close();
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int n) {
        this.pos = n;
    }

    public void add(int n) {
        this.pos += n;
    }

    public void sub(int n) {
        this.pos += n;
    }

    public void println() {
        this.writer.println();
        this.column = 0;
        ++this.line;
    }

    public void print(String string) {
        this.checkPos();
        this.writer.print(string);
        this.column += string.length();
    }

    private final void checkPos() {
        if (this.column < this.pos) {
            this.writer.print(this.space(this.pos - this.column));
            this.column = Math.max(this.column, this.pos);
        }
    }

    private final String space(int n) {
        if (n <= 0) {
            n = 1;
        }
        return this.spaceIn(n);
    }

    private final String spaceIn(int n) {
        return new String(new char[n]).replace('\u0000', ' ');
    }

    public TabbedPrintWriter(Writer writer) {
        this.writer = new PrintWriter(writer);
        this.pos = 0;
    }
}

