/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler;

import at.dms.util.Utils;
import java.io.File;

public class TokenReference {
    public static TokenReference NO_REF;
    private static TokenReference last;
    private final String file;
    private final File path;
    private final int line;

    public static TokenReference build(String string, File file, int n) {
        if (n != TokenReference.last.line || string != TokenReference.last.file) {
            return new TokenReference(string, file, n);
        }
        return last;
    }

    public final String getFile() {
        return this.file;
    }

    public final File getPath() {
        return this.path;
    }

    public final String getName() {
        String[] stringArray = Utils.splitQualifiedName(this.file, File.separatorChar);
        return stringArray[1];
    }

    public final int getLine() {
        return this.line;
    }

    public String toString() {
        return "[" + this.file + ':' + this.line + ']';
    }

    public TokenReference(String string, int n) {
        this(string, new File(string), n);
    }

    public TokenReference(String string, File file, int n) {
        this.file = string;
        this.line = n;
        this.path = file;
        last = this;
    }

    static {
        last = NO_REF = new TokenReference("<GENERATED-BY-KOPI>", 0);
    }
}

