/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler.tools.antlr.compiler;

import at.dms.compiler.tools.antlr.compiler.GrammarFile;
import at.dms.compiler.tools.antlr.compiler.Hierarchy;
import at.dms.compiler.tools.antlr.compiler.IndexedVector;
import at.dms.compiler.tools.antlr.compiler.JavaCodeGenerator;
import at.dms.compiler.tools.antlr.compiler.Option;
import at.dms.compiler.tools.antlr.compiler.Rule;
import at.dms.compiler.tools.antlr.compiler.Utils;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class GrammarDefinition {
    private String name;
    private String fileName;
    private String superGrammar;
    private String type;
    private IndexedVector rules;
    private IndexedVector options;
    private String tokenSection;
    private String preambleAction;
    private String memberAction;
    private Hierarchy hier;
    private boolean predefined;
    private boolean alreadyExpanded;
    private String importVocab;
    private String exportVocab;

    public void addOption(Option option) {
        if (this.options == null) {
            this.options = new IndexedVector();
        }
        this.options.appendElement(option.getName(), option);
    }

    public void addRule(Rule rule) {
        this.rules.appendElement(rule.getName(), rule);
    }

    public void expandInPlace() {
        Object object;
        Object object2;
        if (this.alreadyExpanded) {
            return;
        }
        GrammarDefinition grammarDefinition = this.getSuperGrammar();
        if (grammarDefinition == null) {
            return;
        }
        if (this.exportVocab == null) {
            this.exportVocab = this.getName();
        }
        if (grammarDefinition.isPredefined()) {
            return;
        }
        grammarDefinition.expandInPlace();
        this.alreadyExpanded = true;
        GrammarFile grammarFile = this.hier.getFile(this.getFileName());
        grammarFile.setExpanded(true);
        IndexedVector indexedVector = grammarDefinition.getRules();
        Object object3 = indexedVector.elements();
        while (object3.hasMoreElements()) {
            object2 = (Rule)object3.nextElement();
            this.inherit((Rule)object2, grammarDefinition);
        }
        object3 = grammarDefinition.getOptions();
        if (object3 != null) {
            object2 = ((IndexedVector)object3).elements();
            while (object2.hasMoreElements()) {
                object = (Option)object2.nextElement();
                this.inherit((Option)object, grammarDefinition);
            }
        }
        if (this.options != null && this.options.getElement("importVocab") == null || this.options == null) {
            object2 = new Option("importVocab", grammarDefinition.exportVocab + ';', this);
            this.addOption((Option)object2);
            object = grammarDefinition.getFileName();
            String string = Utils.pathToFile((String)object);
            String string2 = string + grammarDefinition.exportVocab + JavaCodeGenerator.TokenTypesFileSuffix + JavaCodeGenerator.TokenTypesFileExt;
            String string3 = Utils.fileMinusPath(string2);
            if (!string.equals("." + System.getProperty("file.separator"))) {
                try {
                    Utils.copyFile(string2, string3);
                }
                catch (IOException iOException) {
                    Utils.toolError("cannot find/copy importVocab file " + string2);
                    return;
                }
            }
        }
        this.inherit(grammarDefinition.memberAction, grammarDefinition);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getName() {
        return this.name;
    }

    public IndexedVector getOptions() {
        return this.options;
    }

    public IndexedVector getRules() {
        return this.rules;
    }

    public GrammarDefinition getSuperGrammar() {
        if (this.superGrammar == null) {
            return null;
        }
        GrammarDefinition grammarDefinition = this.hier.getGrammar(this.superGrammar);
        return grammarDefinition;
    }

    public String getSuperGrammarName() {
        return this.superGrammar;
    }

    public String getType() {
        return this.type;
    }

    public void inherit(Option option, GrammarDefinition grammarDefinition) {
        if (option.getName().equals("importVocab") || option.getName().equals("exportVocab")) {
            return;
        }
        Option option2 = null;
        if (this.options != null) {
            option2 = (Option)this.options.getElement(option.getName());
        }
        if (option2 == null) {
            this.addOption(option);
        }
    }

    public void inherit(Rule rule, GrammarDefinition grammarDefinition) {
        Rule rule2 = (Rule)this.rules.getElement(rule.getName());
        if (rule2 != null) {
            if (!rule2.sameSignature(rule)) {
                Utils.warning("rule " + this.getName() + '.' + rule2.getName() + " has different signature than " + grammarDefinition.getName() + '.' + rule2.getName());
            }
        } else {
            this.addRule(rule);
        }
    }

    public void inherit(String string, GrammarDefinition grammarDefinition) {
        if (this.memberAction != null) {
            return;
        }
        if (string != null) {
            this.memberAction = string;
        }
    }

    public void setImportVocabulary(String string) {
        this.importVocab = string;
    }

    public void setExportVocabulary(String string) {
        this.exportVocab = string;
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setHierarchy(Hierarchy hierarchy) {
        this.hier = hierarchy;
    }

    public void setMemberAction(String string) {
        this.memberAction = string;
    }

    public void setOptions(IndexedVector indexedVector) {
        this.options = indexedVector;
    }

    public void setPreambleAction(String string) {
        this.preambleAction = string;
    }

    public void setPredefined(boolean bl) {
        this.predefined = bl;
    }

    public void setTokenSection(String string) {
        this.tokenSection = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String toString() {
        String string = "";
        if (this.preambleAction != null) {
            string = string + this.preambleAction;
        }
        if (this.superGrammar == null) {
            return "class " + this.name + ';';
        }
        String string2 = "";
        string = string + "class " + this.name + " extends " + this.type + string2 + ';' + System.getProperty("line.separator") + System.getProperty("line.separator");
        if (this.options != null) {
            string = string + Hierarchy.optionsToString(this.options);
        }
        if (this.tokenSection != null) {
            string = string + this.tokenSection + System.getProperty("line.separator");
        }
        if (this.memberAction != null) {
            string = string + this.memberAction + System.getProperty("line.separator");
        }
        int n = 0;
        while (n < this.rules.size()) {
            Rule rule = (Rule)this.rules.elementAt(n);
            if (!this.getName().equals(rule.enclosingGrammar.getName())) {
                string = string + "// inherited from grammar " + rule.enclosingGrammar.getName() + System.getProperty("line.separator");
            }
            string = string + rule + System.getProperty("line.separator") + System.getProperty("line.separator");
            ++n;
        }
        return string;
    }

    private final /* synthetic */ void this() {
        this.predefined = false;
        this.alreadyExpanded = false;
        this.importVocab = null;
        this.exportVocab = null;
    }

    public GrammarDefinition(String string, String string2, IndexedVector indexedVector) {
        this.this();
        this.name = string;
        this.superGrammar = string2;
        this.rules = indexedVector;
    }
}

