/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler.tools.antlr.compiler;

import at.dms.compiler.tools.antlr.compiler.ActionElement;
import at.dms.compiler.tools.antlr.compiler.ActionLexer;
import at.dms.compiler.tools.antlr.compiler.Alternative;
import at.dms.compiler.tools.antlr.compiler.AlternativeBlock;
import at.dms.compiler.tools.antlr.compiler.AlternativeElement;
import at.dms.compiler.tools.antlr.compiler.BlockEndElement;
import at.dms.compiler.tools.antlr.compiler.CharLiteralElement;
import at.dms.compiler.tools.antlr.compiler.CharRangeElement;
import at.dms.compiler.tools.antlr.compiler.DefineGrammarSymbols;
import at.dms.compiler.tools.antlr.compiler.ExceptionHandler;
import at.dms.compiler.tools.antlr.compiler.ExceptionSpec;
import at.dms.compiler.tools.antlr.compiler.Grammar;
import at.dms.compiler.tools.antlr.compiler.GrammarAtom;
import at.dms.compiler.tools.antlr.compiler.GrammarSymbol;
import at.dms.compiler.tools.antlr.compiler.JavaBlockFinishingInfo;
import at.dms.compiler.tools.antlr.compiler.JavaCharFormatter;
import at.dms.compiler.tools.antlr.compiler.LLkGrammarAnalyzer;
import at.dms.compiler.tools.antlr.compiler.LexerGrammar;
import at.dms.compiler.tools.antlr.compiler.Lookahead;
import at.dms.compiler.tools.antlr.compiler.Main;
import at.dms.compiler.tools.antlr.compiler.MakeGrammar;
import at.dms.compiler.tools.antlr.compiler.OneOrMoreBlock;
import at.dms.compiler.tools.antlr.compiler.ParserGrammar;
import at.dms.compiler.tools.antlr.compiler.RuleBlock;
import at.dms.compiler.tools.antlr.compiler.RuleRefElement;
import at.dms.compiler.tools.antlr.compiler.RuleSymbol;
import at.dms.compiler.tools.antlr.compiler.StringLiteralElement;
import at.dms.compiler.tools.antlr.compiler.StringLiteralSymbol;
import at.dms.compiler.tools.antlr.compiler.SynPredBlock;
import at.dms.compiler.tools.antlr.compiler.TokenManager;
import at.dms.compiler.tools.antlr.compiler.TokenRangeElement;
import at.dms.compiler.tools.antlr.compiler.TokenRefElement;
import at.dms.compiler.tools.antlr.compiler.TokenSymbol;
import at.dms.compiler.tools.antlr.compiler.Utils;
import at.dms.compiler.tools.antlr.compiler.WildcardElement;
import at.dms.compiler.tools.antlr.compiler.ZeroOrMoreBlock;
import at.dms.compiler.tools.antlr.runtime.BitSet;
import at.dms.compiler.tools.antlr.runtime.CharFormatter;
import at.dms.compiler.tools.antlr.runtime.CharStreamException;
import at.dms.compiler.tools.antlr.runtime.RecognitionException;
import at.dms.compiler.tools.antlr.runtime.Token;
import at.dms.compiler.tools.antlr.runtime.TokenStreamException;
import at.dms.compiler.tools.antlr.runtime.Vector;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JavaCodeGenerator {
    private static final int DEFAULT_MAKE_SWITCH_THRESHOLD = 2;
    private static final int DEFAULT_BITSET_TEST_THRESHOLD = 4;
    public static String TokenTypesFileSuffix = "TokenTypes";
    public static String TokenTypesFileExt = ".txt";
    public static final int caseSizeThreshold = 127;
    private int tabs;
    private transient PrintWriter currentOutput;
    private Grammar grammar;
    private Vector bitsetsUsed;
    private Main tool;
    private DefineGrammarSymbols behavior;
    private LLkGrammarAnalyzer analyzer;
    private CharFormatter charFormatter;
    private int makeSwitchThreshold;
    private int bitsetTestThreshold;
    private int syntacticPredLevel;
    private boolean saveText;
    String labeledElementType;
    String labeledElementInit;
    String commonExtraArgs;
    String commonExtraParams;
    String commonLocalVars;
    String lt1Value;
    String exceptionThrown;
    String throwNoViable;
    RuleBlock currentRule;
    String currentASTResult;
    int astVarNumber;

    private final void _print(String string) {
        if (string != null) {
            this.currentOutput.print(string);
        }
    }

    private final void _printAction(String string) {
        if (string == null) {
            return;
        }
        int n = 0;
        while (n < string.length() && Character.isSpaceChar(string.charAt(n))) {
            ++n;
        }
        int n2 = string.length() - 1;
        while (n2 > n && Character.isSpaceChar(string.charAt(n2))) {
            --n2;
        }
        char c = '\u0000';
        int n3 = n;
        while (n3 <= n2) {
            c = string.charAt(n3);
            ++n3;
            boolean bl = false;
            switch (c) {
                case '\n': {
                    bl = true;
                    break;
                }
                case '\r': {
                    if (n3 <= n2 && string.charAt(n3) == '\n') {
                        ++n3;
                    }
                    bl = true;
                    break;
                }
                default: {
                    this.currentOutput.print(c);
                }
            }
            if (!bl) continue;
            this.currentOutput.println();
            this.printTabs();
            while (n3 <= n2 && Character.isSpaceChar(string.charAt(n3))) {
                ++n3;
            }
            bl = false;
        }
        this.currentOutput.println();
    }

    private final void _println(String string) {
        if (string != null) {
            this.currentOutput.println(string);
        }
    }

    public static boolean elementsAreRange(int[] nArray) {
        if (nArray.length == 0) {
            return false;
        }
        int n = nArray[0];
        int n2 = nArray[nArray.length - 1];
        if (nArray.length <= 2) {
            return false;
        }
        if (n2 - n + 1 > nArray.length) {
            return false;
        }
        int n3 = n + 1;
        int n4 = 1;
        while (n4 < nArray.length - 1) {
            if (n3 != nArray[n4]) {
                return false;
            }
            ++n3;
            ++n4;
        }
        return true;
    }

    private final String extractIdOfAction(Token token) {
        return this.extractIdOfAction(token.getText(), token.getLine());
    }

    private final String extractIdOfAction(String string, int n) {
        string = this.removeAssignmentFromDeclaration(string);
        int n2 = string.length() - 2;
        while (n2 >= 0) {
            if (!Character.isLetterOrDigit(string.charAt(n2)) && string.charAt(n2) != '_') {
                return string.substring(n2 + 1);
            }
            --n2;
        }
        Utils.warning("Ill-formed action", this.grammar.getFilename(), n);
        return "";
    }

    private final String extractTypeOfAction(Token token) {
        return this.extractTypeOfAction(token.getText(), token.getLine());
    }

    private final String extractTypeOfAction(String string, int n) {
        string = this.removeAssignmentFromDeclaration(string);
        int n2 = string.length() - 2;
        while (n2 >= 0) {
            if (!Character.isLetterOrDigit(string.charAt(n2)) && string.charAt(n2) != '_') {
                return string.substring(0, n2 + 1);
            }
            --n2;
        }
        Utils.warning("Ill-formed action", this.grammar.getFilename(), n);
        return "";
    }

    private final void genTokenInterchange(TokenManager tokenManager) throws IOException {
        String string = tokenManager.getName() + TokenTypesFileSuffix + TokenTypesFileExt;
        this.currentOutput = this.tool.openOutputFile(string);
        this.println("// $ANTLR 1.5A: " + Utils.fileMinusPath(this.tool.grammarFile) + " -> " + string + '$');
        this.tabs = 0;
        this.println(tokenManager.getName() + "    // output token vocab name");
        Vector vector = tokenManager.getVocabulary();
        int n = 4;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            if (string2 != null && !string2.startsWith("<")) {
                TokenSymbol tokenSymbol;
                if (string2.startsWith("\"")) {
                    tokenSymbol = (StringLiteralSymbol)tokenManager.getTokenSymbol(string2);
                    if (tokenSymbol != null && ((StringLiteralSymbol)tokenSymbol).label != null) {
                        this.print(((StringLiteralSymbol)tokenSymbol).label + '=');
                    }
                    this.println(string2 + '=' + n);
                } else {
                    this.print(string2);
                    tokenSymbol = tokenManager.getTokenSymbol(string2);
                    if (tokenSymbol == null) {
                        Utils.warning("undefined token symbol: " + string2);
                    } else if (tokenSymbol.getParaphrase() != null) {
                        this.print("(" + tokenSymbol.getParaphrase() + ')');
                    }
                    this.println("=" + n);
                }
            }
            ++n;
        }
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public String processStringForASTConstructor(String string) {
        return string;
    }

    private final String getBitsetName(int n) {
        return "_tokenSet_" + n;
    }

    public static String lexerRuleName(String string) {
        return "m" + string;
    }

    private final int markBitsetForGen(BitSet bitSet) {
        int n = 0;
        while (n < this.bitsetsUsed.size()) {
            BitSet bitSet2 = (BitSet)this.bitsetsUsed.elementAt(n);
            if (bitSet.equals(bitSet2)) {
                return n;
            }
            ++n;
        }
        this.bitsetsUsed.appendElement(bitSet.clone());
        return this.bitsetsUsed.size() - 1;
    }

    private final void print(String string) {
        if (string != null) {
            this.printTabs();
            this.currentOutput.print(string);
        }
    }

    private final void printAction(String string) {
        if (string != null) {
            this.printTabs();
            this._printAction(string);
        }
    }

    private final void println(String string) {
        if (string != null) {
            this.printTabs();
            this.currentOutput.println(string);
        }
    }

    private final void printTabs() {
        int n = 1;
        while (n <= this.tabs) {
            this.currentOutput.print("\t");
            ++n;
        }
    }

    private final String processActionForTreeSpecifiers(String string, int n, RuleBlock ruleBlock) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (this.grammar == null) {
            return string;
        }
        if (this.grammar instanceof LexerGrammar && string.indexOf(36) != -1) {
            ActionLexer actionLexer = new ActionLexer(string, ruleBlock, this);
            actionLexer.setLineOffset(n);
            actionLexer.setTool(this.tool);
            try {
                actionLexer.mACTION(true);
                string = actionLexer.getTokenObject().getText();
            }
            catch (RecognitionException recognitionException) {
                actionLexer.reportError(recognitionException);
                return string;
            }
            catch (TokenStreamException tokenStreamException) {
                Utils.panic("Error reading action:" + string);
                return string;
            }
            catch (CharStreamException charStreamException) {
                Utils.panic("Error reading action:" + string);
                return string;
            }
        }
        return string;
    }

    private final String removeAssignmentFromDeclaration(String string) {
        if (string.indexOf(61) >= 0) {
            string = string.substring(0, string.indexOf(61)).trim();
        }
        return string;
    }

    private final void reset() {
        this.tabs = 0;
        this.bitsetsUsed = new Vector();
        this.currentOutput = null;
        this.grammar = null;
        this.makeSwitchThreshold = 2;
        this.bitsetTestThreshold = 4;
    }

    public static String reverseLexerRuleName(String string) {
        return string.substring(1, string.length());
    }

    public void setAnalyzer(LLkGrammarAnalyzer lLkGrammarAnalyzer) {
        this.analyzer = lLkGrammarAnalyzer;
    }

    public void setBehavior(DefineGrammarSymbols defineGrammarSymbols) {
        this.behavior = defineGrammarSymbols;
    }

    private final void setGrammar(Grammar grammar) {
        this.reset();
        this.grammar = grammar;
        if (this.grammar.hasOption("codeGenMakeSwitchThreshold")) {
            try {
                this.makeSwitchThreshold = this.grammar.getIntegerOption("codeGenMakeSwitchThreshold");
            }
            catch (NumberFormatException numberFormatException) {
                this.tool.error("option 'codeGenMakeSwitchThreshold' must be an integer", this.grammar.getClassName(), this.grammar.getOption("codeGenMakeSwitchThreshold").getLine());
            }
        }
        if (this.grammar.hasOption("codeGenBitsetTestThreshold")) {
            try {
                this.bitsetTestThreshold = this.grammar.getIntegerOption("codeGenBitsetTestThreshold");
            }
            catch (NumberFormatException numberFormatException) {
                this.tool.error("option 'codeGenBitsetTestThreshold' must be an integer", this.grammar.getClassName(), this.grammar.getOption("codeGenBitsetTestThreshold").getLine());
            }
        }
    }

    public void setTool(Main main) {
        this.tool = main;
    }

    public void exitIfError() {
        if (this.tool.hasError) {
            System.out.println("Exiting due to errors.");
            System.exit(1);
        }
    }

    public void gen() {
        try {
            Object object;
            Enumeration enumeration = this.behavior.grammars.elements();
            while (enumeration.hasMoreElements()) {
                object = (Grammar)enumeration.nextElement();
                ((Grammar)object).setGrammarAnalyzer(this.analyzer);
                this.analyzer.setGrammar((Grammar)object);
                this.setupGrammarParameters((Grammar)object);
                ((Grammar)object).generate(this);
                this.exitIfError();
            }
            object = this.behavior.tokenManagers.elements();
            while (object.hasMoreElements()) {
                TokenManager tokenManager = (TokenManager)object.nextElement();
                if (!tokenManager.isReadOnly()) {
                    this.genTokenTypes(tokenManager);
                    this.genTokenInterchange(tokenManager);
                }
                this.exitIfError();
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    public void gen(ActionElement actionElement) {
        if (actionElement.isSemPred) {
            this.genSemPred(actionElement.actionText, actionElement.line);
        } else {
            if (this.grammar.hasSyntacticPredicate) {
                this.println("if ( inputState.guessing==0 ) {");
                ++this.tabs;
            }
            String string = this.processActionForTreeSpecifiers(actionElement.actionText, actionElement.getLine(), this.currentRule);
            this.printAction(string);
            if (this.grammar.hasSyntacticPredicate) {
                --this.tabs;
                this.println("}");
            }
        }
    }

    public void gen(AlternativeBlock alternativeBlock) {
        this.println("{");
        this.genBlockPreamble(alternativeBlock);
        String string = this.currentASTResult;
        if (alternativeBlock.getLabel() != null) {
            this.currentASTResult = alternativeBlock.getLabel();
        }
        boolean bl = this.grammar.theLLkAnalyzer.deterministic(alternativeBlock);
        JavaBlockFinishingInfo javaBlockFinishingInfo = this.genCommonBlock(alternativeBlock, true);
        this.genBlockFinish(javaBlockFinishingInfo, this.throwNoViable);
        this.println("}");
        this.currentASTResult = string;
    }

    public void gen(BlockEndElement blockEndElement) {
    }

    public void gen(CharLiteralElement charLiteralElement) {
        if (charLiteralElement.getLabel() != null) {
            this.println(charLiteralElement.getLabel() + " = " + this.lt1Value + ';');
        }
        this.genMatch(charLiteralElement);
    }

    public void gen(CharRangeElement charRangeElement) {
        if (charRangeElement.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(charRangeElement.getLabel() + " = " + this.lt1Value + ';');
        }
        this.println("matchRange(" + charRangeElement.beginText + ',' + charRangeElement.endText + ");");
    }

    public void gen(LexerGrammar lexerGrammar) throws IOException {
        GrammarSymbol grammarSymbol;
        Object object;
        Object object2;
        this.setGrammar(lexerGrammar);
        if (!(this.grammar instanceof LexerGrammar)) {
            Utils.panic("Internal error generating lexer");
        }
        this.setupOutput(this.grammar.getClassName());
        this.saveText = true;
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.getHeaderAction(""));
        this.println("import java.io.InputStream;");
        this.println("import java.io.Reader;");
        this.println("import java.util.Hashtable;");
        this.println("import at.dms.compiler.tools.antlr.runtime.*;");
        this.println(this.grammar.preambleAction.getText());
        String string = null;
        string = this.grammar.superClass != null ? this.grammar.superClass : "at.dms.compiler.tools.antlr.runtime." + this.grammar.getSuperClass();
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.print("public class " + this.grammar.getClassName() + " extends " + string);
        this.println(" implements " + this.grammar.tokenManager.getName() + TokenTypesFileSuffix + ", TokenStream");
        Token token = (Token)this.grammar.options.get("classHeaderSuffix");
        if (token != null && (object2 = Utils.stripFrontBack(token.getText(), "\"", "\"")) != null) {
            this.print(", " + (String)object2);
        }
        this.println(" {");
        this.print(this.processActionForTreeSpecifiers(this.grammar.classMemberAction.getText(), 0, this.currentRule));
        this.println("public " + this.grammar.getClassName() + "(InputStream in) {");
        ++this.tabs;
        this.println("this(new ByteBuffer(in));");
        --this.tabs;
        this.println("}");
        this.println("public " + this.grammar.getClassName() + "(Reader in) {");
        ++this.tabs;
        this.println("this(new CharBuffer(in));");
        --this.tabs;
        this.println("}");
        this.println("public " + this.grammar.getClassName() + "(InputBuffer ib) {");
        ++this.tabs;
        this.println("this(new LexerSharedInputState(ib));");
        --this.tabs;
        this.println("}");
        this.println("public " + this.grammar.getClassName() + "(LexerSharedInputState state) {");
        ++this.tabs;
        this.println("super(state);");
        this.println("literals = new Hashtable();");
        object2 = this.grammar.tokenManager.getTokenSymbolKeys();
        while (object2.hasMoreElements()) {
            TokenSymbol tokenSymbol;
            object = (String)object2.nextElement();
            if (((String)object).charAt(0) != '\"' || !((tokenSymbol = this.grammar.tokenManager.getTokenSymbol((String)object)) instanceof StringLiteralSymbol)) continue;
            grammarSymbol = (StringLiteralSymbol)tokenSymbol;
            this.println("literals.put(new ANTLRHashString(" + grammarSymbol.getId() + ", this), new Integer(" + ((TokenSymbol)grammarSymbol).getTokenType() + "));");
        }
        --this.tabs;
        this.println("caseSensitiveLiterals = " + lexerGrammar.caseSensitiveLiterals + ';');
        this.println("setCaseSensitive(" + lexerGrammar.caseSensitive + ");");
        this.println("}");
        this.genNextToken();
        object = this.grammar.rules.elements();
        int n = 0;
        while (object.hasMoreElements()) {
            grammarSymbol = (RuleSymbol)object.nextElement();
            if (!grammarSymbol.getId().equals("mnextToken")) {
                this.genRule((RuleSymbol)grammarSymbol, false, n++);
            }
            this.exitIfError();
        }
        this.genBitsets(this.bitsetsUsed, ((LexerGrammar)this.grammar).charVocabulary.size());
        this.println("");
        this.println("}");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(OneOrMoreBlock oneOrMoreBlock) {
        Object object;
        this.println("{");
        this.genBlockPreamble(oneOrMoreBlock);
        String string = oneOrMoreBlock.getLabel() != null ? "_cnt_" + oneOrMoreBlock.getLabel() : "_cnt" + oneOrMoreBlock.ID;
        this.println("int " + string + "=0;");
        String string2 = oneOrMoreBlock.getLabel() != null ? oneOrMoreBlock.getLabel() : "_loop" + oneOrMoreBlock.ID;
        this.println(string2 + ':');
        this.println("do {");
        ++this.tabs;
        String string3 = this.currentASTResult;
        if (oneOrMoreBlock.getLabel() != null) {
            this.currentASTResult = oneOrMoreBlock.getLabel();
        }
        boolean bl = this.grammar.theLLkAnalyzer.deterministic(oneOrMoreBlock);
        boolean bl2 = false;
        int n = this.grammar.maxk;
        if (!oneOrMoreBlock.greedy && oneOrMoreBlock.exitLookaheadDepth <= this.grammar.maxk && oneOrMoreBlock.exitCache[oneOrMoreBlock.exitLookaheadDepth].containsEpsilon()) {
            bl2 = true;
            n = oneOrMoreBlock.exitLookaheadDepth;
        } else if (!oneOrMoreBlock.greedy && oneOrMoreBlock.exitLookaheadDepth == Integer.MAX_VALUE) {
            bl2 = true;
        }
        if (bl2) {
            object = this.getLookaheadTestExpression(oneOrMoreBlock.exitCache, n);
            this.println("// nongreedy exit test");
            this.println("if ( " + string + ">=1 && " + (String)object + ") break " + string2 + ';');
        }
        object = this.genCommonBlock(oneOrMoreBlock, false);
        this.genBlockFinish((JavaBlockFinishingInfo)object, "if ( " + string + ">=1 ) { break " + string2 + "; } else {" + this.throwNoViable + '}');
        this.println(string + "++;");
        --this.tabs;
        this.println("} while (true);");
        this.println("}");
        this.currentASTResult = string3;
    }

    public void gen(ParserGrammar parserGrammar) throws IOException {
        Object object;
        this.setGrammar(parserGrammar);
        if (!(this.grammar instanceof ParserGrammar)) {
            Utils.panic("Internal error generating parser");
        }
        this.setupOutput(this.grammar.getClassName());
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.getHeaderAction(""));
        this.println("import at.dms.compiler.tools.antlr.runtime.*;");
        this.println(this.grammar.preambleAction.getText());
        String string = null;
        string = this.grammar.superClass != null ? this.grammar.superClass : "at.dms.compiler.tools.antlr.runtime." + this.grammar.getSuperClass();
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.println("public class " + this.grammar.getClassName() + " extends " + string);
        this.println("       implements " + this.grammar.tokenManager.getName() + TokenTypesFileSuffix);
        Token token = (Token)this.grammar.options.get("classHeaderSuffix");
        if (token != null && (object = Utils.stripFrontBack(token.getText(), "\"", "\"")) != null) {
            this.print(", " + (String)object);
        }
        this.println(" {");
        this.print(this.processActionForTreeSpecifiers(this.grammar.classMemberAction.getText(), 0, this.currentRule));
        if (this.grammar.superClass != null) {
            this.println("// Generated by at.dms.compiler.tools.antlr");
            this.println("private static final int MAX_LOOKAHEAD = " + this.grammar.maxk + ';');
            this.println("{");
            this.println("  tokenNames = _tokenNames;");
            this.println("}");
            this.println("// Generated by at.dms.compiler.tools.antlr");
            this.println("");
        } else {
            this.println("");
            this.println("protected " + this.grammar.getClassName() + "(TokenBuffer tokenBuf, int k) {");
            this.println("  super(tokenBuf,k);");
            this.println("  tokenNames = _tokenNames;");
            this.println("}");
            this.println("");
            this.println("public " + this.grammar.getClassName() + "(TokenBuffer tokenBuf) {");
            this.println("  this(tokenBuf," + this.grammar.maxk + ");");
            this.println("}");
            this.println("");
            this.println("protected " + this.grammar.getClassName() + "(TokenStream lexer, int k) {");
            this.println("  super(lexer,k);");
            this.println("  tokenNames = _tokenNames;");
            this.println("}");
            this.println("");
            this.println("public " + this.grammar.getClassName() + "(TokenStream lexer) {");
            this.println("  this(lexer," + this.grammar.maxk + ");");
            this.println("}");
            this.println("");
            this.println("public " + this.grammar.getClassName() + "(ParserSharedInputState state) {");
            this.println("  super(state," + this.grammar.maxk + ");");
            this.println("  tokenNames = _tokenNames;");
            this.println("}");
            this.println("");
        }
        object = this.grammar.rules.elements();
        int n = 0;
        while (object.hasMoreElements()) {
            GrammarSymbol grammarSymbol = (GrammarSymbol)object.nextElement();
            if (grammarSymbol instanceof RuleSymbol) {
                RuleSymbol ruleSymbol = (RuleSymbol)grammarSymbol;
                boolean bl = false;
                if (ruleSymbol.references.size() == 0) {
                    bl = true;
                }
                this.genRule(ruleSymbol, bl, n++);
            }
            this.exitIfError();
        }
        this.genTokenStrings();
        this.genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
        this.println("");
        this.println("}");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(RuleRefElement ruleRefElement) {
        RuleSymbol ruleSymbol = (RuleSymbol)this.grammar.getSymbol(ruleRefElement.targetRule);
        if (ruleSymbol == null || !ruleSymbol.isDefined()) {
            this.tool.error("Rule '" + ruleRefElement.targetRule + "' is not defined", this.grammar.getFilename(), ruleRefElement.getLine());
            return;
        }
        this.genErrorTryForElement(ruleRefElement);
        if (this.grammar instanceof LexerGrammar && !this.saveText) {
            this.println("_saveIndex=text.length();");
        }
        this.printTabs();
        if (ruleRefElement.idAssign != null) {
            if (ruleSymbol.block.returnAction == null) {
                Utils.warning("Rule '" + ruleRefElement.targetRule + "' has no return type", this.grammar.getFilename(), ruleRefElement.getLine());
            }
            this._print(ruleRefElement.idAssign + '=');
        } else if (!(this.grammar instanceof LexerGrammar) && this.syntacticPredLevel == 0 && ruleSymbol.block.returnAction != null) {
            Utils.warning("Rule '" + ruleRefElement.targetRule + "' returns a value", this.grammar.getFilename(), ruleRefElement.getLine());
        }
        this.GenRuleInvocation(ruleRefElement);
        if (this.grammar instanceof LexerGrammar && !this.saveText) {
            this.println("text.setLength(_saveIndex);");
        }
        if (this.syntacticPredLevel == 0) {
            boolean bl = false;
            if (bl) {
                this.println("if (inputState.guessing==0) {");
                ++this.tabs;
            }
            if (this.grammar instanceof LexerGrammar && ruleRefElement.getLabel() != null) {
                this.println(ruleRefElement.getLabel() + "=_returnToken;");
            }
            if (bl) {
                --this.tabs;
                this.println("}");
            }
        }
        this.genErrorCatchForElement(ruleRefElement);
    }

    public void gen(StringLiteralElement stringLiteralElement) {
        if (stringLiteralElement.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(stringLiteralElement.getLabel() + " = " + this.lt1Value + ';');
        }
        this.genMatch(stringLiteralElement);
    }

    public void gen(TokenRangeElement tokenRangeElement) {
        this.genErrorTryForElement(tokenRangeElement);
        if (tokenRangeElement.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(tokenRangeElement.getLabel() + " = " + this.lt1Value + ';');
        }
        this.println("matchRange(" + tokenRangeElement.beginText + ',' + tokenRangeElement.endText + ");");
        this.genErrorCatchForElement(tokenRangeElement);
    }

    public void gen(TokenRefElement tokenRefElement) {
        if (this.grammar instanceof LexerGrammar) {
            Utils.panic("Token reference found in lexer");
        }
        this.genErrorTryForElement(tokenRefElement);
        if (tokenRefElement.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(tokenRefElement.getLabel() + " = " + this.lt1Value + ';');
        }
        this.genMatch(tokenRefElement);
        this.genErrorCatchForElement(tokenRefElement);
    }

    public void gen(WildcardElement wildcardElement) {
        if (wildcardElement.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(wildcardElement.getLabel() + " = " + this.lt1Value + ';');
        }
        if (this.grammar instanceof LexerGrammar) {
            if (!this.saveText) {
                this.println("_saveIndex=text.length();");
            }
            this.println("matchNot(EOF_CHAR);");
            if (!this.saveText) {
                this.println("text.setLength(_saveIndex);");
            }
        } else {
            this.println("matchNot(" + this.getValueString(1) + ");");
        }
    }

    public void gen(ZeroOrMoreBlock zeroOrMoreBlock) {
        Object object;
        this.println("{");
        this.genBlockPreamble(zeroOrMoreBlock);
        String string = zeroOrMoreBlock.getLabel() != null ? zeroOrMoreBlock.getLabel() : "_loop" + zeroOrMoreBlock.ID;
        this.println(string + ':');
        this.println("do {");
        ++this.tabs;
        String string2 = this.currentASTResult;
        if (zeroOrMoreBlock.getLabel() != null) {
            this.currentASTResult = zeroOrMoreBlock.getLabel();
        }
        boolean bl = this.grammar.theLLkAnalyzer.deterministic(zeroOrMoreBlock);
        boolean bl2 = false;
        int n = this.grammar.maxk;
        if (!zeroOrMoreBlock.greedy && zeroOrMoreBlock.exitLookaheadDepth <= this.grammar.maxk && zeroOrMoreBlock.exitCache[zeroOrMoreBlock.exitLookaheadDepth].containsEpsilon()) {
            bl2 = true;
            n = zeroOrMoreBlock.exitLookaheadDepth;
        } else if (!zeroOrMoreBlock.greedy && zeroOrMoreBlock.exitLookaheadDepth == Integer.MAX_VALUE) {
            bl2 = true;
        }
        if (bl2) {
            object = this.getLookaheadTestExpression(zeroOrMoreBlock.exitCache, n);
            this.println("// nongreedy exit test");
            this.println("if (" + (String)object + ") { break " + string + "; }");
        }
        object = this.genCommonBlock(zeroOrMoreBlock, false);
        this.genBlockFinish((JavaBlockFinishingInfo)object, "break " + string + ';');
        --this.tabs;
        this.println("} while (true);");
        this.println("}");
        this.currentASTResult = string2;
    }

    private final void genAlt(Alternative alternative, AlternativeBlock alternativeBlock) {
        boolean bl = this.saveText;
        boolean bl2 = false;
        if (this.saveText && alternative.getAutoGen()) {
            bl2 = this.saveText = true;
        }
        if (alternative.exceptionSpec != null) {
            this.println("try {      // for error handling");
            ++this.tabs;
        }
        AlternativeElement alternativeElement = alternative.head;
        while (!(alternativeElement instanceof BlockEndElement)) {
            alternativeElement.generate(this);
            alternativeElement = alternativeElement.next;
        }
        if (alternative.exceptionSpec != null) {
            --this.tabs;
            this.println("}");
            this.genErrorHandler(alternative.exceptionSpec);
        }
        this.saveText = bl;
    }

    private final void genBitsets(Vector vector, int n) {
        this.println("");
        int n2 = 0;
        while (n2 < vector.size()) {
            BitSet bitSet = (BitSet)vector.elementAt(n2);
            bitSet.growToInclude(n);
            this.println("private static final long[] " + this.getBitsetName(n2) + "_data_ = { " + bitSet.toStringOfWords() + " };");
            this.println("public static final BitSet " + this.getBitsetName(n2) + " = new BitSet(" + this.getBitsetName(n2) + "_data_);");
            ++n2;
        }
    }

    private final void genBlockFinish(JavaBlockFinishingInfo javaBlockFinishingInfo, String string) {
        if (javaBlockFinishingInfo.needAnErrorClause && (javaBlockFinishingInfo.generatedAnIf || javaBlockFinishingInfo.generatedSwitch)) {
            if (javaBlockFinishingInfo.generatedAnIf) {
                this.println("else {");
            } else {
                this.println("{");
            }
            ++this.tabs;
            this.println(string);
            --this.tabs;
            this.println("}");
        }
        if (javaBlockFinishingInfo.postscript != null) {
            this.println(javaBlockFinishingInfo.postscript);
        }
    }

    private final void genBlockPreamble(AlternativeBlock alternativeBlock) {
        if (alternativeBlock instanceof RuleBlock) {
            RuleBlock ruleBlock = (RuleBlock)alternativeBlock;
            if (ruleBlock.labeledElements != null) {
                int n = 0;
                while (n < ruleBlock.labeledElements.size()) {
                    AlternativeElement alternativeElement = (AlternativeElement)ruleBlock.labeledElements.elementAt(n);
                    if (alternativeElement instanceof RuleRefElement || alternativeElement instanceof AlternativeBlock && !(alternativeElement instanceof RuleBlock) && !(alternativeElement instanceof SynPredBlock)) {
                        if (!(alternativeElement instanceof RuleRefElement) && ((AlternativeBlock)alternativeElement).not && this.analyzer.subruleCanBeInverted((AlternativeBlock)alternativeElement, this.grammar instanceof LexerGrammar)) {
                            this.println(this.labeledElementType + ' ' + alternativeElement.getLabel() + " = " + this.labeledElementInit + ';');
                        } else if (this.grammar instanceof LexerGrammar) {
                            this.println("Token " + alternativeElement.getLabel() + "=null;");
                        }
                    } else {
                        this.println(this.labeledElementType + ' ' + alternativeElement.getLabel() + " = " + this.labeledElementInit + ';');
                    }
                    ++n;
                }
            }
        }
        if (alternativeBlock.initAction != null) {
            this.printAction(this.processActionForTreeSpecifiers(alternativeBlock.initAction, 0, this.currentRule));
        }
    }

    private final void genCases(BitSet bitSet) {
        int[] nArray = bitSet.toArray();
        int n = this.grammar instanceof LexerGrammar ? 4 : 1;
        int n2 = 1;
        boolean bl = true;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (n2 == 1) {
                this.print("");
            } else {
                this._print("  ");
            }
            this._print("case " + this.getValueString(nArray[n3]) + ':');
            if (n2 == n) {
                this._println("");
                bl = true;
                n2 = 1;
            } else {
                ++n2;
                bl = false;
            }
            ++n3;
        }
        if (!bl) {
            this._println("");
        }
    }

    public JavaBlockFinishingInfo genCommonBlock(AlternativeBlock alternativeBlock, boolean bl) {
        int n;
        Object object;
        int n2 = 0;
        boolean bl2 = false;
        int n3 = 0;
        JavaBlockFinishingInfo javaBlockFinishingInfo = new JavaBlockFinishingInfo();
        boolean bl3 = this.saveText;
        boolean bl4 = false;
        if (this.saveText && alternativeBlock.getAutoGen()) {
            bl4 = this.saveText = true;
        }
        if (alternativeBlock.not && this.analyzer.subruleCanBeInverted(alternativeBlock, this.grammar instanceof LexerGrammar)) {
            Lookahead lookahead = this.analyzer.look(1, alternativeBlock);
            if (alternativeBlock.getLabel() != null && this.syntacticPredLevel == 0) {
                this.println(alternativeBlock.getLabel() + " = " + this.lt1Value + ';');
            }
            this.println("match(" + this.getBitsetName(this.markBitsetForGen(lookahead.fset)) + ");");
            return javaBlockFinishingInfo;
        }
        if (alternativeBlock.getAlternatives().size() == 1) {
            Alternative alternative = alternativeBlock.getAlternativeAt(0);
            if (alternative.synPred != null) {
                Utils.warning("Syntactic predicate superfluous for single alternative", this.grammar.getFilename(), alternativeBlock.getAlternativeAt((int)0).synPred.getLine());
            }
            if (bl) {
                if (alternative.semPred != null) {
                    this.genSemPred(alternative.semPred, alternativeBlock.line);
                }
                this.genAlt(alternative, alternativeBlock);
                return javaBlockFinishingInfo;
            }
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < alternativeBlock.getAlternatives().size()) {
            Alternative alternative = alternativeBlock.getAlternativeAt(n5);
            if (JavaCodeGenerator.suitableForCaseExpression(alternative)) {
                ++n4;
            }
            ++n5;
        }
        if (n4 >= this.makeSwitchThreshold) {
            String string = this.lookaheadString(1);
            bl2 = true;
            this.println("switch ( " + string + ") {");
            int n6 = 0;
            while (n6 < alternativeBlock.alternatives.size()) {
                Alternative alternative = alternativeBlock.getAlternativeAt(n6);
                if (JavaCodeGenerator.suitableForCaseExpression(alternative)) {
                    object = alternative.cache[1];
                    if (((Lookahead)object).fset.degree() == 0 && !((Lookahead)object).containsEpsilon()) {
                        Utils.warning("Alternate omitted due to empty prediction set", this.grammar.getFilename(), alternative.head.getLine());
                    } else {
                        this.genCases(((Lookahead)object).fset);
                        this.println("{");
                        ++this.tabs;
                        this.genAlt(alternative, alternativeBlock);
                        this.println("break;");
                        --this.tabs;
                        this.println("}");
                    }
                }
                ++n6;
            }
            this.println("default:");
            ++this.tabs;
        }
        int n7 = 0;
        if (this.grammar instanceof LexerGrammar) {
            n7 = this.grammar.maxk;
        }
        int n8 = n = n7;
        while (n8 >= 0) {
            int n9 = 0;
            while (n9 < alternativeBlock.alternatives.size()) {
                block39: {
                    String string;
                    boolean bl5;
                    block41: {
                        block40: {
                            object = alternativeBlock.getAlternativeAt(n9);
                            if (bl2 && JavaCodeGenerator.suitableForCaseExpression((Alternative)object)) break block39;
                            bl5 = false;
                            if (!(this.grammar instanceof LexerGrammar)) break block40;
                            int n10 = ((Alternative)object).lookaheadDepth;
                            if (n10 == Integer.MAX_VALUE) {
                                n10 = this.grammar.maxk;
                            }
                            while (n10 >= 1 && ((Alternative)object).cache[n10].containsEpsilon()) {
                                --n10;
                            }
                            if (n10 != n8) break block39;
                            bl5 = this.lookaheadIsEmpty((Alternative)object, n10);
                            string = this.getLookaheadTestExpression((Alternative)object, n10);
                            break block41;
                        }
                        bl5 = this.lookaheadIsEmpty((Alternative)object, this.grammar.maxk);
                        string = this.getLookaheadTestExpression((Alternative)object, this.grammar.maxk);
                    }
                    if (((Alternative)object).cache[1].fset.degree() > 127) {
                        if (n2 == 0) {
                            this.println("if " + string + " {");
                        } else {
                            this.println("else if " + string + " {");
                        }
                    } else if (bl5 && ((Alternative)object).semPred == null && ((Alternative)object).synPred == null) {
                        if (n2 == 0) {
                            this.println("{");
                        } else {
                            this.println("else {");
                        }
                        javaBlockFinishingInfo.needAnErrorClause = false;
                    } else {
                        if (((Alternative)object).semPred != null) {
                            String string2 = this.processActionForTreeSpecifiers(((Alternative)object).semPred, alternativeBlock.line, this.currentRule);
                            string = "(" + string + "&&(" + string2 + "))";
                        }
                        if (n2 > 0) {
                            if (((Alternative)object).synPred != null) {
                                this.println("else {");
                                ++this.tabs;
                                this.genSynPred(((Alternative)object).synPred, string);
                                ++n3;
                            } else {
                                this.println("else if " + string + " {");
                            }
                        } else if (((Alternative)object).synPred != null) {
                            this.genSynPred(((Alternative)object).synPred, string);
                        } else {
                            this.println("if " + string + " {");
                        }
                    }
                    ++n2;
                    ++this.tabs;
                    this.genAlt((Alternative)object, alternativeBlock);
                    --this.tabs;
                    this.println("}");
                }
                ++n9;
            }
            --n8;
        }
        String string = "";
        int n11 = 1;
        while (n11 <= n3) {
            string = string + '}';
            ++n11;
        }
        this.saveText = bl3;
        if (bl2) {
            --this.tabs;
            javaBlockFinishingInfo.postscript = string + '}';
            javaBlockFinishingInfo.generatedSwitch = true;
            boolean bl6 = false;
            if (n2 > 0) {
                bl6 = true;
            }
            javaBlockFinishingInfo.generatedAnIf = bl6;
        } else {
            javaBlockFinishingInfo.postscript = string;
            javaBlockFinishingInfo.generatedSwitch = false;
            boolean bl7 = false;
            if (n2 > 0) {
                bl7 = true;
            }
            javaBlockFinishingInfo.generatedAnIf = bl7;
        }
        return javaBlockFinishingInfo;
    }

    private static final boolean suitableForCaseExpression(Alternative alternative) {
        boolean bl = false;
        if (alternative.lookaheadDepth == 1 && alternative.semPred == null && !alternative.cache[1].containsEpsilon() && alternative.cache[1].fset.degree() <= 127) {
            bl = true;
        }
        return bl;
    }

    private final void genErrorCatchForElement(AlternativeElement alternativeElement) {
        ExceptionSpec exceptionSpec;
        RuleSymbol ruleSymbol;
        if (alternativeElement.getLabel() == null) {
            return;
        }
        String string = alternativeElement.enclosingRuleName;
        if (this.grammar instanceof LexerGrammar) {
            string = JavaCodeGenerator.lexerRuleName(alternativeElement.enclosingRuleName);
        }
        if ((ruleSymbol = (RuleSymbol)this.grammar.getSymbol(string)) == null) {
            Utils.panic("Enclosing rule not found!");
        }
        if ((exceptionSpec = ruleSymbol.block.findExceptionSpec(alternativeElement.getLabel())) != null) {
            --this.tabs;
            this.println("}");
            this.genErrorHandler(exceptionSpec);
        }
    }

    private final void genErrorHandler(ExceptionSpec exceptionSpec) {
        int n = 0;
        while (n < exceptionSpec.handlers.size()) {
            ExceptionHandler exceptionHandler = (ExceptionHandler)exceptionSpec.handlers.elementAt(n);
            this.println("catch (" + exceptionHandler.exceptionTypeAndName.getText() + ") {");
            ++this.tabs;
            if (this.grammar.hasSyntacticPredicate) {
                this.println("if (inputState.guessing==0) {");
                ++this.tabs;
            }
            this.printAction(this.processActionForTreeSpecifiers(exceptionHandler.action.getText(), 0, this.currentRule));
            if (this.grammar.hasSyntacticPredicate) {
                --this.tabs;
                this.println("} else {");
                ++this.tabs;
                this.println("throw " + this.extractIdOfAction(exceptionHandler.exceptionTypeAndName) + ';');
                --this.tabs;
                this.println("}");
            }
            --this.tabs;
            this.println("}");
            ++n;
        }
    }

    private final void genErrorTryForElement(AlternativeElement alternativeElement) {
        ExceptionSpec exceptionSpec;
        RuleSymbol ruleSymbol;
        if (alternativeElement.getLabel() == null) {
            return;
        }
        String string = alternativeElement.enclosingRuleName;
        if (this.grammar instanceof LexerGrammar) {
            string = JavaCodeGenerator.lexerRuleName(alternativeElement.enclosingRuleName);
        }
        if ((ruleSymbol = (RuleSymbol)this.grammar.getSymbol(string)) == null) {
            Utils.panic("Enclosing rule not found!");
        }
        if ((exceptionSpec = ruleSymbol.block.findExceptionSpec(alternativeElement.getLabel())) != null) {
            this.println("try { // for error handling");
            ++this.tabs;
        }
    }

    private final void genHeader() {
        this.println("// $ANTLR " + "1.5A" + ": \"" + Utils.fileMinusPath(this.tool.grammarFile) + "\" -> \"" + this.grammar.getClassName() + ".java\"$");
    }

    private final void genLiteralsTest() {
        this.println("_ttype = testLiteralsTable(_ttype);");
    }

    private final void genLiteralsTestForPartialToken() {
        this.println("_ttype = testLiteralsTable(new String(text.getBuffer(),_begin,text.length()-_begin),_ttype);");
    }

    private final void genMatch(BitSet bitSet) {
    }

    private final void genMatch(GrammarAtom grammarAtom) {
        if (grammarAtom instanceof StringLiteralElement) {
            if (this.grammar instanceof LexerGrammar) {
                this.genMatchUsingAtomText(grammarAtom);
            } else {
                this.genMatchUsingAtomTokenType(grammarAtom);
            }
        } else if (grammarAtom instanceof CharLiteralElement) {
            if (this.grammar instanceof LexerGrammar) {
                this.genMatchUsingAtomText(grammarAtom);
            } else {
                this.tool.error("cannot ref character literals in grammar: " + grammarAtom);
            }
        } else if (grammarAtom instanceof TokenRefElement) {
            this.genMatchUsingAtomText(grammarAtom);
        }
    }

    private final void genMatchUsingAtomText(GrammarAtom grammarAtom) {
        if (this.grammar instanceof LexerGrammar && !this.saveText) {
            this.println("_saveIndex=text.length();");
        }
        this.print(grammarAtom.not ? "matchNot(" : "match(");
        this._print("");
        if (grammarAtom.atomText.equals("EOF")) {
            this._print("Token.EOF_TYPE");
        } else {
            this._print(grammarAtom.atomText);
        }
        this._println(");");
        if (this.grammar instanceof LexerGrammar && !this.saveText) {
            this.println("text.setLength(_saveIndex);");
        }
    }

    private final void genMatchUsingAtomTokenType(GrammarAtom grammarAtom) {
        Object var2_2 = null;
        String string = this.getValueString(grammarAtom.getType());
        this.println((grammarAtom.not ? "matchNot(" : "match(") + string + ");");
    }

    public void genNextToken() {
        Object object;
        RuleSymbol ruleSymbol;
        boolean bl = false;
        int n = 0;
        while (n < this.grammar.rules.size()) {
            ruleSymbol = (RuleSymbol)this.grammar.rules.elementAt(n);
            if (ruleSymbol.isDefined() && ruleSymbol.access.equals("public")) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.println("");
            this.println("public Token nextToken() throws TokenStreamException {");
            this.println("\ttry {uponEOF();}");
            this.println("\tcatch(CharStreamIOException csioe) {");
            this.println("\t\tthrow new TokenStreamIOException(csioe.io);");
            this.println("\t}");
            this.println("\tcatch(CharStreamException cse) {");
            this.println("\t\tthrow new TokenStreamException(cse.getMessage());");
            this.println("\t}");
            this.println("\treturn new CommonToken(Token.EOF_TYPE, \"\");");
            this.println("}");
            this.println("");
            return;
        }
        RuleBlock ruleBlock = MakeGrammar.createNextTokenRule(this.grammar, this.grammar.rules, "nextToken");
        ruleSymbol = new RuleSymbol("mnextToken");
        ruleSymbol.setDefined();
        ruleSymbol.setBlock(ruleBlock);
        ruleSymbol.access = "private";
        this.grammar.define(ruleSymbol);
        boolean bl2 = this.grammar.theLLkAnalyzer.deterministic(ruleBlock);
        String string = null;
        if (((LexerGrammar)this.grammar).filterMode) {
            string = ((LexerGrammar)this.grammar).filterRule;
        }
        this.println("");
        this.println("public Token nextToken() throws TokenStreamException {");
        ++this.tabs;
        this.println("Token theRetToken=null;");
        this._println("tryAgain:");
        this.println("for (;;) {");
        ++this.tabs;
        this.println("Token _token = null;");
        this.println("int _ttype = Token.INVALID_TYPE;");
        if (((LexerGrammar)this.grammar).filterMode) {
            this.println("setCommitToPath(false);");
            if (string != null) {
                if (!this.grammar.isDefined(JavaCodeGenerator.lexerRuleName(string))) {
                    this.grammar.tool.error("Filter rule " + string + " does not exist in this lexer");
                } else {
                    RuleSymbol ruleSymbol2 = (RuleSymbol)this.grammar.getSymbol(JavaCodeGenerator.lexerRuleName(string));
                    if (!ruleSymbol2.isDefined()) {
                        this.grammar.tool.error("Filter rule " + string + " does not exist in this lexer");
                    } else if (ruleSymbol2.access.equals("public")) {
                        this.grammar.tool.error("Filter rule " + string + " must be protected");
                    }
                }
                this.println("int _m;");
                this.println("_m = mark();");
            }
        }
        this.println("resetText();");
        this.println("try {   // for char stream error handling");
        ++this.tabs;
        this.println("try {   // for lexical error handling");
        ++this.tabs;
        int n2 = 0;
        while (n2 < ruleBlock.getAlternatives().size()) {
            object = ruleBlock.getAlternativeAt(n2);
            if (((Alternative)object).cache[1].containsEpsilon()) {
                Utils.warning("found optional path in nextToken()");
            }
            ++n2;
        }
        String string2 = System.getProperty("line.separator");
        object = this.genCommonBlock(ruleBlock, false);
        String string3 = "if (LA(1)==EOF_CHAR) {uponEOF(); _returnToken = makeToken(Token.EOF_TYPE);}";
        string3 = string3 + string2 + "\t\t\t\t";
        string3 = ((LexerGrammar)this.grammar).filterMode ? (string == null ? string3 + "else {consume(); continue tryAgain;}" : string3 + "else {" + string2 + "\t\t\t\t\tcommit();" + string2 + "\t\t\t\t\ttry {m" + string + "(false);}" + string2 + "\t\t\t\t\tcatch(RecognitionException e) {" + string2 + "\t\t\t\t\t\t// catastrophic failure" + string2 + "\t\t\t\t\t\treportError(e);" + string2 + "\t\t\t\t\t\tconsume();" + string2 + "\t\t\t\t\t}" + string2 + "\t\t\t\t\tcontinue tryAgain;" + string2 + "\t\t\t\t}") : string3 + "else {" + this.throwNoViable + '}';
        this.genBlockFinish((JavaBlockFinishingInfo)object, string3);
        if (((LexerGrammar)this.grammar).filterMode && string != null) {
            this.println("commit();");
        }
        this.println("if ( _returnToken==null ) { continue tryAgain; } // found SKIP token");
        this.println("_ttype = _returnToken.getType();");
        if (((LexerGrammar)this.grammar).getTestLiterals()) {
            this.genLiteralsTest();
        }
        this.println("_returnToken.setType(_ttype);");
        this.println("return _returnToken;");
        --this.tabs;
        this.println("}");
        this.println("catch (RecognitionException e) {");
        ++this.tabs;
        if (((LexerGrammar)this.grammar).filterMode) {
            if (string == null) {
                this.println("if ( !getCommitToPath() ) {consume(); continue tryAgain;}");
            } else {
                this.println("if ( !getCommitToPath() ) {");
                ++this.tabs;
                this.println("rewind(_m);");
                this.println("resetText();");
                this.println("try {m" + string + "(false);}");
                this.println("catch(RecognitionException ee) {");
                this.println("\t// horrendous failure: error in filter rule");
                this.println("\treportError(ee);");
                this.println("\tconsume();");
                this.println("}");
                this.println("continue tryAgain;");
                --this.tabs;
                this.println("}");
            }
        }
        if (ruleBlock.getDefaultErrorHandler()) {
            this.println("reportError(e);");
            this.println("consume();");
        } else {
            this.println("throw new TokenStreamRecognitionException(e);");
        }
        --this.tabs;
        this.println("}");
        --this.tabs;
        this.println("}");
        this.println("catch (CharStreamException cse) {");
        this.println("\tif ( cse instanceof CharStreamIOException ) {");
        this.println("\t\tthrow new TokenStreamIOException(((CharStreamIOException)cse).io);");
        this.println("\t}");
        this.println("\telse {");
        this.println("\t\tthrow new TokenStreamException(cse.getMessage());");
        this.println("\t}");
        this.println("}");
        --this.tabs;
        this.println("}");
        --this.tabs;
        this.println("}");
        this.println("");
    }

    public void genRule(RuleSymbol ruleSymbol, boolean bl, int n) {
        Object object;
        Object object2;
        RuleBlock ruleBlock;
        this.tabs = 1;
        if (!ruleSymbol.isDefined()) {
            this.tool.error("undefined rule: " + ruleSymbol.getId());
            return;
        }
        this.currentRule = ruleBlock = ruleSymbol.getBlock();
        this.currentASTResult = ruleSymbol.getId();
        this.saveText = ruleBlock.getAutoGen();
        if (ruleSymbol.comment != null) {
            this._println(ruleSymbol.comment);
        }
        this.print(ruleSymbol.access + " final ");
        if (ruleBlock.returnAction != null) {
            this._print(this.extractTypeOfAction(ruleBlock.returnAction, ruleBlock.getLine()) + ' ');
        } else {
            this._print("void ");
        }
        this._print(ruleSymbol.getId() + '(');
        this._print(this.commonExtraParams);
        if (this.commonExtraParams.length() != 0 && ruleBlock.argAction != null) {
            this._print(",");
        }
        if (ruleBlock.argAction != null) {
            this._println("");
            ++this.tabs;
            this.println(ruleBlock.argAction);
            --this.tabs;
            this.print(")");
        } else {
            this._print(")");
        }
        this._print(" throws " + this.exceptionThrown);
        if (this.grammar instanceof ParserGrammar) {
            this._print(", TokenStreamException");
        } else if (this.grammar instanceof LexerGrammar) {
            this._print(", CharStreamException, TokenStreamException");
        }
        if (ruleBlock.throwsSpec != null) {
            if (this.grammar instanceof LexerGrammar) {
                this.tool.error("user-defined throws spec not allowed (yet) for lexer rule " + ruleBlock.ruleName);
            } else {
                this._print(", " + ruleBlock.throwsSpec);
            }
        }
        this._println(" {");
        ++this.tabs;
        if (ruleBlock.returnAction != null) {
            this.println(ruleBlock.returnAction + ';');
        }
        this.println(this.commonLocalVars);
        if (this.grammar instanceof LexerGrammar) {
            if (ruleSymbol.getId().equals("mEOF")) {
                this.println("_ttype = Token.EOF_TYPE;");
            } else {
                this.println("_ttype = " + ruleSymbol.getId().substring(1) + ';');
            }
            this.println("int _saveIndex;");
        }
        this.genBlockPreamble(ruleBlock);
        this.println("");
        ExceptionSpec exceptionSpec = ruleBlock.findExceptionSpec("");
        if (exceptionSpec != null || ruleBlock.getDefaultErrorHandler()) {
            this.println("try {      // for error handling");
            ++this.tabs;
        }
        if (ruleBlock.alternatives.size() == 1) {
            object2 = ruleBlock.getAlternativeAt(0);
            object = ((Alternative)object2).semPred;
            if (object != null) {
                this.genSemPred((String)object, this.currentRule.line);
            }
            if (((Alternative)object2).synPred != null) {
                Utils.warning("Syntactic predicate ignored for single alternative", this.grammar.getFilename(), ((Alternative)object2).synPred.getLine());
            }
            this.genAlt((Alternative)object2, ruleBlock);
        } else {
            boolean bl2 = this.grammar.theLLkAnalyzer.deterministic(ruleBlock);
            object = this.genCommonBlock(ruleBlock, false);
            this.genBlockFinish((JavaBlockFinishingInfo)object, this.throwNoViable);
        }
        if (exceptionSpec != null || ruleBlock.getDefaultErrorHandler()) {
            --this.tabs;
            this.println("}");
        }
        if (exceptionSpec != null) {
            this.genErrorHandler(exceptionSpec);
        } else if (ruleBlock.getDefaultErrorHandler()) {
            this.println("catch (" + this.exceptionThrown + " ex) {");
            ++this.tabs;
            if (this.grammar.hasSyntacticPredicate) {
                this.println("if (inputState.guessing==0) {");
                ++this.tabs;
            }
            this.println("reportError(ex);");
            object2 = this.grammar.theLLkAnalyzer.FOLLOW(1, ruleBlock.endNode);
            object = this.getBitsetName(this.markBitsetForGen(((Lookahead)object2).fset));
            this.println("consume();");
            this.println("consumeUntil(" + (String)object + ");");
            if (this.grammar.hasSyntacticPredicate) {
                --this.tabs;
                this.println("} else {");
                this.println("  throw ex;");
                this.println("}");
            }
            --this.tabs;
            this.println("}");
        }
        if (ruleBlock.getTestLiterals()) {
            if (ruleSymbol.access.equals("protected")) {
                this.genLiteralsTestForPartialToken();
            } else {
                this.genLiteralsTest();
            }
        }
        if (this.grammar instanceof LexerGrammar) {
            this.println("if ( _createToken && _token==null && _ttype!=Token.SKIP ) {");
            this.println("\t_token = makeToken(_ttype);");
            this.println("\t_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));");
            this.println("}");
            this.println("_returnToken = _token;");
        }
        if (ruleBlock.returnAction != null) {
            this.println("return " + this.extractIdOfAction(ruleBlock.returnAction, ruleBlock.getLine()) + ';');
        }
        --this.tabs;
        this.println("}");
        this.println("");
    }

    private final void GenRuleInvocation(RuleRefElement ruleRefElement) {
        this._print(ruleRefElement.targetRule + '(');
        if (this.grammar instanceof LexerGrammar) {
            if (ruleRefElement.getLabel() != null) {
                this._print("true");
            } else {
                this._print("false");
            }
            if (this.commonExtraArgs.length() != 0 || ruleRefElement.args != null) {
                this._print(",");
            }
        }
        this._print(this.commonExtraArgs);
        if (this.commonExtraArgs.length() != 0 && ruleRefElement.args != null) {
            this._print(",");
        }
        RuleSymbol ruleSymbol = (RuleSymbol)this.grammar.getSymbol(ruleRefElement.targetRule);
        if (ruleRefElement.args != null) {
            String string = this.processActionForTreeSpecifiers(ruleRefElement.args, 0, this.currentRule);
            this._print(string);
            if (ruleSymbol.block.argAction == null) {
                Utils.warning("Rule '" + ruleRefElement.targetRule + "' accepts no arguments", this.grammar.getFilename(), ruleRefElement.getLine());
            }
        } else if (ruleSymbol.block.argAction != null) {
            Utils.warning("Missing parameters on reference to rule " + ruleRefElement.targetRule, this.grammar.getFilename(), ruleRefElement.getLine());
        }
        this._println(");");
    }

    private final void genSemPred(String string, int n) {
        string = this.processActionForTreeSpecifiers(string, n, this.currentRule);
        String string2 = this.charFormatter.escapeString(string);
        this.println("if (!(" + string + "))");
        this.println("  throw new SemanticException(\"" + string2 + "\");");
    }

    private final void genSynPred(SynPredBlock synPredBlock, String string) {
        this.println("boolean synPredMatched" + synPredBlock.ID + " = false;");
        this.println("if (" + string + ") {");
        ++this.tabs;
        this.println("int _m" + synPredBlock.ID + " = mark();");
        this.println("synPredMatched" + synPredBlock.ID + " = true;");
        this.println("inputState.guessing++;");
        ++this.syntacticPredLevel;
        this.println("try {");
        ++this.tabs;
        this.gen(synPredBlock);
        --this.tabs;
        this.println("}");
        this.println("catch (" + this.exceptionThrown + " pe) {");
        ++this.tabs;
        this.println("synPredMatched" + synPredBlock.ID + " = false;");
        --this.tabs;
        this.println("}");
        this.println("rewind(_m" + synPredBlock.ID + ");");
        this.println("inputState.guessing--;");
        --this.syntacticPredLevel;
        --this.tabs;
        this.println("}");
        this.println("if ( synPredMatched" + synPredBlock.ID + " ) {");
    }

    public void genTokenStrings() {
        this.println("");
        this.println("public static final String[] _tokenNames = {");
        ++this.tabs;
        Vector vector = this.grammar.tokenManager.getVocabulary();
        int n = 0;
        while (n < vector.size()) {
            TokenSymbol tokenSymbol;
            String string = (String)vector.elementAt(n);
            if (string == null) {
                string = "<" + String.valueOf(n) + '>';
            }
            if (!string.startsWith("\"") && !string.startsWith("<") && (tokenSymbol = this.grammar.tokenManager.getTokenSymbol(string)) != null && tokenSymbol.getParaphrase() != null) {
                string = Utils.stripFrontBack(tokenSymbol.getParaphrase(), "\"", "\"");
            }
            this.print(this.charFormatter.literalString(string));
            if (n != vector.size() - 1) {
                this._print(",");
            }
            this._println("");
            ++n;
        }
        --this.tabs;
        this.println("};");
    }

    private final void genTokenTypes(TokenManager tokenManager) throws IOException {
        this.setupOutput(tokenManager.getName() + TokenTypesFileSuffix);
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.getHeaderAction(""));
        this.println("public interface " + tokenManager.getName() + TokenTypesFileSuffix + " {");
        ++this.tabs;
        Vector vector = tokenManager.getVocabulary();
        this.println("int EOF = 1;");
        this.println("int NULL_TREE_LOOKAHEAD = 3;");
        int n = 4;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            if (string != null) {
                if (string.startsWith("\"")) {
                    StringLiteralSymbol stringLiteralSymbol = (StringLiteralSymbol)tokenManager.getTokenSymbol(string);
                    if (stringLiteralSymbol == null) {
                        Utils.panic("String literal " + string + " not in symbol table");
                    } else if (stringLiteralSymbol.label != null) {
                        this.println("int " + stringLiteralSymbol.label + " = " + n + ';');
                    } else {
                        String string2 = this.mangleLiteral(string);
                        if (string2 != null) {
                            this.println("int " + string2 + " = " + n + ';');
                            stringLiteralSymbol.label = string2;
                        } else {
                            this.println("// " + string + " = " + n);
                        }
                    }
                } else if (!string.startsWith("<")) {
                    this.println("int " + string + " = " + n + ';');
                }
            }
            ++n;
        }
        --this.tabs;
        this.println("}");
        this.currentOutput.close();
        this.currentOutput = null;
        this.exitIfError();
    }

    private final String getLookaheadTestExpression(Lookahead[] lookaheadArray, int n) {
        StringBuffer stringBuffer = new StringBuffer(100);
        boolean bl = true;
        stringBuffer.append("(");
        int n2 = 1;
        while (n2 <= n) {
            BitSet bitSet = lookaheadArray[n2].fset;
            if (!bl) {
                stringBuffer.append(") && (");
            }
            bl = false;
            if (lookaheadArray[n2].containsEpsilon()) {
                stringBuffer.append("true");
            } else {
                stringBuffer.append(this.getLookaheadTestTerm(n2, bitSet));
            }
            ++n2;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private final String getLookaheadTestExpression(Alternative alternative, int n) {
        int n2 = alternative.lookaheadDepth;
        if (n2 == Integer.MAX_VALUE) {
            n2 = this.grammar.maxk;
        }
        if (n == 0) {
            return "true";
        }
        return "(" + this.getLookaheadTestExpression(alternative.cache, n2) + ')';
    }

    private final String getLookaheadTestTerm(int n, BitSet bitSet) {
        String string = this.lookaheadString(n);
        int[] nArray = bitSet.toArray();
        if (JavaCodeGenerator.elementsAreRange(nArray)) {
            return this.getRangeExpression(n, nArray);
        }
        int n2 = bitSet.degree();
        if (n2 == 0) {
            return "true";
        }
        if (n2 >= this.bitsetTestThreshold) {
            int n3 = this.markBitsetForGen(bitSet);
            return this.getBitsetName(n3) + ".member(" + string + ')';
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n4 < nArray.length) {
            String string2 = this.getValueString(nArray[n4]);
            if (n4 > 0) {
                stringBuffer.append("||");
            }
            stringBuffer.append(string);
            stringBuffer.append("==");
            stringBuffer.append(string2);
            ++n4;
        }
        return stringBuffer.toString();
    }

    public String getRangeExpression(int n, int[] nArray) {
        if (!JavaCodeGenerator.elementsAreRange(nArray)) {
            Utils.panic("getRangeExpression called with non-range");
        }
        int n2 = nArray[0];
        int n3 = nArray[nArray.length - 1];
        return "(" + this.lookaheadString(n) + " >= " + this.getValueString(n2) + " && " + this.lookaheadString(n) + " <= " + this.getValueString(n3) + ')';
    }

    private final String getValueString(int n) {
        String string;
        if (this.grammar instanceof LexerGrammar) {
            string = this.charFormatter.literalChar(n);
        } else {
            TokenSymbol tokenSymbol = this.grammar.tokenManager.getTokenSymbolAt(n);
            if (tokenSymbol == null) {
                return "" + n;
            }
            String string2 = tokenSymbol.getId();
            if (tokenSymbol instanceof StringLiteralSymbol) {
                StringLiteralSymbol stringLiteralSymbol = (StringLiteralSymbol)tokenSymbol;
                String string3 = stringLiteralSymbol.getLabel();
                if (string3 != null) {
                    string = string3;
                } else {
                    string = this.mangleLiteral(string2);
                    if (string == null) {
                        string = String.valueOf(n);
                    }
                }
            } else {
                string = string2;
            }
        }
        return string;
    }

    private final boolean lookaheadIsEmpty(Alternative alternative, int n) {
        int n2 = alternative.lookaheadDepth;
        if (n2 == Integer.MAX_VALUE) {
            n2 = this.grammar.maxk;
        }
        int n3 = 1;
        while (n3 <= n2 && n3 <= n) {
            BitSet bitSet = alternative.cache[n3].fset;
            if (bitSet.degree() != 0) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private final String lookaheadString(int n) {
        return "LA(" + n + ')';
    }

    private final String mangleLiteral(String string) {
        String string2 = Main.literalsPrefix;
        int n = 1;
        while (n < string.length() - 1) {
            if (!Character.isLetter(string.charAt(n)) && string.charAt(n) != '_') {
                return null;
            }
            string2 = string2 + string.charAt(n);
            ++n;
        }
        if (Main.upperCaseMangledLiterals) {
            string2 = string2.toUpperCase();
        }
        return string2;
    }

    private final void setupGrammarParameters(Grammar grammar) {
        if (grammar instanceof ParserGrammar) {
            this.labeledElementType = "Token ";
            this.labeledElementInit = "null";
            this.commonExtraArgs = "";
            this.commonExtraParams = "";
            this.commonLocalVars = "";
            this.lt1Value = "LT(1)";
            this.exceptionThrown = "RecognitionException";
            this.throwNoViable = "throw new NoViableAltException(LT(1), getFilename());";
        } else if (grammar instanceof LexerGrammar) {
            this.labeledElementType = "char ";
            this.labeledElementInit = "'\\0'";
            this.commonExtraArgs = "";
            this.commonExtraParams = "boolean _createToken";
            this.commonLocalVars = "int _ttype; Token _token=null; int _begin=text.length();";
            this.lt1Value = "LA(1)";
            this.exceptionThrown = "RecognitionException";
            this.throwNoViable = "throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine());";
        } else {
            Utils.panic("Unknown grammar type");
        }
    }

    public void setupOutput(String string) throws IOException {
        this.currentOutput = this.tool.openOutputFile(string + ".java");
    }

    private final /* synthetic */ void this() {
        this.tabs = 0;
        this.grammar = null;
        this.makeSwitchThreshold = 2;
        this.bitsetTestThreshold = 4;
        this.syntacticPredLevel = 0;
        this.saveText = false;
        this.astVarNumber = 1;
    }

    public JavaCodeGenerator() {
        this.this();
        this.charFormatter = new JavaCharFormatter();
    }
}

