/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler.tools.antlr.compiler;

import at.dms.compiler.CompilerMessages;
import at.dms.compiler.tools.antlr.compiler.ANTLRLexer;
import at.dms.compiler.tools.antlr.compiler.ANTLRParser;
import at.dms.compiler.tools.antlr.compiler.AntlrOptions;
import at.dms.compiler.tools.antlr.compiler.GrammarFile;
import at.dms.compiler.tools.antlr.compiler.Hierarchy;
import at.dms.compiler.tools.antlr.compiler.JavaCodeGenerator;
import at.dms.compiler.tools.antlr.compiler.LLkAnalyzer;
import at.dms.compiler.tools.antlr.compiler.MakeGrammar;
import at.dms.compiler.tools.antlr.compiler.Utils;
import at.dms.compiler.tools.antlr.runtime.FileLineFormatter;
import at.dms.compiler.tools.antlr.runtime.RecognitionException;
import at.dms.compiler.tools.antlr.runtime.TokenBuffer;
import at.dms.compiler.tools.antlr.runtime.TokenStreamException;
import at.dms.util.Message;
import at.dms.util.MessageDescription;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Main {
    public static final String version = "1.5A";
    protected static String literalsPrefix = "LITERAL_";
    protected static boolean upperCaseMangledLiterals = false;
    protected boolean hasError;
    private AntlrOptions options;
    String grammarFile;

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        void var1_3;
        try {
            boolean n = Main.compile(stringArray);
        }
        catch (Throwable throwable) {
            System.err.println("Internal error: " + throwable.toString());
            System.err.println("Please send a bug report to kopi@dms.at");
            System.err.println("including the following stack trace.");
            System.err.println();
            throwable.printStackTrace();
            boolean bl = false;
        }
        System.exit(1 - var1_3);
    }

    public static boolean compile(String[] stringArray) {
        return new Main().run(stringArray);
    }

    public boolean run(String[] stringArray) {
        if (!this.parseArguments(stringArray)) {
            return false;
        }
        if (!this.preprocess()) {
            return false;
        }
        return this.process();
    }

    private final boolean parseArguments(String[] stringArray) {
        this.options = new AntlrOptions();
        if (!this.options.parseCommandLine(stringArray)) {
            return false;
        }
        if (this.options.nonOptions.length == 0) {
            this.options.usage();
            this.inform(CompilerMessages.NO_INPUT_FILE);
            return false;
        }
        return true;
    }

    public boolean preprocess() {
        Hierarchy hierarchy = new Hierarchy();
        String[] stringArray = this.options.nonOptions;
        int n = 0;
        while (n < stringArray.length) {
            try {
                hierarchy.readGrammarFile(stringArray[n]);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Utils.toolError("file " + stringArray[n] + " not found");
                return false;
            }
            ++n;
        }
        if (!hierarchy.verifyThatHierarchyIsComplete()) {
            return false;
        }
        this.grammarFile = stringArray[stringArray.length - 1];
        hierarchy.expandGrammarsInFile(this.grammarFile);
        GrammarFile grammarFile = hierarchy.getFile(this.grammarFile);
        String string = grammarFile.nameForExpandedGrammarFile(this.grammarFile);
        if (!string.equals(this.grammarFile)) {
            try {
                grammarFile.generateExpandedFile(this);
                this.grammarFile = this.options.destination + System.getProperty("file.separator") + string;
            }
            catch (IOException iOException) {
                Utils.toolError("cannot write expanded grammar file " + string);
                return false;
            }
        }
        return true;
    }

    public boolean process() {
        Reader reader = this.getGrammarReader();
        TokenBuffer tokenBuffer = new TokenBuffer(new ANTLRLexer(reader));
        LLkAnalyzer lLkAnalyzer = new LLkAnalyzer(this);
        MakeGrammar makeGrammar = new MakeGrammar(this, lLkAnalyzer);
        try {
            ANTLRParser aNTLRParser = new ANTLRParser(tokenBuffer, makeGrammar, this);
            aNTLRParser.setFilename(this.grammarFile);
            aNTLRParser.grammar();
            if (this.hasError) {
                System.err.println("Exiting due to errors.");
                return false;
            }
            JavaCodeGenerator javaCodeGenerator = new JavaCodeGenerator();
            javaCodeGenerator.setBehavior(makeGrammar);
            javaCodeGenerator.setAnalyzer(lLkAnalyzer);
            javaCodeGenerator.setTool(this);
            javaCodeGenerator.gen();
        }
        catch (RecognitionException recognitionException) {
            System.err.println("Unhandled parser error: " + recognitionException.getMessage());
            return false;
        }
        catch (TokenStreamException tokenStreamException) {
            System.err.println("TokenStreamException: " + tokenStreamException.getMessage());
            return false;
        }
        return true;
    }

    public void error(String string) {
        this.hasError = true;
        System.err.println("error: " + string);
    }

    public void error(String string, String string2, int n) {
        this.hasError = true;
        if (string2 != null) {
            System.err.println(FileLineFormatter.getFormatter().getFormatString(string2, n) + string);
        } else {
            System.err.println("line " + n + ": " + string);
        }
    }

    public String getOutputDirectory() {
        return this.options.destination;
    }

    public PrintWriter openOutputFile(String string) throws IOException {
        return new PrintWriter(new FileWriter(this.options.destination + System.getProperty("file.separator") + string));
    }

    public Reader getGrammarReader() {
        try {
            return new FileReader(this.grammarFile);
        }
        catch (IOException iOException) {
            Utils.panic("Error: cannot open grammar file " + this.grammarFile);
            System.exit(1);
            return null;
        }
    }

    public void inform(Message message) {
        this.inform(message.getMessage());
    }

    public void inform(MessageDescription messageDescription, Object[] objectArray) {
        this.inform(new Message(messageDescription, objectArray));
    }

    public void inform(MessageDescription messageDescription) {
        this.inform(messageDescription, null);
    }

    private final void inform(String string) {
        System.err.println(string);
        System.err.flush();
    }

    private final /* synthetic */ void this() {
        this.hasError = false;
    }

    public Main() {
        this.this();
    }
}

