/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler.tools.jperf;

import java.util.Enumeration;
import java.util.Hashtable;

class Node {
    private final long label;
    private long gValue;
    private Hashtable adjacency;
    private boolean visited;

    public long getLabel() {
        return this.label;
    }

    public long getGValue() {
        return this.gValue;
    }

    public void addAdjacency(Node node, long l) {
        this.adjacency.put(node, new Long(l));
    }

    public boolean getVisited() {
        return this.visited;
    }

    public void setVisited(boolean bl) {
        this.visited = bl;
    }

    public boolean reaches(Node node) {
        if (node == this) {
            return true;
        }
        this.setVisited(true);
        Enumeration enumeration = this.adjacency.keys();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)enumeration.nextElement();
            if (node2.getVisited() || !node2.reaches(node)) continue;
            return true;
        }
        return false;
    }

    public void assignGValue(long l, int n) {
        if (l < 0L || l >= (long)n) {
            System.err.println("Invalid g-value.");
        }
        if (this.gValue == (long)-1) {
            this.gValue = l;
            Enumeration enumeration = this.adjacency.keys();
            while (enumeration.hasMoreElements()) {
                Node node = (Node)enumeration.nextElement();
                l = ((Long)this.adjacency.get(node) - this.gValue + (long)n) % (long)n;
                node.assignGValue(l, n);
            }
        }
    }

    public Node(long l) {
        this.label = l;
        this.gValue = -1;
        this.adjacency = new Hashtable();
        this.visited = false;
    }
}

