/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler.tools.lexgen;

import at.dms.compiler.CompilerMessages;
import at.dms.compiler.tools.jperf.JPerf;
import at.dms.compiler.tools.lexgen.DefinitionFile;
import at.dms.compiler.tools.lexgen.LexgenError;
import at.dms.compiler.tools.lexgen.LexgenOptions;
import at.dms.util.Utils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;

public class Main {
    private static final int MIN_TOKEN_ID = 4;
    private LexgenOptions options;
    private DefinitionFile[] definitions;
    static /* synthetic */ Class class$java$lang$String;

    public static void main(String[] stringArray) {
        int n = new Main().run(stringArray);
        System.exit(1 - n);
    }

    public boolean run(String[] stringArray) {
        if (!this.parseArguments(stringArray)) {
            return false;
        }
        if (!this.parseSourceFiles(this.options.nonOptions)) {
            return false;
        }
        if (!this.checkIdentifiers()) {
            return false;
        }
        if (this.options.definition && !this.buildDefinitionFile()) {
            return false;
        }
        if (this.options.inter && !this.buildInterfaceFile()) {
            return false;
        }
        if (this.options.keywords && !this.buildKeywordFile()) {
            return false;
        }
        return !this.options.flexrules || this.buildFlexRulesFile();
    }

    private final boolean parseArguments(String[] stringArray) {
        this.options = new LexgenOptions();
        if (!this.options.parseCommandLine(stringArray)) {
            return false;
        }
        if (this.options.nonOptions.length == 0) {
            System.err.println(CompilerMessages.NO_INPUT_FILE.getFormat());
            this.options.usage();
            return false;
        }
        if (!(this.options.definition || this.options.inter || this.options.keywords)) {
            this.options.usage();
            return false;
        }
        if (this.options.tokens) {
            this.options.inter = true;
        }
        return true;
    }

    private final boolean parseSourceFiles(String[] stringArray) {
        boolean bl = false;
        this.definitions = new DefinitionFile[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            try {
                this.definitions[n] = DefinitionFile.read(stringArray[n]);
            }
            catch (LexgenError lexgenError) {
                System.err.println(lexgenError.getMessage());
                bl = true;
            }
            ++n;
        }
        return bl ^ true;
    }

    private final boolean checkIdentifiers() {
        Hashtable hashtable = new Hashtable();
        boolean bl = false;
        String string = this.definitions[this.definitions.length - 1].getPrefix();
        int n = 4;
        int n2 = 0;
        while (n2 < this.definitions.length) {
            try {
                n = this.definitions[n2].checkIdentifiers(hashtable, string, n);
            }
            catch (LexgenError lexgenError) {
                System.err.println(lexgenError.getMessage());
                bl = true;
            }
            ++n2;
        }
        return bl ^ true;
    }

    private final boolean buildDefinitionFile() {
        String string = this.definitions[this.definitions.length - 1].getVocabulary();
        String string2 = this.definitions[this.definitions.length - 1].getPrefix();
        File file = new File(string + "TokenTypes.txt");
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            printWriter.println(string + " // output vocabulary");
            int n = 0;
            while (n < this.definitions.length) {
                this.definitions[n].printDefinition(printWriter, string2);
                ++n;
            }
            printWriter.flush();
            printWriter.close();
            return true;
        }
        catch (IOException iOException) {
            System.err.println("I/O Exception on " + file.getPath() + ": " + iOException.getMessage());
            return false;
        }
    }

    private final boolean buildInterfaceFile() {
        DefinitionFile definitionFile = this.definitions[this.definitions.length - 1];
        String string = definitionFile.getVocabulary();
        File file = new File(string + "TokenTypes.java");
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            definitionFile.printInterface(printWriter, this.definitions.length == 1 ? null : this.definitions[this.definitions.length - 2].getClassName(), this.options.tokens);
            printWriter.flush();
            printWriter.close();
            return true;
        }
        catch (IOException iOException) {
            System.err.println("I/O Exception on " + file.getPath() + ": " + iOException.getMessage());
            return false;
        }
    }

    private final boolean buildFlexRulesFile() {
        DefinitionFile definitionFile = this.definitions[this.definitions.length - 1];
        String string = definitionFile.getVocabulary();
        File file = new File(string + "FlexRules.txt");
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            int n = 0;
            while (n < this.definitions.length) {
                this.definitions[n].printFlexRules(printWriter);
                ++n;
            }
            printWriter.flush();
            printWriter.close();
            return true;
        }
        catch (IOException iOException) {
            System.err.println("I/O Exception on " + file.getPath() + ": " + iOException.getMessage());
            return false;
        }
    }

    private final boolean buildKeywordFile() {
        String string = this.definitions[this.definitions.length - 1].getVocabulary();
        String string2 = this.definitions[this.definitions.length - 1].getPrefix();
        String string3 = this.definitions[this.definitions.length - 1].getPackageName();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        int n = 0;
        while (n < this.definitions.length) {
            this.definitions[n].putKeywords(vector, vector2, string2);
            ++n;
        }
        vector3.addElement("// Generated by JPerf");
        vector3.addElement("package " + string3 + ';');
        vector3.addElement("import at.dms.compiler.tools.antlr.extra.CToken;\n");
        vector3.addElement("/*package*/ final class " + string + "Keywords implements " + string + "TokenTypes {");
        vector3.addElement("  public static CToken lookup(final char[] data, int offset, int length) {");
        vector3.addElement("    return tokens[find(data, offset, length) + 1];");
        vector3.addElement("  }");
        vector3.addElement("  private static final CToken[] tokens = new CToken[] {\n    null,");
        n = 0;
        while (n < vector2.size()) {
            String string4 = "    new CToken(" + (String)vector2.elementAt(n) + ", \"" + (String)vector.elementAt(n) + "\")";
            if (n < vector2.size() - 1) {
                vector3.addElement(string4 + ',');
            } else {
                vector3.addElement(string4);
            }
            ++n;
        }
        vector3.addElement("  };");
        vector4.addElement("}");
        try {
            Class clazz = class$java$lang$String;
            if (clazz == null) {
                clazz = class$java$lang$String = Main.class$("[Ljava.lang.String;", false);
            }
            String[] stringArray = (String[])Utils.toArray(vector, clazz);
            Class clazz2 = class$java$lang$String;
            if (clazz2 == null) {
                clazz2 = class$java$lang$String = Main.class$("[Ljava.lang.String;", false);
            }
            String[] stringArray2 = (String[])Utils.toArray(vector3, clazz2);
            Class clazz3 = class$java$lang$String;
            if (clazz3 == null) {
                clazz3 = class$java$lang$String = Main.class$("[Ljava.lang.String;", false);
            }
            JPerf jPerf = new JPerf(stringArray, stringArray2, (String[])Utils.toArray(vector4, clazz3));
            jPerf.build();
            jPerf.genCode(string + "Keywords.java");
            return true;
        }
        catch (IOException iOException) {
            System.err.println("I/O Exception on " + string + "Keywords.java: " + iOException.getMessage());
            return false;
        }
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

