/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler.tools.msggen;

import at.dms.compiler.CompilerMessages;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.tools.antlr.runtime.ParserException;
import at.dms.compiler.tools.msggen.MessageDefinition;
import at.dms.compiler.tools.msggen.MsggenError;
import at.dms.compiler.tools.msggen.MsggenLexer;
import at.dms.compiler.tools.msggen.MsggenParser;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Hashtable;

class DefinitionFile {
    private static final String DEFAULT_PREFIX = "";
    private final String sourceFile;
    private final String fileHeader;
    private final String packageName;
    private final String prefix;
    private final String parent;
    private final MessageDefinition[] definitions;

    public static DefinitionFile read(String string) throws MsggenError {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            MsggenLexer msggenLexer = new MsggenLexer(bufferedInputStream);
            MsggenParser msggenParser = new MsggenParser(msggenLexer);
            DefinitionFile definitionFile = msggenParser.aCompilationUnit(string);
            ((InputStream)bufferedInputStream).close();
            return definitionFile;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MsggenError(CompilerMessages.FILE_NOT_FOUND, string);
        }
        catch (IOException iOException) {
            throw new MsggenError(CompilerMessages.IO_EXCEPTION, string, iOException.getMessage());
        }
        catch (ParserException parserException) {
            throw new MsggenError(CompilerMessages.FORMATTED_ERROR, (Object)new PositionedError(new TokenReference(string, parserException.getLine()), CompilerMessages.SYNTAX_ERROR, (Object)parserException.getMessage()));
        }
    }

    public void checkIdentifiers(Hashtable hashtable) throws MsggenError {
        int n = 0;
        while (n < this.definitions.length) {
            this.definitions[n].checkIdentifiers(hashtable, this.sourceFile);
            ++n;
        }
    }

    public void printFile(PrintWriter printWriter) {
        if (this.fileHeader != null) {
            printWriter.println(this.fileHeader);
        }
        printWriter.print("// Generated by msggen from " + this.sourceFile);
        printWriter.println();
        printWriter.println("package " + this.packageName + ';');
        printWriter.println();
        printWriter.println("import at.dms.util.MessageDescription;");
        printWriter.println();
        printWriter.print("public interface " + this.prefix + "Messages");
        printWriter.print(this.parent == null ? DEFAULT_PREFIX : " extends " + this.parent);
        printWriter.println(" {");
        int n = 0;
        while (n < this.definitions.length) {
            this.definitions[n].printInterface(printWriter, this.prefix);
            ++n;
        }
        printWriter.println("}");
    }

    public String getClassName() {
        return this.packageName + '.' + this.prefix + "Messages";
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public DefinitionFile(String string, String string2, String string3, String string4, String string5, MessageDefinition[] messageDefinitionArray) {
        this.sourceFile = string;
        this.fileHeader = string2;
        this.packageName = string3;
        this.prefix = string4 == null ? DEFAULT_PREFIX : string4;
        this.parent = string5;
        this.definitions = messageDefinitionArray;
    }
}

