/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler.tools.optgen;

import at.dms.compiler.tools.optgen.OptgenError;
import at.dms.compiler.tools.optgen.OptgenMessages;
import java.io.PrintWriter;
import java.util.Hashtable;

class OptionDefinition {
    private final String longname;
    private final String shortname;
    private final String type;
    private final String defaultValue;
    private final String argument;
    private final String help;

    private static final String trail(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() < 2) {
            return string;
        }
        return string.substring(1, string.length() - 1);
    }

    public void checkIdentifiers(Hashtable hashtable, String string) throws OptgenError {
        String string2 = (String)hashtable.get(this.longname);
        if (string2 != null) {
            throw new OptgenError(OptgenMessages.DUPLICATE_DEFINITION, new Object[]{this.longname, string, string2});
        }
        hashtable.put(this.longname, string);
    }

    public void checkShortcuts(Hashtable hashtable, String string) throws OptgenError {
        String string2 = (String)hashtable.get(this.shortname);
        if (string2 != null) {
            throw new OptgenError(OptgenMessages.DUPLICATE_SHORTCUT, new Object[]{this.shortname, string, string2});
        }
        hashtable.put(this.shortname, string);
    }

    public void printParseArgument(PrintWriter printWriter) {
        printWriter.print("    case '");
        printWriter.print(this.shortname);
        printWriter.println("':");
        printWriter.print("      ");
        printWriter.print(this.longname);
        printWriter.print(" = ");
        if (this.argument == null) {
            printWriter.print("!" + this.defaultValue);
            printWriter.print(";");
        } else {
            String string;
            String string2 = this.argument;
            if (this.type.equals("int")) {
                string = "getInt";
                if (string2 == null || string2.equals("")) {
                    string2 = "0";
                }
            } else {
                string = "getString";
                string2 = "\"" + string2 + '\"';
            }
            printWriter.print(string + "(g, " + string2 + ')');
            printWriter.print(";");
        }
        printWriter.println(" return true;");
    }

    public void printFields(PrintWriter printWriter) {
        printWriter.print("  public ");
        printWriter.print(this.type);
        printWriter.print(" ");
        printWriter.print(this.longname);
        printWriter.print(" = ");
        if (!this.type.equals("String") || this.defaultValue.equals("null")) {
            printWriter.print(this.defaultValue);
        } else {
            printWriter.print("\"" + this.defaultValue + '\"');
        }
        printWriter.println(";");
    }

    public void printUsage(PrintWriter printWriter) {
        String string = "\"  --";
        string = string + this.longname;
        string = string + ", -";
        string = string + this.shortname;
        if (this.argument != null) {
            string = string + '<' + this.type + '>';
        }
        string = string + ": ";
        int n = string.length();
        while (n < 25) {
            string = string + ' ';
            ++n;
        }
        printWriter.print(string + this.help);
        if (!this.defaultValue.equals("null")) {
            printWriter.print(" [");
            printWriter.print(this.defaultValue);
            printWriter.print("]");
        }
        printWriter.print("\"");
    }

    public void printLongOpts(PrintWriter printWriter) {
        printWriter.print("    new LongOpt(\"");
        printWriter.print(this.longname);
        printWriter.print("\", ");
        if (this.argument == null) {
            printWriter.print("LongOpt.NO_ARGUMENT");
        } else if (this.argument.equals("")) {
            printWriter.print("LongOpt.REQUIRED_ARGUMENT");
        } else {
            printWriter.print("LongOpt.OPTIONAL_ARGUMENT");
        }
        printWriter.print(", null, '");
        printWriter.print(this.shortname);
        printWriter.print("')");
    }

    public void printShortOption(PrintWriter printWriter) {
        printWriter.print(this.shortname);
        if (this.argument != null) {
            if (this.argument.equals("")) {
                printWriter.print(":");
            } else {
                printWriter.print("::");
            }
        }
    }

    public OptionDefinition(String string, String string2, String string3, String string4, String string5, String string6) {
        this.longname = OptionDefinition.trail(string);
        this.shortname = OptionDefinition.trail(string2);
        this.type = string3;
        this.defaultValue = OptionDefinition.trail(string4);
        this.argument = OptionDefinition.trail(string5);
        this.help = OptionDefinition.trail(string6);
    }
}

