/*
 * Decompiled with CFR 0.152.
 */
package at.dms.dis;

import at.dms.classfile.AbstractInstructionAccessor;
import at.dms.classfile.AccessorContainer;
import at.dms.classfile.ClassConstant;
import at.dms.classfile.ClassRefInstruction;
import at.dms.classfile.FieldRefConstant;
import at.dms.classfile.FieldRefInstruction;
import at.dms.classfile.IincInstruction;
import at.dms.classfile.Instruction;
import at.dms.classfile.InterfaceConstant;
import at.dms.classfile.InvokeinterfaceInstruction;
import at.dms.classfile.JumpInstruction;
import at.dms.classfile.LineNumberInfo;
import at.dms.classfile.LocalVarInstruction;
import at.dms.classfile.MethodRefConstant;
import at.dms.classfile.MethodRefInstruction;
import at.dms.classfile.MultiarrayInstruction;
import at.dms.classfile.NewarrayInstruction;
import at.dms.classfile.NoArgInstruction;
import at.dms.classfile.PushLiteralInstruction;
import at.dms.classfile.SwitchInstruction;
import at.dms.dis.Disassembler;
import at.dms.dis.IndentingWriter;
import at.dms.dis.OpcodeNames;
import java.util.Vector;

class InstructionHandle
extends AbstractInstructionAccessor {
    private final Instruction instruction;
    private final int address;
    private Vector lineNumbers;
    private boolean isTarget;

    public void attachTo(AccessorContainer accessorContainer) {
        if (accessorContainer instanceof LineNumberInfo) {
            if (this.lineNumbers == null) {
                this.lineNumbers = new Vector();
            }
            this.lineNumbers.addElement(new Integer(((LineNumberInfo)accessorContainer).getLine()));
        } else {
            this.isTarget = true;
        }
    }

    public String getLabel() {
        return "_L" + this.address;
    }

    public void write(IndentingWriter indentingWriter, boolean bl) {
        if (this.lineNumbers != null) {
            int n = 0;
            while (n < this.lineNumbers.size()) {
                indentingWriter.println();
                indentingWriter.print("@line\t" + (Integer)this.lineNumbers.elementAt(n));
                ++n;
            }
        }
        indentingWriter.println();
        if (this.isTarget) {
            indentingWriter.print(this.getLabel() + ':');
        }
        if (bl) {
            indentingWriter.print("\t/* N/A */\t");
        }
        indentingWriter.print("\t");
        this.writeInstruction(indentingWriter, this.instruction);
    }

    private final void writeInstruction(IndentingWriter indentingWriter, Instruction instruction) {
        if (instruction instanceof ClassRefInstruction) {
            this.writeClassRefInstruction(indentingWriter, (ClassRefInstruction)instruction);
        } else if (instruction instanceof FieldRefInstruction) {
            this.writeFieldRefInstruction(indentingWriter, (FieldRefInstruction)instruction);
        } else if (instruction instanceof IincInstruction) {
            this.writeIincInstruction(indentingWriter, (IincInstruction)instruction);
        } else if (instruction instanceof InvokeinterfaceInstruction) {
            this.writeInvokeinterfaceInstruction(indentingWriter, (InvokeinterfaceInstruction)instruction);
        } else if (instruction instanceof JumpInstruction) {
            this.writeJumpInstruction(indentingWriter, (JumpInstruction)instruction);
        } else if (instruction instanceof LocalVarInstruction) {
            this.writeLocalVarInstruction(indentingWriter, (LocalVarInstruction)instruction);
        } else if (instruction instanceof MethodRefInstruction) {
            this.writeMethodRefInstruction(indentingWriter, (MethodRefInstruction)instruction);
        } else if (instruction instanceof MultiarrayInstruction) {
            this.writeMultiarrayInstruction(indentingWriter, (MultiarrayInstruction)instruction);
        } else if (instruction instanceof NewarrayInstruction) {
            this.writeNewarrayInstruction(indentingWriter, (NewarrayInstruction)instruction);
        } else if (instruction instanceof NoArgInstruction) {
            this.writeNoArgInstruction(indentingWriter, (NoArgInstruction)instruction);
        } else if (instruction instanceof PushLiteralInstruction) {
            this.writePushLiteralInstruction(indentingWriter, (PushLiteralInstruction)instruction);
        } else if (instruction instanceof SwitchInstruction) {
            this.writeSwitchInstruction(indentingWriter, (SwitchInstruction)instruction);
        } else {
            this.writeOpcode(indentingWriter, "@unknown");
            indentingWriter.print("opcode=" + instruction.getOpcode());
        }
    }

    private final void writeOpcode(IndentingWriter indentingWriter, String string) {
        indentingWriter.print(string);
        indentingWriter.print(string.length() < 8 ? "\t\t" : "\t");
    }

    private final void writeOpcode(IndentingWriter indentingWriter, int n) {
        this.writeOpcode(indentingWriter, OpcodeNames.getName(n));
    }

    private final void writeClassRefInstruction(IndentingWriter indentingWriter, ClassRefInstruction classRefInstruction) {
        this.writeOpcode(indentingWriter, classRefInstruction.getOpcode());
        this.printClassRef(indentingWriter, classRefInstruction.getClassConstant());
    }

    private final void writeFieldRefInstruction(IndentingWriter indentingWriter, FieldRefInstruction fieldRefInstruction) {
        this.writeOpcode(indentingWriter, fieldRefInstruction.getOpcode());
        this.printFieldRef(indentingWriter, fieldRefInstruction.getFieldRefConstant());
    }

    private final void writeIincInstruction(IndentingWriter indentingWriter, IincInstruction iincInstruction) {
        this.writeOpcode(indentingWriter, iincInstruction.getOpcode());
        indentingWriter.print(iincInstruction.getVariable());
        indentingWriter.print(" ");
        indentingWriter.print(iincInstruction.getIncrement());
    }

    private final void writeInvokeinterfaceInstruction(IndentingWriter indentingWriter, InvokeinterfaceInstruction invokeinterfaceInstruction) {
        this.writeOpcode(indentingWriter, invokeinterfaceInstruction.getOpcode());
        this.printInterfaceRef(indentingWriter, invokeinterfaceInstruction.getInterfaceConstant());
        indentingWriter.print(" ");
        indentingWriter.print(invokeinterfaceInstruction.getNbArgs());
    }

    private final void writeJumpInstruction(IndentingWriter indentingWriter, JumpInstruction jumpInstruction) {
        this.writeOpcode(indentingWriter, jumpInstruction.getOpcode());
        this.printInstructionHandle(indentingWriter, (InstructionHandle)jumpInstruction.getTarget());
    }

    private final void writeLocalVarInstruction(IndentingWriter indentingWriter, LocalVarInstruction localVarInstruction) {
        this.writeOpcode(indentingWriter, localVarInstruction.getOpcode());
        indentingWriter.print(localVarInstruction.getIndex());
    }

    private final void writeMethodRefInstruction(IndentingWriter indentingWriter, MethodRefInstruction methodRefInstruction) {
        this.writeOpcode(indentingWriter, methodRefInstruction.getOpcode());
        this.printMethodRef(indentingWriter, methodRefInstruction.getMethodRefConstant());
    }

    private final void writeMultiarrayInstruction(IndentingWriter indentingWriter, MultiarrayInstruction multiarrayInstruction) {
        this.writeOpcode(indentingWriter, multiarrayInstruction.getOpcode());
        this.printFieldSignature(indentingWriter, multiarrayInstruction.getType());
        indentingWriter.print(" ");
        indentingWriter.print(multiarrayInstruction.getDimension());
    }

    private final void writeNewarrayInstruction(IndentingWriter indentingWriter, NewarrayInstruction newarrayInstruction) {
        this.writeOpcode(indentingWriter, newarrayInstruction.getOpcode());
        indentingWriter.print(newarrayInstruction.getType());
    }

    private final void writeNoArgInstruction(IndentingWriter indentingWriter, NoArgInstruction noArgInstruction) {
        this.writeOpcode(indentingWriter, noArgInstruction.getOpcode());
    }

    private final void writePushLiteralInstruction(IndentingWriter indentingWriter, PushLiteralInstruction pushLiteralInstruction) {
        this.writeOpcode(indentingWriter, pushLiteralInstruction.getOpcode());
        indentingWriter.print(Disassembler.convertLiteral(pushLiteralInstruction.getLiteral()));
    }

    private final void writeSwitchInstruction(IndentingWriter indentingWriter, SwitchInstruction switchInstruction) {
        this.writeOpcode(indentingWriter, switchInstruction.getOpcode());
        int n = 0;
        while (n < switchInstruction.getSwitchCount()) {
            indentingWriter.println();
            indentingWriter.print("\t\t\t" + switchInstruction.getMatch(n) + ": ");
            this.printInstructionHandle(indentingWriter, (InstructionHandle)switchInstruction.getTarget(n));
            ++n;
        }
        indentingWriter.println();
        indentingWriter.print("\t\t\t@default: ");
        this.printInstructionHandle(indentingWriter, (InstructionHandle)switchInstruction.getTarget(-1));
    }

    private final void printClassRef(IndentingWriter indentingWriter, ClassConstant classConstant) {
        String string = classConstant.getName();
        if (string.charAt(0) == '[') {
            this.printFieldSignature(indentingWriter, string);
        } else {
            this.printQualifiedName(indentingWriter, string);
        }
    }

    private final void printFieldRef(IndentingWriter indentingWriter, FieldRefConstant fieldRefConstant) {
        this.printFieldSignature(indentingWriter, fieldRefConstant.getType());
        indentingWriter.print(" ");
        this.printQualifiedName(indentingWriter, fieldRefConstant.getName());
    }

    private final void printInterfaceRef(IndentingWriter indentingWriter, InterfaceConstant interfaceConstant) {
        this.printMethodSpec(indentingWriter, interfaceConstant.getName(), interfaceConstant.getType());
    }

    private final void printMethodRef(IndentingWriter indentingWriter, MethodRefConstant methodRefConstant) {
        this.printMethodSpec(indentingWriter, methodRefConstant.getName(), methodRefConstant.getType());
    }

    private final void printMethodSpec(IndentingWriter indentingWriter, String string, String string2) {
        String[] stringArray = Disassembler.convertMethodSignature(string2);
        indentingWriter.print(stringArray[1] + ' ' + Disassembler.convertQualifiedName(string) + stringArray[0]);
    }

    private final void printFieldSignature(IndentingWriter indentingWriter, String string) {
        indentingWriter.print(Disassembler.convertFieldSignature(string));
    }

    private final void printQualifiedName(IndentingWriter indentingWriter, String string) {
        indentingWriter.print(Disassembler.convertQualifiedName(string));
    }

    private final void printInstructionHandle(IndentingWriter indentingWriter, InstructionHandle instructionHandle) {
        indentingWriter.print(instructionHandle.getLabel());
    }

    public InstructionHandle(Instruction instruction, int n) {
        this.instruction = instruction;
        this.address = n;
        this.isTarget = false;
    }
}

