/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CClass;
import at.dms.kjc.CReferenceType;
import at.dms.kjc.CStdType;
import at.dms.kjc.CType;
import at.dms.kjc.CTypeContext;
import at.dms.kjc.Constants;
import at.dms.kjc.KjcMessages;
import at.dms.util.InconsistencyException;
import at.dms.util.SimpleStringBuffer;

public class CArrayType
extends CReferenceType {
    private CType baseType;
    private int arrayBound;

    public String toString() {
        String string = this.baseType.toString();
        int n = 0;
        while (n < this.arrayBound) {
            string = string + "[]";
            ++n;
        }
        return string;
    }

    public String getQualifiedName() {
        return this.getSignature();
    }

    public void appendSignature(SimpleStringBuffer simpleStringBuffer) {
        int n = 0;
        while (n < this.arrayBound) {
            simpleStringBuffer.append('[');
            ++n;
        }
        this.baseType.appendSignature(simpleStringBuffer);
    }

    public int getSize() {
        return 1;
    }

    public boolean isReference() {
        return true;
    }

    public boolean isArrayType() {
        return true;
    }

    public CType getBaseType() {
        boolean bl = false;
        if (this.baseType != null) {
            bl = true;
        }
        CArrayType.verify(bl);
        CArrayType.verify(this.baseType instanceof CArrayType ^ true);
        return this.baseType;
    }

    public CType getElementType() {
        boolean bl = false;
        if (this.baseType != null) {
            bl = true;
        }
        CArrayType.verify(bl);
        CArrayType.verify(this.baseType instanceof CArrayType ^ true);
        if (this.arrayBound == 1) {
            return this.baseType;
        }
        CArrayType cArrayType = new CArrayType(this.baseType, this.arrayBound - 1);
        cArrayType.setClass(this.getCClass());
        return cArrayType;
    }

    public int getArrayBound() {
        return this.arrayBound;
    }

    public CType getErasure(CTypeContext cTypeContext) throws UnpositionedError {
        if (this.baseType.isReference()) {
            return new CArrayType(this.baseType.getErasure(cTypeContext), this.arrayBound).checkType(cTypeContext);
        }
        return this;
    }

    public boolean checked() {
        return this.baseType.checked();
    }

    public boolean equals(CType cType) {
        if (!cType.isArrayType()) {
            return false;
        }
        CArrayType cArrayType = (CArrayType)cType;
        boolean bl = false;
        if (this.baseType.equals(cArrayType.baseType) && this.arrayBound == cArrayType.arrayBound) {
            bl = true;
        }
        return bl;
    }

    public boolean equals(CType cType, CReferenceType[] cReferenceTypeArray) {
        if (!cType.isArrayType()) {
            return false;
        }
        CArrayType cArrayType = (CArrayType)cType;
        boolean bl = false;
        if (this.baseType.equals(cArrayType.baseType, cReferenceTypeArray) && this.arrayBound == cArrayType.arrayBound) {
            bl = true;
        }
        return bl;
    }

    public CType checkType(CTypeContext cTypeContext) throws UnpositionedError {
        if (!this.isChecked()) {
            if (this.arrayBound > 255) {
                throw new UnpositionedError(KjcMessages.OVERSIZED_ARRAY_BOUND, this.baseType);
            }
            this.baseType = this.baseType.checkType(cTypeContext);
            this.setClass(cTypeContext.getTypeFactory().createReferenceType(8).getCClass());
        }
        return this;
    }

    public CClass getCClass() {
        if (!this.isChecked()) {
            throw new InconsistencyException("type not checked");
        }
        return super.getCClass();
    }

    public boolean isAssignableTo(CTypeContext cTypeContext, CType cType, CReferenceType[] cReferenceTypeArray) {
        if (!cType.isArrayType()) {
            try {
                boolean bl = false;
                if (cType.equals(cTypeContext.getTypeFactory().createReferenceType(8)) || cType.equals(cTypeContext.getTypeFactory().createType(Constants.JAV_SERIALIZABLE, true).checkType(cTypeContext)) || cType.equals(cTypeContext.getTypeFactory().createType(Constants.JAV_CLONEABLE, true).checkType(cTypeContext))) {
                    bl = true;
                }
                return bl;
            }
            catch (UnpositionedError unpositionedError) {
                throw new InconsistencyException("Failure while loading standard types.");
            }
        }
        if (this.arrayBound == ((CArrayType)cType).arrayBound) {
            boolean bl = false;
            if (this.baseType.isPrimitive() && this.baseType.equals(((CArrayType)cType).baseType) || !this.baseType.isPrimitive() && this.baseType.isAssignableTo(cTypeContext, ((CArrayType)cType).baseType, cReferenceTypeArray)) {
                bl = true;
            }
            return bl;
        }
        if (this.arrayBound < ((CArrayType)cType).arrayBound) {
            return false;
        }
        return ((CArrayType)cType).baseType.equals(cTypeContext.getTypeFactory().createReferenceType(8));
    }

    public boolean isAssignableTo(CTypeContext cTypeContext, CType cType, boolean bl) {
        if (!cType.isArrayType()) {
            try {
                boolean bl2 = false;
                if (cType.equals(cTypeContext.getTypeFactory().createReferenceType(8)) || cType.equals(cTypeContext.getTypeFactory().createType(Constants.JAV_SERIALIZABLE, true).checkType(cTypeContext)) || cType.equals(cTypeContext.getTypeFactory().createType(Constants.JAV_CLONEABLE, true).checkType(cTypeContext))) {
                    bl2 = true;
                }
                return bl2;
            }
            catch (UnpositionedError unpositionedError) {
                throw new InconsistencyException("Failure while loading standard types.");
            }
        }
        if (this.arrayBound == ((CArrayType)cType).arrayBound) {
            boolean bl3 = false;
            if (this.baseType.isPrimitive() && this.baseType.equals(((CArrayType)cType).baseType) || !this.baseType.isPrimitive() && this.baseType.isAssignableTo(cTypeContext, ((CArrayType)cType).baseType, bl)) {
                bl3 = true;
            }
            return bl3;
        }
        if (this.arrayBound < ((CArrayType)cType).arrayBound) {
            return false;
        }
        return ((CArrayType)cType).baseType.equals(cTypeContext.getTypeFactory().createReferenceType(8));
    }

    public boolean isCastableTo(CType cType) {
        if (cType.isArrayType()) {
            CType cType2 = ((CArrayType)cType).baseType;
            int n = ((CArrayType)cType).arrayBound;
            if (this.arrayBound == n) {
                if (this.baseType.isPrimitive()) {
                    boolean bl = false;
                    if (this.baseType == cType2) {
                        bl = true;
                    }
                    return bl;
                }
                return this.baseType.isCastableTo(cType2);
            }
            if (this.arrayBound < n) {
                return this.baseType.isCastableTo(new CArrayType(cType2, n - this.arrayBound));
            }
            return new CArrayType(this.baseType, this.arrayBound - n).isCastableTo(cType2);
        }
        if (cType.isClassType()) {
            if (cType.equals(CStdType.Object)) {
                return true;
            }
            return cType.getCClass().getQualifiedName().equals(Constants.JAV_CLONEABLE);
        }
        return false;
    }

    public CArrayType(CType cType, int n) {
        this.type = 10;
        boolean bl = false;
        if (cType != null) {
            bl = true;
        }
        CArrayType.verify(bl);
        boolean bl2 = false;
        if (n > 0) {
            bl2 = true;
        }
        CArrayType.verify(bl2);
        if (cType.isArrayType()) {
            this.arrayBound = n + ((CArrayType)cType).arrayBound;
            this.baseType = ((CArrayType)cType).baseType;
        } else {
            this.arrayBound = n;
            this.baseType = cType;
        }
    }
}

