/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.kjc.CClass;
import at.dms.kjc.CField;
import at.dms.kjc.CMethod;
import at.dms.kjc.CModifier;
import at.dms.kjc.CReferenceType;
import at.dms.kjc.CSourceClass;
import at.dms.kjc.CTypeVariable;
import at.dms.kjc.Constants;
import at.dms.util.InconsistencyException;
import at.dms.util.Utils;

public abstract class CMember
extends Utils
implements Constants {
    protected CClass owner;
    private int modifiers;
    private String ident;
    private boolean deprecated;
    protected boolean synthetic;

    public CClass getOwner() {
        return this.owner;
    }

    public CReferenceType getOwnerType() {
        return this.owner == null ? null : this.owner.getAbstractType();
    }

    public String getIdent() {
        return this.ident;
    }

    public String getQualifiedName() {
        return this.owner.getQualifiedName() + '/' + this.ident;
    }

    public String getPrefixName() {
        return this.owner.getQualifiedName();
    }

    public String getJavaName() {
        return this.getQualifiedName().replace('/', '.');
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int n) {
        this.modifiers = n;
    }

    public CField getField() {
        throw new InconsistencyException();
    }

    public CMethod getMethod() {
        throw new InconsistencyException();
    }

    public CClass getCClass() {
        throw new InconsistencyException();
    }

    public abstract CTypeVariable lookupTypeVariable(String var1);

    public boolean isStatic() {
        return CModifier.contains(this.modifiers, 8);
    }

    public boolean isPublic() {
        return CModifier.contains(this.modifiers, 1);
    }

    public boolean isProtected() {
        return CModifier.contains(this.modifiers, 4);
    }

    public boolean isPrivate() {
        return CModifier.contains(this.modifiers, 2);
    }

    public boolean isFinal() {
        return CModifier.contains(this.modifiers, 16);
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public boolean isAccessible(CClass cClass) {
        if (this.isPublic() || cClass.isDefinedInside(this.owner) || this.owner.isDefinedInside(cClass)) {
            return true;
        }
        if (cClass.isNested() && this.isAccessible(cClass.getOwner())) {
            return true;
        }
        if (!this.isPrivate() && this.owner.getPackage() == cClass.getPackage()) {
            return true;
        }
        return this.isProtected() && cClass.descendsFrom(this.owner);
    }

    public boolean requiresAccessor(CClass cClass, boolean bl) {
        if (this.getOwner() == cClass) {
            return false;
        }
        if (cClass.descendsFrom(this.getOwner())) {
            return false;
        }
        if (!cClass.descendsFrom(this.getOwner()) && bl) {
            return true;
        }
        if (!this.isPrivate()) {
            return false;
        }
        if (cClass.isNested() && this.requiresAccessor(cClass.getOwner(), bl)) {
            return true;
        }
        return cClass.isDefinedInside(this.owner) || this.owner.isDefinedInside(cClass);
    }

    public CSourceClass getAccessorOwner(CSourceClass cSourceClass) {
        if (this.getOwner() == cSourceClass) {
            return cSourceClass;
        }
        if (this.isPrivate()) {
            return (CSourceClass)this.getOwner();
        }
        CClass cClass = cSourceClass;
        while (!cClass.descendsFrom(this.getOwner())) {
            cClass = cClass.getOwner();
        }
        return cClass;
    }

    public CMember(CClass cClass, int n, String string, boolean bl, boolean bl2) {
        this.owner = cClass;
        this.modifiers = n;
        this.ident = string;
        this.deprecated = bl;
        this.synthetic = bl2;
    }
}

