/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.classfile.InvokeinterfaceInstruction;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CClass;
import at.dms.kjc.CMember;
import at.dms.kjc.CModifier;
import at.dms.kjc.CReferenceType;
import at.dms.kjc.CSourceClass;
import at.dms.kjc.CSourceMethod;
import at.dms.kjc.CThrowableInfo;
import at.dms.kjc.CType;
import at.dms.kjc.CTypeContext;
import at.dms.kjc.CTypeVariable;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JAccessorMethod;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.TypeFactory;
import at.dms.util.InconsistencyException;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class CMethod
extends CMember {
    public static final CMethod[] EMPTY = new CMethod[0];
    protected CType returnType;
    private CType[] parameters;
    private CReferenceType[] exceptions;
    private CTypeVariable[] typeVariables;
    private Hashtable accessors;

    public boolean isAccessible(CType cType, CClass cClass) {
        if (!super.isAccessible(cClass)) {
            return false;
        }
        if (this.isProtected() && !this.isStatic() && this.getOwner().getPackage() != cClass.getPackage() && cType != null) {
            if (cType.isArrayType() && this.getIdent() == "clone" && this.getParameters().length == 0) {
                return true;
            }
            if (cClass.isAnonymous() && cType.getCClass().descendsFrom(cClass.getOwner())) {
                return true;
            }
            return cType.getCClass().descendsFrom(cClass);
        }
        return true;
    }

    public CMethod getMethod() {
        return this;
    }

    public final CType getReturnType() {
        return this.returnType;
    }

    public final CType[] getParameters() {
        return this.parameters;
    }

    public final CTypeVariable[] getTypeVariables() {
        return this.typeVariables;
    }

    public boolean isGenericMethod() {
        boolean bl = false;
        if (this.typeVariables.length > 0) {
            bl = true;
        }
        return bl;
    }

    public void setParameters(CType[] cTypeArray) {
        if (!this.isPostcondition()) {
            throw new InconsistencyException();
        }
        this.parameters = cTypeArray;
    }

    public abstract String getSignature();

    public CReferenceType[] getThrowables() {
        return this.exceptions;
    }

    public void setThrowables(Hashtable hashtable) {
        if (hashtable != null) {
            Enumeration enumeration = hashtable.elements();
            int n = 0;
            this.exceptions = new CReferenceType[hashtable.size()];
            while (enumeration.hasMoreElements()) {
                this.exceptions[n++] = ((CThrowableInfo)enumeration.nextElement()).getThrowable();
            }
        }
    }

    public void setThrowables(CReferenceType[] cReferenceTypeArray) {
        this.exceptions = cReferenceTypeArray;
    }

    CSourceMethod getAccessor(TypeFactory typeFactory, CSourceClass cSourceClass, boolean bl) {
        CSourceMethod cSourceMethod;
        if (this.accessors == null) {
            this.accessors = new Hashtable();
            cSourceMethod = null;
        } else {
            cSourceMethod = (CSourceMethod)this.accessors.get(cSourceClass);
        }
        if (cSourceMethod == null) {
            JAccessorMethod jAccessorMethod = new JAccessorMethod(typeFactory, cSourceClass, this, false, bl, -1);
            cSourceMethod = (CSourceMethod)jAccessorMethod.getMethod();
            this.accessors.put(cSourceClass, cSourceMethod);
        }
        return cSourceMethod;
    }

    public CTypeVariable lookupTypeVariable(String string) {
        int n = 0;
        while (n < this.typeVariables.length) {
            if (string == this.typeVariables[n].getIdent()) {
                return this.typeVariables[n];
            }
            ++n;
        }
        if (this.isStatic()) {
            return null;
        }
        return this.getOwner().lookupTypeVariable(string);
    }

    public boolean isNative() {
        return CModifier.contains(this.getModifiers(), 256);
    }

    public boolean isAbstract() {
        return CModifier.contains(this.getModifiers(), 1024);
    }

    public boolean isConstructor() {
        boolean bl = false;
        if (this.getIdent() == "<init>") {
            bl = true;
        }
        return bl;
    }

    public abstract boolean isInvariant();

    public abstract boolean isPrecondition();

    public abstract boolean isPostcondition();

    public abstract CMethod getPreconditionMethod();

    public abstract CMethod getPostconditionMethod();

    public abstract CReferenceType getOldValueStore();

    public boolean includesSuperMethod(CMethod cMethod) {
        return false;
    }

    public boolean equals(CMethod cMethod) {
        if (!this.getOwner().equals(cMethod.getOwner())) {
            return false;
        }
        if (this.getIdent() != cMethod.getIdent()) {
            return false;
        }
        if (this.parameters.length != cMethod.parameters.length) {
            return false;
        }
        int n = 0;
        while (n < this.parameters.length) {
            if (!this.parameters[n].equals(cMethod.parameters[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isApplicableTo(CTypeContext cTypeContext, String string, CType[] cTypeArray, CReferenceType[] cReferenceTypeArray) {
        if (string != this.getIdent()) {
            return false;
        }
        if (cTypeArray.length != this.parameters.length) {
            return false;
        }
        int n = 0;
        while (n < cTypeArray.length) {
            if (!cTypeArray[n].isAssignableTo(cTypeContext, this.parameters[n], cReferenceTypeArray)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isMoreSpecificThan(CTypeContext cTypeContext, CMethod cMethod, CReferenceType[] cReferenceTypeArray) throws UnpositionedError {
        if (!this.getOwner().descendsFrom(cMethod.getOwner())) {
            return false;
        }
        if (this.parameters.length != cMethod.parameters.length) {
            return false;
        }
        int n = 0;
        while (n < cMethod.parameters.length) {
            if (!this.parameters[n].getErasure(cTypeContext).isAssignableTo(cTypeContext, cMethod.parameters[n].getErasure(cTypeContext))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean hasSameSignature(CMethod cMethod, CReferenceType[] cReferenceTypeArray) {
        if (this.parameters.length != cMethod.parameters.length) {
            return false;
        }
        int n = 0;
        while (n < this.parameters.length) {
            if (!this.parameters[n].equals(cMethod.parameters[n], cReferenceTypeArray)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean hasSameSignature(CTypeContext cTypeContext, CMethod cMethod) throws UnpositionedError {
        if (this.parameters.length != cMethod.parameters.length) {
            return false;
        }
        int n = 0;
        while (n < this.parameters.length) {
            if (!cMethod.parameters[n].getErasure(cTypeContext).equals(this.parameters[n].getErasure(cTypeContext))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void checkInheritence(CTypeContext cTypeContext, CMethod cMethod, CReferenceType[] cReferenceTypeArray) throws UnpositionedError {
        boolean bl;
        if (!this.isStatic() && cMethod.isStatic()) {
            throw new UnpositionedError(KjcMessages.METHOD_INSTANCE_OVERRIDES_STATIC, this, cMethod.getOwner());
        }
        if (this.isStatic() && !cMethod.isStatic()) {
            throw new UnpositionedError(KjcMessages.METHOD_STATIC_HIDES_INSTANCE, this, cMethod.getOwner());
        }
        if (!cTypeContext.getTypeFactory().isGenericEnabled()) {
            if (!this.returnType.equals(cMethod.getReturnType())) {
                throw new UnpositionedError(KjcMessages.METHOD_RETURN_DIFFERENT, this);
            }
        } else if (this.returnType.isClassType()) {
            if (!this.returnType.isAssignableTo(cTypeContext, cMethod.getReturnType(), cReferenceTypeArray)) {
                throw new UnpositionedError(KjcMessages.METHOD_RETURN_NOT_SUBTYPE, new Object[]{this, cMethod, cMethod.getOwner(), this.returnType, cMethod.getReturnType()});
            }
        } else if (!this.returnType.equals(cMethod.getReturnType())) {
            throw new UnpositionedError(KjcMessages.METHOD_RETURN_DIFFERENT, this);
        }
        if (cMethod.isPublic()) {
            bl = this.isPublic() ^ true;
        } else if (cMethod.isProtected()) {
            boolean bl2 = false;
            if (this.isProtected() || this.isPublic()) {
                bl2 = true;
            }
            bl = bl2 ^ true;
        } else if (!cMethod.isPrivate()) {
            bl = this.isPrivate();
        } else {
            throw new InconsistencyException("bad access: " + cMethod.getModifiers());
        }
        if (bl) {
            throw new UnpositionedError(KjcMessages.METHOD_ACCESS_DIFFERENT, this, cMethod.getOwner());
        }
    }

    public void checkOverriding(CTypeContext cTypeContext, CMethod cMethod, CReferenceType[] cReferenceTypeArray) throws UnpositionedError {
        boolean bl;
        if (cMethod.isFinal()) {
            throw new UnpositionedError(KjcMessages.METHOD_OVERRIDE_FINAL, this);
        }
        if (!this.isStatic() && cMethod.isStatic()) {
            throw new UnpositionedError(KjcMessages.METHOD_INSTANCE_OVERRIDES_STATIC, this, cMethod.getOwner());
        }
        if (this.isStatic() && !cMethod.isStatic()) {
            throw new UnpositionedError(KjcMessages.METHOD_STATIC_HIDES_INSTANCE, this, cMethod.getOwner());
        }
        if (!cTypeContext.getTypeFactory().isGenericEnabled()) {
            if (!this.returnType.equals(cMethod.getReturnType())) {
                throw new UnpositionedError(KjcMessages.METHOD_RETURN_DIFFERENT, this);
            }
        } else if (this.returnType.isClassType()) {
            if (!this.returnType.isAssignableTo(cTypeContext, cMethod.getReturnType(), cReferenceTypeArray)) {
                throw new UnpositionedError(KjcMessages.METHOD_RETURN_NOT_SUBTYPE, new Object[]{this, cMethod, cMethod.getOwner(), this.returnType, cMethod.getReturnType()});
            }
        } else if (!this.returnType.equals(cMethod.getReturnType())) {
            throw new UnpositionedError(KjcMessages.METHOD_RETURN_DIFFERENT, this);
        }
        if (cMethod.isPublic()) {
            bl = this.isPublic() ^ true;
        } else if (cMethod.isProtected()) {
            boolean bl2 = false;
            if (this.isProtected() || this.isPublic()) {
                bl2 = true;
            }
            bl = bl2 ^ true;
        } else if (!cMethod.isPrivate()) {
            bl = this.isPrivate();
        } else {
            throw new InconsistencyException("bad access: " + cMethod.getModifiers());
        }
        if (bl) {
            throw new UnpositionedError(KjcMessages.METHOD_ACCESS_DIFFERENT, this, cMethod.getOwner());
        }
        CReferenceType[] cReferenceTypeArray2 = cMethod.getThrowables();
        int n = 0;
        while (n < this.exceptions.length) {
            block22: {
                if (this.exceptions[n].isCheckedException(cTypeContext)) {
                    int n2 = 0;
                    while (n2 < cReferenceTypeArray2.length) {
                        if (!this.exceptions[n].isAssignableTo(cTypeContext, (CType)cReferenceTypeArray2[n2], cReferenceTypeArray)) {
                            ++n2;
                            continue;
                        }
                        break block22;
                    }
                    throw new UnpositionedError(KjcMessages.METHOD_THROWS_DIFFERENT, this, this.exceptions[n]);
                }
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.returnType);
        stringBuffer.append(" ");
        stringBuffer.append(this.getOwner());
        stringBuffer.append(".");
        stringBuffer.append(this.getIdent());
        stringBuffer.append("(");
        int n = 0;
        while (n < this.parameters.length) {
            if (n != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.parameters[n]);
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void genCode(GenerationContext generationContext, boolean bl) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        if (this.getOwner().isInterface()) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.parameters.length) {
                n += this.parameters[n2].getSize();
                ++n2;
            }
            codeSequence.plantInstruction(new InvokeinterfaceInstruction(this.getPrefixName(), this.getIdent(), this.getSignature(), n + 1));
        } else {
            int n = this.isStatic() ? 184 : (bl || this.isPrivate() ? 183 : 182);
            codeSequence.plantMethodRefInstruction(n, this.getPrefixName(), this.getIdent(), this.getSignature());
        }
    }

    public int getHeapForParameter() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.parameters.length) {
            n += this.parameters[n2].getSize();
            ++n2;
        }
        return 1 - this.isStatic() + n;
    }

    public CMethod(CClass cClass, int n, String string, CType cType, CType[] cTypeArray, CReferenceType[] cReferenceTypeArray, CTypeVariable[] cTypeVariableArray, boolean bl, boolean bl2) {
        super(cClass, n, string, bl, bl2);
        this.returnType = cType;
        this.parameters = cTypeArray;
        this.exceptions = cReferenceTypeArray;
        this.typeVariables = cTypeVariableArray;
        this.accessors = null;
    }
}

