/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.CodeEnv;
import at.dms.classfile.CodeInfo;
import at.dms.classfile.MethodDescription;
import at.dms.classfile.MethodInfo;
import at.dms.kjc.BytecodeOptimizer;
import at.dms.kjc.CClass;
import at.dms.kjc.CMethod;
import at.dms.kjc.CReferenceType;
import at.dms.kjc.CSourceClass;
import at.dms.kjc.CType;
import at.dms.kjc.CTypeVariable;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JBlock;
import at.dms.kjc.TypeFactory;
import at.dms.util.SimpleStringBuffer;
import java.util.ArrayList;

public class CSourceMethod
extends CMethod {
    private JBlock body;
    private boolean used;
    private CMethod preconditionMethod;
    private CMethod postconditionMethod;
    private CReferenceType oldValueStore;
    private boolean invariant;
    private boolean precondition;
    private boolean postcondition;
    private ArrayList superMethods;

    public boolean isUsed() {
        boolean bl = false;
        if (this.used || !this.isPrivate() || this.isSynthetic()) {
            bl = true;
        }
        return bl;
    }

    public void setUsed() {
        this.used = true;
    }

    void setBody(JBlock jBlock) {
        this.body = jBlock;
    }

    public void setSynthetic(boolean bl) {
        this.synthetic = bl;
    }

    public boolean isInvariant() {
        return this.invariant;
    }

    public void setInvariant(boolean bl) {
        this.invariant = bl;
    }

    public boolean isPrecondition() {
        return this.precondition;
    }

    public void setPrecondition(boolean bl) {
        this.precondition = bl;
    }

    public boolean isPostcondition() {
        return this.postcondition;
    }

    public void setPostcondition(boolean bl) {
        this.postcondition = bl;
    }

    public CReferenceType getOldValueStore() {
        return this.oldValueStore;
    }

    public void setOldValueStore(CReferenceType cReferenceType) {
        this.oldValueStore = cReferenceType;
    }

    public CMethod getPreconditionMethod() {
        return this.preconditionMethod;
    }

    public void setPreconditionMethod(CMethod cMethod) {
        this.preconditionMethod = cMethod;
    }

    public CMethod getPostconditionMethod() {
        return this.postconditionMethod;
    }

    public void setPostconditionMethod(CMethod cMethod) {
        this.postconditionMethod = cMethod;
    }

    public void addSuperMethod(CMethod cMethod) {
        boolean bl = false;
        if (cMethod != null) {
            bl = true;
        }
        CSourceMethod.verify(bl);
        if (this.superMethods == null) {
            this.superMethods = new ArrayList();
        }
        this.superMethods.add(cMethod);
    }

    public CMethod[] getSuperMethods() {
        if (this.superMethods == null) {
            return CMethod.EMPTY;
        }
        return this.superMethods.toArray(new CMethod[this.superMethods.size()]);
    }

    public boolean includesSuperMethod(CMethod cMethod) {
        if (this.superMethods == null) {
            return false;
        }
        int n = this.superMethods.size();
        int n2 = 0;
        while (n2 < n) {
            if (this.superMethods.get(n2) == cMethod || ((CMethod)this.superMethods.get(n2)).includesSuperMethod(cMethod)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public MethodInfo genMethodInfo(BytecodeOptimizer bytecodeOptimizer, TypeFactory typeFactory) throws ClassFileFormatException {
        CReferenceType[] cReferenceTypeArray = this.getThrowables();
        String[] stringArray = new String[cReferenceTypeArray.length];
        int n = 0;
        while (n < cReferenceTypeArray.length) {
            stringArray[n] = cReferenceTypeArray[n].getQualifiedName();
            ++n;
        }
        MethodInfo methodInfo = new MethodInfo((short)this.getModifiers(), this.getIdent(), this.getSignature(), this.getGenericSignature(), stringArray, this.body != null ? this.genCode(typeFactory) : null, this.isDeprecated(), this.isSynthetic());
        methodInfo = bytecodeOptimizer.run(methodInfo);
        if (this.isInvariant()) {
            methodInfo.setInvariant(true);
        }
        if (this.isPrecondition()) {
            methodInfo.setPrecondition(true);
        }
        if (this.isPostcondition()) {
            methodInfo.setPostcondition(this.oldValueStore == null ? null : this.oldValueStore.getIdent());
        }
        if (this.preconditionMethod != null || this.preconditionMethod != null) {
            MethodDescription methodDescription = this.preconditionMethod == null ? null : new MethodDescription(this.preconditionMethod.getQualifiedName(), this.preconditionMethod.getSignature());
            MethodDescription methodDescription2 = this.postconditionMethod == null ? null : new MethodDescription(this.postconditionMethod.getQualifiedName(), this.postconditionMethod.getSignature());
            methodInfo.setConditionMethods(methodDescription, methodDescription2);
        }
        return methodInfo;
    }

    public String getSignature() {
        CType[] cTypeArray = this.getParameters();
        if (this.getOwner().isNested() && this.isConstructor()) {
            cTypeArray = ((CSourceClass)this.getOwner()).genConstructorArray(cTypeArray);
        }
        SimpleStringBuffer simpleStringBuffer = SimpleStringBuffer.request();
        simpleStringBuffer.append('(');
        int n = 0;
        while (n < cTypeArray.length) {
            cTypeArray[n].appendSignature(simpleStringBuffer);
            ++n;
        }
        simpleStringBuffer.append(')');
        this.returnType.appendSignature(simpleStringBuffer);
        String string = simpleStringBuffer.toString();
        SimpleStringBuffer.release(simpleStringBuffer);
        return string;
    }

    public String getGenericSignature() {
        int n;
        CType[] cTypeArray = this.getParameters();
        CType cType = this.getReturnType();
        CReferenceType[] cReferenceTypeArray = this.getThrowables();
        CTypeVariable[] cTypeVariableArray = this.getTypeVariables();
        SimpleStringBuffer simpleStringBuffer = SimpleStringBuffer.request();
        if (cTypeVariableArray.length > 0) {
            simpleStringBuffer.append('<');
            n = 0;
            while (n < cTypeVariableArray.length) {
                cTypeVariableArray[n].appendDefinitionSignature(simpleStringBuffer);
                ++n;
            }
            simpleStringBuffer.append('>');
        }
        simpleStringBuffer.append('(');
        n = 0;
        while (n < cTypeArray.length) {
            cTypeArray[n].appendGenericSignature(simpleStringBuffer);
            ++n;
        }
        simpleStringBuffer.append(')');
        cType.appendGenericSignature(simpleStringBuffer);
        if (cReferenceTypeArray != null && cReferenceTypeArray.length > 0) {
            simpleStringBuffer.append('^');
            n = 0;
            while (n < cReferenceTypeArray.length) {
                cReferenceTypeArray[n].appendGenericSignature(simpleStringBuffer);
                ++n;
            }
        }
        String string = simpleStringBuffer.toString();
        SimpleStringBuffer.release(simpleStringBuffer);
        return string;
    }

    private final CodeInfo genByteCode(TypeFactory typeFactory) {
        CodeSequence codeSequence = CodeSequence.getCodeSequence();
        GenerationContext generationContext = new GenerationContext(typeFactory, codeSequence);
        this.body.genCode(generationContext);
        if (this.getReturnType().getTypeID() == 1) {
            codeSequence.plantNoArgInstruction(177);
        }
        CodeInfo codeInfo = new CodeInfo(codeSequence.getInstructionArray(), codeSequence.getHandlers(), codeSequence.getLineNumbers(), null);
        codeSequence.release();
        this.body = null;
        return codeInfo;
    }

    public CodeInfo genCode(TypeFactory typeFactory) throws ClassFileFormatException {
        CType[] cTypeArray = this.getParameters();
        int n = 0;
        CodeInfo codeInfo = this.genByteCode(typeFactory);
        int n2 = 0;
        while (n2 < cTypeArray.length) {
            n += cTypeArray[n2].getSize();
            ++n2;
        }
        n += this.getReturnType().getSize();
        codeInfo.setParameterCount(n += 1 - this.isStatic());
        CodeEnv.check(codeInfo);
        return codeInfo;
    }

    public CSourceMethod(CClass cClass, int n, String string, CType cType, CType[] cTypeArray, CReferenceType[] cReferenceTypeArray, CTypeVariable[] cTypeVariableArray, boolean bl, boolean bl2, JBlock jBlock) {
        super(cClass, n, string, cType, cTypeArray, cReferenceTypeArray, cTypeVariableArray, bl, bl2);
        this.body = jBlock;
    }
}

