/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.classfile.AccessorContainer;
import at.dms.classfile.AccessorTransformer;
import at.dms.classfile.BadAccessorException;
import at.dms.classfile.ClassRefInstruction;
import at.dms.classfile.FieldRefInstruction;
import at.dms.classfile.HandlerInfo;
import at.dms.classfile.Instruction;
import at.dms.classfile.InstructionAccessor;
import at.dms.classfile.JumpInstruction;
import at.dms.classfile.LineNumberInfo;
import at.dms.classfile.LocalVarInstruction;
import at.dms.classfile.LocalVariableInfo;
import at.dms.classfile.MethodRefInstruction;
import at.dms.classfile.NewarrayInstruction;
import at.dms.classfile.NoArgInstruction;
import at.dms.kjc.CReferenceType;
import at.dms.kjc.CType;
import at.dms.kjc.CodeLabel;
import at.dms.kjc.Constants;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JLocalVariable;
import at.dms.kjc.JReturnStatement;
import at.dms.kjc.JStatement;
import at.dms.kjc.JSynchronizedStatement;
import at.dms.kjc.JTryFinallyStatement;
import at.dms.util.InconsistencyException;
import at.dms.util.Utils;
import java.util.ArrayList;
import java.util.Stack;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class CodeSequence
extends Utils
implements Constants {
    private static final Stack stack = new Stack();
    private Instruction[] instructions;
    private ArrayList handlers;
    private ArrayList lines;
    private int pc;
    private boolean labelAtEnd;
    private int lineNumber;
    private int lastLine;
    private Stack contexts;

    public static final CodeSequence getCodeSequence() {
        CodeSequence codeSequence = stack.empty() ? new CodeSequence() : (CodeSequence)stack.pop();
        codeSequence.pc = 0;
        codeSequence.labelAtEnd = false;
        codeSequence.lineNumber = 0;
        codeSequence.lastLine = -1;
        return codeSequence;
    }

    public final void release() {
        stack.push(this);
        this.handlers.clear();
        this.lines.clear();
    }

    public static final void endSession() {
        while (!stack.empty()) {
            stack.pop();
        }
    }

    public final void plantInstruction(Instruction instruction) {
        this.instructions[this.pc++] = instruction;
        this.labelAtEnd = false;
        if (this.lineNumber != this.lastLine) {
            this.lastLine = this.lineNumber;
            this.lines.add(new LineNumberInfo((short)this.lineNumber, instruction));
        }
    }

    public final void plantNoArgInstruction(int n) {
        this.plantInstruction(new NoArgInstruction(n));
    }

    public final void plantPopInstruction(CType cType) {
        switch (cType.getSize()) {
            case 0: {
                boolean bl = false;
                if (cType.getTypeID() == 1) {
                    bl = true;
                }
                CodeSequence.verify(bl);
                break;
            }
            case 1: {
                this.plantNoArgInstruction(87);
                break;
            }
            case 2: {
                this.plantNoArgInstruction(88);
                break;
            }
            default: {
                CodeSequence.verify(false);
            }
        }
    }

    public final void plantLocalVar(int n, JLocalVariable jLocalVariable) {
        LocalVarInstruction localVarInstruction = new LocalVarInstruction(n, jLocalVariable.getPosition());
        this.plantInstruction(localVarInstruction);
        this.addLocalVarInfo(localVarInstruction, jLocalVariable);
    }

    public final void plantLoadThis() {
        this.plantInstruction(new LocalVarInstruction(25, 0));
    }

    public final void plantFieldRefInstruction(int n, String string, String string2, String string3) {
        this.plantInstruction(new FieldRefInstruction(n, string, string2, string3));
    }

    public final void plantMethodRefInstruction(int n, String string, String string2, String string3) {
        this.plantInstruction(new MethodRefInstruction(n, string, string2, string3));
    }

    public final void plantClassRefInstruction(int n, String string) {
        this.plantInstruction(new ClassRefInstruction(n, string));
    }

    public final void plantJumpInstruction(int n, CodeLabel codeLabel) {
        this.plantInstruction(new JumpInstruction(n, codeLabel));
    }

    public final void plantNewArrayInstruction(CType cType) {
        if (cType.isReference()) {
            this.plantClassRefInstruction(189, ((CReferenceType)cType).getQualifiedName());
        } else {
            byte by;
            switch (cType.getTypeID()) {
                case 2: {
                    by = 8;
                    break;
                }
                case 11: {
                    by = 4;
                    break;
                }
                case 4: {
                    by = 5;
                    break;
                }
                case 3: {
                    by = 9;
                    break;
                }
                case 5: {
                    by = 10;
                    break;
                }
                case 6: {
                    by = 11;
                    break;
                }
                case 7: {
                    by = 6;
                    break;
                }
                case 8: {
                    by = 7;
                    break;
                }
                default: {
                    throw new InconsistencyException();
                }
            }
            this.plantInstruction(new NewarrayInstruction(by));
        }
    }

    public final void plantLabel(CodeLabel codeLabel) {
        codeLabel.setAddress(this.pc);
        this.labelAtEnd = true;
    }

    public final void setLineNumber(int n) {
        if (n != 0) {
            this.lineNumber = n;
        }
    }

    public final LineNumberInfo[] getLineNumbers() {
        return this.lines.toArray(new LineNumberInfo[this.lines.size()]);
    }

    public final LocalVariableInfo[] getLocalVariableInfos() {
        return null;
    }

    public final void plantReturn(JReturnStatement jReturnStatement, GenerationContext generationContext) {
        int n = this.contexts.size() - 1;
        while (n >= 0) {
            JStatement jStatement = (JStatement)this.contexts.elementAt(n);
            if (jStatement instanceof JTryFinallyStatement) {
                ((JTryFinallyStatement)jStatement).genFinallyCall(generationContext, jReturnStatement);
            } else if (jStatement instanceof JSynchronizedStatement) {
                ((JSynchronizedStatement)jStatement).genMonitorExit(generationContext);
            }
            --n;
        }
    }

    public final void plantBreak(JStatement jStatement, GenerationContext generationContext) {
        int n = this.contexts.size() - 1;
        while (n >= 0 && this.contexts.elementAt(n) != jStatement) {
            JStatement jStatement2 = (JStatement)this.contexts.elementAt(n);
            if (jStatement2 instanceof JTryFinallyStatement) {
                ((JTryFinallyStatement)jStatement2).genFinallyCall(generationContext, null);
            } else if (jStatement2 instanceof JSynchronizedStatement) {
                ((JSynchronizedStatement)jStatement2).genMonitorExit(generationContext);
            }
            --n;
        }
    }

    public final void pushContext(JStatement jStatement) {
        this.contexts.push(jStatement);
    }

    public final void popContext(JStatement jStatement) {
        boolean bl = false;
        if ((JStatement)this.contexts.pop() == jStatement) {
            bl = true;
        }
        CodeSequence.verify(bl);
    }

    public final void addExceptionHandler(int n, int n2, int n3, String string) {
        if (n != n2) {
            this.handlers.add(new HandlerInfo(this.getInstructionAt(n), this.getInstructionAt(n2 - 1), this.getInstructionAt(n3), string));
        }
    }

    public final HandlerInfo[] getHandlers() {
        return this.handlers.toArray(new HandlerInfo[this.handlers.size()]);
    }

    public final int getPC() {
        return this.pc;
    }

    public final int size() {
        return this.pc;
    }

    public final Instruction getInstructionAt(int n) {
        return this.instructions[n];
    }

    public final Instruction[] getInstructionArray() {
        this.resolveLabels();
        Instruction[] instructionArray = new Instruction[this.pc];
        System.arraycopy(this.instructions, 0, instructionArray, 0, this.pc);
        return instructionArray;
    }

    private final void resolveLabels() {
        if (this.labelAtEnd) {
            this.plantNoArgInstruction(0);
        }
        try {
            AccessorTransformer accessorTransformer = new AccessorTransformer(this){
                final /* synthetic */ CodeSequence this$0;

                public final InstructionAccessor transform(InstructionAccessor instructionAccessor, AccessorContainer accessorContainer) {
                    return this.this$0.getInstructionAt(((CodeLabel)instructionAccessor).getAddress());
                }
                {
                    this.this$0 = codeSequence;
                }
            };
            int n = 0;
            while (n < this.pc) {
                if (this.instructions[n] instanceof AccessorContainer) {
                    ((AccessorContainer)((Object)this.instructions[n])).transformAccessors(accessorTransformer);
                }
                ++n;
            }
        }
        catch (BadAccessorException badAccessorException) {
            throw new InconsistencyException();
        }
    }

    private final void addLocalVarInfo(LocalVarInstruction localVarInstruction, JLocalVariable jLocalVariable) {
    }

    private final /* synthetic */ void this() {
        this.contexts = new Stack();
    }

    private CodeSequence() {
        this.this();
        this.instructions = new Instruction[65534];
        this.handlers = new ArrayList();
        this.lines = new ArrayList();
    }
}

