/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CNumericType;
import at.dms.kjc.CReferenceType;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JBinaryArithmeticExpression;
import at.dms.kjc.JExpression;
import at.dms.kjc.JStringLiteral;
import at.dms.kjc.JTypeNameExpression;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.TypeFactory;

public class JAddExpression
extends JBinaryArithmeticExpression {
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JAddExpression[");
        stringBuffer.append(this.left.toString());
        stringBuffer.append(", ");
        stringBuffer.append(this.right.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        TypeFactory typeFactory = cExpressionContext.getTypeFactory();
        this.left = this.left.analyse(cExpressionContext);
        this.right = this.right.analyse(cExpressionContext);
        boolean bl = false;
        if (this.left.getType(typeFactory).getTypeID() != 1 && this.right.getType(typeFactory).getTypeID() != 1) {
            bl = true;
        }
        this.check(cExpressionContext, bl, KjcMessages.ADD_BADTYPE, this.left.getType(typeFactory), this.right.getType(typeFactory));
        boolean bl2 = false;
        if (!(this.left instanceof JTypeNameExpression) && !(this.right instanceof JTypeNameExpression)) {
            bl2 = true;
        }
        this.check(cExpressionContext, bl2, KjcMessages.ADD_BADTYPE, this.left.getType(typeFactory), this.right.getType(typeFactory));
        try {
            this.type = JAddExpression.computeType(cExpressionContext, this.left.getType(typeFactory), this.right.getType(typeFactory));
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
        CReferenceType cReferenceType = cExpressionContext.getTypeFactory().createReferenceType(10);
        if (!this.type.equals(cReferenceType)) {
            this.left = this.left.convertType(cExpressionContext, this.type);
            this.right = this.right.convertType(cExpressionContext, this.type);
        }
        if (this.left.isConstant() && this.right.isConstant()) {
            if (this.type.equals(cReferenceType)) {
                this.left = this.left.convertType(cExpressionContext, this.type);
                this.right = this.right.convertType(cExpressionContext, this.type);
                return new JStringLiteral(this.getTokenReference(), this.left.stringValue() + this.right.stringValue());
            }
            return this.constantFolding(typeFactory);
        }
        return this;
    }

    public static CType computeType(CExpressionContext cExpressionContext, CType cType, CType cType2) throws UnpositionedError {
        CReferenceType cReferenceType = cExpressionContext.getTypeFactory().createReferenceType(10);
        if (cType.equals(cReferenceType)) {
            if (cType2.getTypeID() == 1) {
                throw new UnpositionedError(KjcMessages.ADD_BADTYPE, cType, cType2);
            }
            return cReferenceType;
        }
        if (cType2.equals(cReferenceType)) {
            if (cType.getTypeID() == 1) {
                throw new UnpositionedError(KjcMessages.ADD_BADTYPE, cType, cType2);
            }
            return cReferenceType;
        }
        if (cType.isNumeric() && cType2.isNumeric()) {
            return CNumericType.binaryPromote(cExpressionContext, cType, cType2);
        }
        throw new UnpositionedError(KjcMessages.ADD_BADTYPE, cType, cType2);
    }

    public int compute(int n, int n2) {
        return n + n2;
    }

    public long compute(long l, long l2) {
        return l + l2;
    }

    public float compute(float f, float f2) {
        return f + f2;
    }

    public double compute(double d, double d2) {
        return d + d2;
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitBinaryExpression(this, "+", this.left, this.right);
    }

    public static int getOpcode(CType cType) {
        switch (cType.getTypeID()) {
            case 7: {
                return 98;
            }
            case 6: {
                return 97;
            }
            case 8: {
                return 99;
            }
        }
        return 96;
    }

    public void genCode(GenerationContext generationContext, boolean bl) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        TypeFactory typeFactory = generationContext.getTypeFactory();
        this.setLineNumber(codeSequence);
        if (this.type.equals(typeFactory.createReferenceType(10))) {
            codeSequence.plantClassRefInstruction(187, "java/lang/StringBuffer");
            codeSequence.plantNoArgInstruction(89);
            codeSequence.plantMethodRefInstruction(183, "java/lang/StringBuffer", "<init>", "()V");
            this.appendToStringBuffer(generationContext, this.left);
            this.appendToStringBuffer(generationContext, this.right);
            codeSequence.plantMethodRefInstruction(182, "java/lang/StringBuffer", "toString", "()Ljava/lang/String;");
        } else {
            this.left.genCode(generationContext, false);
            this.right.genCode(generationContext, false);
            codeSequence.plantNoArgInstruction(JAddExpression.getOpcode(this.getType(typeFactory)));
        }
        if (bl) {
            codeSequence.plantPopInstruction(this.getType(typeFactory));
        }
    }

    private final void appendToStringBuffer(GenerationContext generationContext, JExpression jExpression) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        TypeFactory typeFactory = generationContext.getTypeFactory();
        if (jExpression instanceof JAddExpression && jExpression.getType(typeFactory).equals(typeFactory.createReferenceType(10))) {
            ((JAddExpression)jExpression).appendToStringBuffer(generationContext, ((JAddExpression)jExpression).left);
            ((JAddExpression)jExpression).appendToStringBuffer(generationContext, ((JAddExpression)jExpression).right);
        } else {
            CType cType = jExpression.getType(typeFactory);
            int n = cType.getTypeID();
            jExpression.genCode(generationContext, false);
            if (!cType.isReference() || cType.equals(typeFactory.createReferenceType(10))) {
                if (n == 2 || n == 3) {
                    cType = typeFactory.getPrimitiveType(5);
                }
                codeSequence.plantMethodRefInstruction(182, "java/lang/StringBuffer", "append", "(" + cType.getSignature() + ")Ljava/lang/StringBuffer;");
            } else {
                codeSequence.plantMethodRefInstruction(182, "java/lang/StringBuffer", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuffer;");
            }
        }
    }

    public JAddExpression(TokenReference tokenReference, JExpression jExpression, JExpression jExpression2) {
        super(tokenReference, jExpression, jExpression2);
    }
}

