/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CArrayType;
import at.dms.kjc.CContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JExpression;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.TypeFactory;

public class JArrayAccessExpression
extends JExpression {
    private JExpression prefix;
    private JExpression accessor;
    private CType type;

    public CType getType(TypeFactory typeFactory) {
        return this.type;
    }

    public boolean isInitialized(CExpressionContext cExpressionContext) {
        return true;
    }

    public void setInitialized(CExpressionContext cExpressionContext) {
    }

    public boolean isLValue(CExpressionContext cExpressionContext) {
        return true;
    }

    public String getIdent() {
        return this.type + "[]";
    }

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        TypeFactory typeFactory = cExpressionContext.getTypeFactory();
        this.accessor = this.accessor.analyse(new CExpressionContext(cExpressionContext, cExpressionContext.getEnvironment()));
        this.check((CContext)cExpressionContext, this.accessor.getType(typeFactory).isAssignableTo(cExpressionContext, cExpressionContext.getTypeFactory().getPrimitiveType(5)), KjcMessages.ARRAY_EXPRESSION_INT, this.accessor.getType(typeFactory));
        this.prefix = this.prefix.analyse(new CExpressionContext(cExpressionContext, cExpressionContext.getEnvironment()));
        this.check((CContext)cExpressionContext, this.prefix.getType(typeFactory).isArrayType(), KjcMessages.ARRAY_PREFIX, this.prefix.getType(typeFactory));
        this.type = ((CArrayType)this.prefix.getType(typeFactory)).getElementType();
        return this;
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitArrayAccessExpression(this, this.prefix, this.accessor);
    }

    public void genCode(GenerationContext generationContext, boolean bl) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        this.setLineNumber(codeSequence);
        this.prefix.genCode(generationContext, false);
        this.accessor.genCode(generationContext, false);
        codeSequence.plantNoArgInstruction(this.type.getArrayLoadOpcode());
        if (bl) {
            codeSequence.plantPopInstruction(this.type);
        }
    }

    public void genStartStoreCode(GenerationContext generationContext) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        this.prefix.genCode(generationContext, false);
        this.accessor.genCode(generationContext, false);
    }

    public void genStartAndLoadStoreCode(GenerationContext generationContext, boolean bl) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        this.genStartStoreCode(generationContext);
        codeSequence.plantNoArgInstruction(92);
        codeSequence.plantNoArgInstruction(this.type.getArrayLoadOpcode());
        if (bl) {
            codeSequence.plantPopInstruction(this.type);
        }
    }

    public void genEndStoreCode(GenerationContext generationContext, boolean bl) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        TypeFactory typeFactory = generationContext.getTypeFactory();
        if (!bl) {
            if (this.getType(typeFactory).getSize() == 2) {
                codeSequence.plantNoArgInstruction(94);
            } else if (this.type.getSize() == 1) {
                codeSequence.plantNoArgInstruction(91);
            }
        }
        codeSequence.plantNoArgInstruction(this.type.getArrayStoreOpcode());
    }

    public JArrayAccessExpression(TokenReference tokenReference, JExpression jExpression, JExpression jExpression2) {
        super(tokenReference);
        this.prefix = jExpression;
        this.accessor = jExpression2;
    }
}

