/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.classfile.PushLiteralInstruction;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CArrayType;
import at.dms.kjc.CContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JExpression;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.TypeFactory;

public class JArrayInitializer
extends JExpression {
    private CArrayType type;
    private JExpression[] elems;

    public CType getType(TypeFactory typeFactory) {
        return this.type;
    }

    public void setType(CArrayType cArrayType) {
        JArrayInitializer.verify(cArrayType.checked());
        this.type = cArrayType;
    }

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        TypeFactory typeFactory = cExpressionContext.getTypeFactory();
        boolean bl = false;
        if (this.type != null) {
            bl = true;
        }
        JArrayInitializer.verify(bl);
        CType cType = this.type.getElementType();
        if (cType.isArrayType()) {
            int n = 0;
            while (n < this.elems.length) {
                if (this.elems[n] instanceof JArrayInitializer) {
                    ((JArrayInitializer)this.elems[n]).setType((CArrayType)cType);
                }
                this.elems[n] = this.elems[n].analyse(cExpressionContext);
                this.check(cExpressionContext, this.elems[n].isAssignableTo(cExpressionContext, cType), KjcMessages.ARRAY_INIT_BADTYPE, cType, this.elems[n].getType(typeFactory));
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.elems.length) {
                this.check((CContext)cExpressionContext, this.elems[n] instanceof JArrayInitializer ^ true, KjcMessages.ARRAY_INIT_NOARRAY, cType);
                this.elems[n] = this.elems[n].analyse(cExpressionContext);
                this.check(cExpressionContext, this.elems[n].isAssignableTo(cExpressionContext, cType), KjcMessages.ARRAY_INIT_BADTYPE, cType, this.elems[n].getType(typeFactory));
                this.elems[n] = this.elems[n].convertType(cExpressionContext, cType);
                ++n;
            }
        }
        return this;
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitArrayInitializer(this, this.elems);
    }

    public void genCode(GenerationContext generationContext, boolean bl) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        TypeFactory typeFactory = generationContext.getTypeFactory();
        this.setLineNumber(codeSequence);
        codeSequence.plantInstruction(new PushLiteralInstruction(this.elems.length));
        codeSequence.plantNewArrayInstruction(this.type.getElementType());
        int n = this.type.getElementType().getArrayStoreOpcode();
        int n2 = 0;
        while (n2 < this.elems.length) {
            codeSequence.plantNoArgInstruction(89);
            codeSequence.plantInstruction(new PushLiteralInstruction(n2));
            this.elems[n2].genCode(generationContext, false);
            codeSequence.plantNoArgInstruction(n);
            ++n2;
        }
        if (bl) {
            codeSequence.plantPopInstruction(this.getType(typeFactory));
        }
    }

    public JArrayInitializer(TokenReference tokenReference, JExpression[] jExpressionArray) {
        super(tokenReference);
        this.elems = jExpressionArray;
    }
}

