/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CNumericType;
import at.dms.kjc.CType;
import at.dms.kjc.JBinaryExpression;
import at.dms.kjc.JDoubleLiteral;
import at.dms.kjc.JExpression;
import at.dms.kjc.JFloatLiteral;
import at.dms.kjc.JIntLiteral;
import at.dms.kjc.JLongLiteral;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.TypeFactory;
import at.dms.util.InconsistencyException;

public abstract class JBinaryArithmeticExpression
extends JBinaryExpression {
    public static CType computeType(CExpressionContext cExpressionContext, String string, CType cType, CType cType2) throws UnpositionedError {
        if (!cType.isNumeric() || !cType2.isNumeric()) {
            throw new UnpositionedError(KjcMessages.BINARY_NUMERIC_BAD_TYPES, new Object[]{string, cType, cType2});
        }
        return CNumericType.binaryPromote(cExpressionContext, cType, cType2);
    }

    public JExpression constantFolding(TypeFactory typeFactory) {
        switch (this.left.getType(typeFactory).getTypeID()) {
            case 5: {
                return new JIntLiteral(this.getTokenReference(), this.compute(this.left.intValue(), this.right.intValue()));
            }
            case 6: {
                return new JLongLiteral(this.getTokenReference(), this.compute(this.left.longValue(), this.right.longValue()));
            }
            case 7: {
                return new JFloatLiteral(this.getTokenReference(), this.compute(this.left.floatValue(), this.right.floatValue()));
            }
            case 8: {
                return new JDoubleLiteral(this.getTokenReference(), this.compute(this.left.doubleValue(), this.right.doubleValue()));
            }
        }
        throw new InconsistencyException("unexpected type " + this.left.getType(typeFactory));
    }

    public int compute(int n, int n2) {
        throw new InconsistencyException("not available");
    }

    public long compute(long l, long l2) {
        throw new InconsistencyException("not available");
    }

    public float compute(float f, float f2) {
        throw new InconsistencyException("not available");
    }

    public double compute(double d, double d2) {
        throw new InconsistencyException("not available");
    }

    public JBinaryArithmeticExpression(TokenReference tokenReference, JExpression jExpression, JExpression jExpression2) {
        super(tokenReference, jExpression, jExpression2);
    }
}

