/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CNumericType;
import at.dms.kjc.CPrimitiveType;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JBinaryArithmeticExpression;
import at.dms.kjc.JBooleanLiteral;
import at.dms.kjc.JExpression;
import at.dms.kjc.JIntLiteral;
import at.dms.kjc.JLongLiteral;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.TypeFactory;
import at.dms.util.InconsistencyException;

public class JBitwiseExpression
extends JBinaryArithmeticExpression {
    protected int oper;

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        TypeFactory typeFactory = cExpressionContext.getTypeFactory();
        this.left = this.left.analyse(cExpressionContext);
        this.right = this.right.analyse(cExpressionContext);
        try {
            this.type = JBitwiseExpression.computeType(cExpressionContext, this.left.getType(typeFactory), this.right.getType(typeFactory));
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
        this.left = this.left.convertType(cExpressionContext, this.type);
        this.right = this.right.convertType(cExpressionContext, this.type);
        if (this.left.isConstant() && this.right.isConstant()) {
            return this.constantFolding(typeFactory);
        }
        return this;
    }

    public static CType computeType(CExpressionContext cExpressionContext, CType cType, CType cType2) throws UnpositionedError {
        CPrimitiveType cPrimitiveType = cExpressionContext.getTypeFactory().getPrimitiveType(0);
        if (cType == cPrimitiveType && cType2 == cPrimitiveType) {
            return cPrimitiveType;
        }
        if (cType.isOrdinal() && cType2.isOrdinal()) {
            return CNumericType.binaryPromote(cExpressionContext, cType, cType2);
        }
        throw new UnpositionedError(KjcMessages.BITWISE_BADTYPE, cType, cType2);
    }

    public JExpression constantFolding(TypeFactory typeFactory) {
        if (this.left.getType(typeFactory) == typeFactory.getPrimitiveType(0)) {
            boolean bl = this.compute(this.left.booleanValue(), this.right.booleanValue());
            return new JBooleanLiteral(this.getTokenReference(), bl);
        }
        if (this.left.getType(typeFactory) == typeFactory.getPrimitiveType(6)) {
            long l = this.compute(this.left.longValue(), this.right.longValue());
            return new JLongLiteral(this.getTokenReference(), l);
        }
        if (this.left.getType(typeFactory) == typeFactory.getPrimitiveType(5)) {
            int n = this.compute(this.left.intValue(), this.right.intValue());
            return new JIntLiteral(this.getTokenReference(), n);
        }
        throw new InconsistencyException();
    }

    public int compute(int n, int n2) {
        switch (this.oper) {
            case 9: {
                return n & n2;
            }
            case 11: {
                return n | n2;
            }
            case 10: {
                return n ^ n2;
            }
        }
        throw new InconsistencyException();
    }

    public long compute(long l, long l2) {
        switch (this.oper) {
            case 9: {
                return l & l2;
            }
            case 11: {
                return l | l2;
            }
            case 10: {
                return l ^ l2;
            }
        }
        throw new InconsistencyException();
    }

    public boolean compute(boolean bl, boolean bl2) {
        switch (this.oper) {
            case 9: {
                return bl & bl2;
            }
            case 11: {
                return bl | bl2;
            }
            case 10: {
                return bl ^ bl2;
            }
        }
        throw new InconsistencyException();
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitBitwiseExpression(this, this.oper, this.left, this.right);
    }

    public static int getOpcode(int n, CType cType) {
        if (cType.getTypeID() == 6) {
            switch (n) {
                case 9: {
                    return 127;
                }
                case 11: {
                    return 129;
                }
                case 10: {
                    return 131;
                }
            }
        } else {
            switch (n) {
                case 9: {
                    return 126;
                }
                case 11: {
                    return 128;
                }
                case 10: {
                    return 130;
                }
            }
        }
        return -1;
    }

    public void genCode(GenerationContext generationContext, boolean bl) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        TypeFactory typeFactory = generationContext.getTypeFactory();
        this.setLineNumber(codeSequence);
        this.left.genCode(generationContext, false);
        this.right.genCode(generationContext, false);
        codeSequence.plantNoArgInstruction(JBitwiseExpression.getOpcode(this.oper, this.getType(typeFactory)));
        if (bl) {
            codeSequence.plantPopInstruction(this.getType(typeFactory));
        }
    }

    public JBitwiseExpression(TokenReference tokenReference, int n, JExpression jExpression, JExpression jExpression2) {
        super(tokenReference, jExpression, jExpression2);
        this.oper = n;
    }
}

