/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.classfile.PushLiteralInstruction;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CType;
import at.dms.kjc.CodeLabel;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JExpression;
import at.dms.kjc.JLiteral;
import at.dms.kjc.JStringLiteral;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.TypeFactory;
import at.dms.util.InconsistencyException;

public class JBooleanLiteral
extends JLiteral {
    private final boolean value;

    public CType getType(TypeFactory typeFactory) {
        return typeFactory.getPrimitiveType(0);
    }

    public boolean booleanValue() {
        return this.value;
    }

    public boolean isDefault() {
        return this.value ^ true;
    }

    public JExpression convertType(CExpressionContext cExpressionContext, CType cType) {
        switch (cType.getTypeID()) {
            case 11: {
                return this;
            }
            case 9: {
                if (cType != cExpressionContext.getTypeFactory().createReferenceType(10)) {
                    throw new InconsistencyException("cannot convert from boolean to " + cType);
                }
                return new JStringLiteral(this.getTokenReference(), "" + this.value);
            }
        }
        throw new InconsistencyException("cannot convert from boolean to " + cType);
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitBooleanLiteral(this.value);
    }

    public void genCode(GenerationContext generationContext, boolean bl) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        if (!bl) {
            this.setLineNumber(codeSequence);
            codeSequence.plantInstruction(new PushLiteralInstruction(this.value ? 1 : 0));
        }
    }

    public void genBranch(boolean bl, GenerationContext generationContext, CodeLabel codeLabel) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        this.setLineNumber(codeSequence);
        if (this.value == bl) {
            codeSequence.plantJumpInstruction(167, codeLabel);
        }
    }

    public JBooleanLiteral(TokenReference tokenReference, boolean bl) {
        super(tokenReference);
        this.value = bl;
    }
}

