/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.classfile.PushLiteralInstruction;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CType;
import at.dms.kjc.CTypeContext;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JCharLiteral;
import at.dms.kjc.JDoubleLiteral;
import at.dms.kjc.JExpression;
import at.dms.kjc.JFloatLiteral;
import at.dms.kjc.JIntLiteral;
import at.dms.kjc.JLiteral;
import at.dms.kjc.JLongLiteral;
import at.dms.kjc.JShortLiteral;
import at.dms.kjc.JStringLiteral;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.TypeFactory;
import at.dms.util.InconsistencyException;

public class JByteLiteral
extends JLiteral {
    private final byte value;

    public CType getType(TypeFactory typeFactory) {
        return typeFactory.getPrimitiveType(1);
    }

    public byte byteValue() {
        return this.value;
    }

    public boolean isDefault() {
        boolean bl = false;
        if (this.value == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isAssignableTo(CTypeContext cTypeContext, CType cType) {
        switch (cType.getTypeID()) {
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                boolean bl = false;
                if ((char)this.value == this.value) {
                    bl = true;
                }
                return bl;
            }
        }
        return cTypeContext.getTypeFactory().getPrimitiveType(1).isAssignableTo(cTypeContext, cType);
    }

    public JExpression convertType(CExpressionContext cExpressionContext, CType cType) {
        switch (cType.getTypeID()) {
            case 2: {
                return this;
            }
            case 3: {
                return new JShortLiteral(this.getTokenReference(), this.value);
            }
            case 4: {
                return new JCharLiteral(this.getTokenReference(), (char)this.value);
            }
            case 5: {
                return new JIntLiteral(this.getTokenReference(), this.value);
            }
            case 6: {
                return new JLongLiteral(this.getTokenReference(), this.value);
            }
            case 7: {
                return new JFloatLiteral(this.getTokenReference(), this.value);
            }
            case 8: {
                return new JDoubleLiteral(this.getTokenReference(), this.value);
            }
            case 9: {
                if (cType != cExpressionContext.getTypeFactory().createReferenceType(10)) {
                    throw new InconsistencyException("cannot convert from byte to " + cType);
                }
                return new JStringLiteral(this.getTokenReference(), "" + this.value);
            }
        }
        throw new InconsistencyException("cannot convert from byte to " + cType);
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitByteLiteral(this.value);
    }

    public void genCode(GenerationContext generationContext, boolean bl) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        if (!bl) {
            this.setLineNumber(codeSequence);
            codeSequence.plantInstruction(new PushLiteralInstruction(this.value));
        }
    }

    public JByteLiteral(TokenReference tokenReference, byte by) {
        super(tokenReference);
        this.value = by;
    }
}

