/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.CWarning;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CNumericType;
import at.dms.kjc.CReferenceType;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JExpression;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.TypeFactory;

public class JCastExpression
extends JExpression {
    protected JExpression expr;
    protected CType dest;

    public CType getType(TypeFactory typeFactory) {
        return this.dest;
    }

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        TypeFactory typeFactory = cExpressionContext.getTypeFactory();
        this.expr = this.expr.analyse(cExpressionContext);
        try {
            this.dest = this.dest.checkType(cExpressionContext);
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
        this.check(cExpressionContext, this.expr.getType(typeFactory).isCastableTo(this.dest), KjcMessages.CAST_CANT, this.expr.getType(typeFactory), this.dest);
        if (!this.expr.getType(typeFactory).isPrimitive() && this.expr.getType(typeFactory).isAssignableTo(cExpressionContext, this.dest) && this.expr.getType(typeFactory) != cExpressionContext.getTypeFactory().getNullType()) {
            cExpressionContext.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.UNNECESSARY_CAST, this.expr.getType(typeFactory), this.dest));
        }
        if (this.expr.isConstant()) {
            return this.expr.convertType(cExpressionContext, this.dest);
        }
        if (!this.dest.isAssignableTo(cExpressionContext, this.expr.getType(typeFactory))) {
            return this.expr.convertType(cExpressionContext, this.dest);
        }
        return this;
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitCastExpression(this, this.expr, this.dest);
    }

    public void genCode(GenerationContext generationContext, boolean bl) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        TypeFactory typeFactory = generationContext.getTypeFactory();
        this.setLineNumber(codeSequence);
        this.expr.genCode(generationContext, false);
        if (this.dest.isNumeric()) {
            ((CNumericType)this.expr.getType(typeFactory)).genCastTo((CNumericType)this.dest, generationContext);
        } else if (this.dest instanceof CReferenceType) {
            codeSequence.plantClassRefInstruction(192, ((CReferenceType)this.dest).getQualifiedName());
        }
        if (bl) {
            codeSequence.plantPopInstruction(this.dest);
        }
    }

    public JCastExpression(TokenReference tokenReference, JExpression jExpression, CType cType) {
        super(tokenReference);
        this.expr = jExpression;
        this.dest = cType;
    }
}

