/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.classfile.PushLiteralInstruction;
import at.dms.compiler.NumberParser;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CType;
import at.dms.kjc.CTypeContext;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JByteLiteral;
import at.dms.kjc.JDoubleLiteral;
import at.dms.kjc.JExpression;
import at.dms.kjc.JFloatLiteral;
import at.dms.kjc.JIntLiteral;
import at.dms.kjc.JLiteral;
import at.dms.kjc.JLongLiteral;
import at.dms.kjc.JShortLiteral;
import at.dms.kjc.JStringLiteral;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.TypeFactory;
import at.dms.util.InconsistencyException;

public class JCharLiteral
extends JLiteral {
    private char value;

    public CType getType(TypeFactory typeFactory) {
        return typeFactory.getPrimitiveType(2);
    }

    public char charValue() {
        return this.value;
    }

    public boolean isDefault() {
        boolean bl = false;
        if (this.value == '\u0000') {
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final char decodeChar(String string) throws UnpositionedError {
        if (string.startsWith("\\u")) {
            return (char)((int)NumberParser.decodeHexInt(false, string.substring(2)));
        }
        if (!string.startsWith("\\")) return (char)string.charAt(0);
        if (string.length() <= 1) return (char)string.charAt(0);
        if (string.charAt(1) >= '0' && string.charAt(1) <= '9') {
            int n = (char)NumberParser.decodeOctInt(false, string.substring(1));
            if (n <= 377) return (char)n;
            throw new UnpositionedError(KjcMessages.INVALID_OCTAL_CHAR, string);
        }
        if (string.equals("\\b")) {
            return (char)8;
        }
        if (string.equals("\\r")) {
            return (char)13;
        }
        if (string.equals("\\t")) {
            return (char)9;
        }
        if (string.equals("\\n")) {
            return (char)10;
        }
        if (string.equals("\\f")) {
            return (char)12;
        }
        if (string.equals("\\\"")) {
            return (char)34;
        }
        if (string.equals("\\'")) {
            return (char)39;
        }
        if (!string.equals("\\\\")) throw new UnpositionedError(KjcMessages.INVALID_ESCAPE_SEQUENCE, string);
        return (char)92;
    }

    public boolean isAssignableTo(CTypeContext cTypeContext, CType cType) {
        switch (cType.getTypeID()) {
            case 2: {
                boolean bl = false;
                if ((byte)this.value == this.value) {
                    bl = true;
                }
                return bl;
            }
            case 3: {
                boolean bl = false;
                if ((short)this.value == this.value) {
                    bl = true;
                }
                return bl;
            }
            case 4: {
                return true;
            }
        }
        return cTypeContext.getTypeFactory().getPrimitiveType(2).isAssignableTo(cTypeContext, cType);
    }

    public JExpression convertType(CExpressionContext cExpressionContext, CType cType) throws PositionedError {
        switch (cType.getTypeID()) {
            case 2: {
                return new JByteLiteral(this.getTokenReference(), (byte)this.value);
            }
            case 3: {
                return new JShortLiteral(this.getTokenReference(), (short)this.value);
            }
            case 4: {
                return this;
            }
            case 5: {
                return new JIntLiteral(this.getTokenReference(), this.value);
            }
            case 6: {
                return new JLongLiteral(this.getTokenReference(), this.value);
            }
            case 7: {
                return new JFloatLiteral(this.getTokenReference(), this.value);
            }
            case 8: {
                return new JDoubleLiteral(this.getTokenReference(), this.value);
            }
            case 9: {
                if (cType != cExpressionContext.getTypeFactory().createReferenceType(10)) {
                    throw new InconsistencyException("cannot convert from char to " + cType);
                }
                return new JStringLiteral(this.getTokenReference(), "" + this.value);
            }
        }
        throw new InconsistencyException("cannot convert from char to " + cType);
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitCharLiteral(this.value);
    }

    public void genCode(GenerationContext generationContext, boolean bl) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        if (!bl) {
            this.setLineNumber(codeSequence);
            codeSequence.plantInstruction(new PushLiteralInstruction(this.value));
        }
    }

    public JCharLiteral(TokenReference tokenReference, String string) throws PositionedError {
        super(tokenReference);
        try {
            this.value = JCharLiteral.decodeChar(string);
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(tokenReference);
        }
    }

    public JCharLiteral(TokenReference tokenReference, char c) {
        super(tokenReference);
        this.value = c;
    }
}

