/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.CWarning;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CField;
import at.dms.kjc.CInitializerContext;
import at.dms.kjc.CNumericType;
import at.dms.kjc.CReferenceType;
import at.dms.kjc.CType;
import at.dms.kjc.CVoidType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JAddExpression;
import at.dms.kjc.JAssignmentExpression;
import at.dms.kjc.JBinaryArithmeticExpression;
import at.dms.kjc.JBitwiseExpression;
import at.dms.kjc.JDivideExpression;
import at.dms.kjc.JExpression;
import at.dms.kjc.JFieldAccessExpression;
import at.dms.kjc.JMinusExpression;
import at.dms.kjc.JModuloExpression;
import at.dms.kjc.JMultExpression;
import at.dms.kjc.JParenthesedExpression;
import at.dms.kjc.JShiftExpression;
import at.dms.kjc.JTypeNameExpression;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.TypeFactory;
import at.dms.util.InconsistencyException;

public class JCompoundAssignmentExpression
extends JAssignmentExpression {
    protected int oper;

    public boolean isStatementExpression() {
        return true;
    }

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        Object object;
        TypeFactory typeFactory = cExpressionContext.getTypeFactory();
        if (this.left instanceof JParenthesedExpression) {
            cExpressionContext.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.PARENTHESED_LVALUE));
        }
        this.left = this.left.analyse(new CExpressionContext(cExpressionContext, cExpressionContext.getEnvironment(), true, false));
        this.check(cExpressionContext, this.left.isLValue(cExpressionContext), KjcMessages.ASSIGNMENT_NOTLVALUE);
        if (cExpressionContext.getMethodContext() instanceof CInitializerContext && this.left instanceof JFieldAccessExpression && cExpressionContext.getClassContext().getCClass() == ((JFieldAccessExpression)this.left).getField().getOwner()) {
            CField cField = ((JFieldAccessExpression)this.left).getField();
            boolean bl = false;
            if (cField.isAnalysed() || cExpressionContext.isLeftSide() || cField.isSynthetic()) {
                bl = true;
            }
            this.check((CContext)cExpressionContext, bl, KjcMessages.USE_BEFORE_DEF, cField.getIdent());
        }
        try {
            this.left.setInitialized(cExpressionContext);
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
        this.right = this.right.analyse(new CExpressionContext(cExpressionContext, cExpressionContext.getEnvironment(), false, false));
        if (this.right instanceof JTypeNameExpression) {
            this.check((CContext)cExpressionContext, false, KjcMessages.VAR_UNKNOWN, ((JTypeNameExpression)this.right).getQualifiedName());
        }
        boolean bl = true;
        this.type = this.left.getType(typeFactory);
        try {
            switch (this.oper) {
                case 3: {
                    this.type = JMultExpression.computeType(cExpressionContext, this.left.getType(typeFactory), this.right.getType(typeFactory));
                    break;
                }
                case 4: {
                    this.type = JDivideExpression.computeType(cExpressionContext, this.left.getType(typeFactory), this.right.getType(typeFactory));
                    break;
                }
                case 5: {
                    this.type = JModuloExpression.computeType(cExpressionContext, this.left.getType(typeFactory), this.right.getType(typeFactory));
                    break;
                }
                case 1: {
                    object = cExpressionContext.getTypeFactory();
                    CReferenceType cReferenceType = object.createReferenceType(10);
                    CVoidType cVoidType = object.getVoidType();
                    if (this.left.getType(typeFactory).equals(cReferenceType)) {
                        if (this.right.getType(typeFactory).getTypeID() == 1) {
                            throw new UnpositionedError(KjcMessages.ADD_BADTYPE, cReferenceType, cVoidType);
                        }
                        this.type = cReferenceType;
                        bl = false;
                        break;
                    }
                    this.type = JBinaryArithmeticExpression.computeType(cExpressionContext, "+", this.left.getType(typeFactory), this.right.getType(typeFactory));
                    break;
                }
                case 2: {
                    this.type = JMinusExpression.computeType(cExpressionContext, this.left.getType(typeFactory), this.right.getType(typeFactory));
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    this.type = JShiftExpression.computeType(cExpressionContext, this.left.getType(typeFactory), this.right.getType(typeFactory));
                    bl = false;
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    this.type = JBitwiseExpression.computeType(cExpressionContext, this.left.getType(typeFactory), this.right.getType(typeFactory));
                    break;
                }
                default: {
                    throw new InconsistencyException("unexpected operator " + this.oper);
                }
            }
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
        this.check(cExpressionContext, this.type.isCastableTo(this.left.getType(typeFactory)), KjcMessages.ASSIGNMENT_BADTYPE, this.right.getType(typeFactory), this.left.getType(typeFactory));
        if (bl && !this.right.isAssignableTo(cExpressionContext, this.left.getType(typeFactory))) {
            cExpressionContext.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.NARROWING_COMPOUND_ASSIGNMENT, this.right.getType(typeFactory), this.left.getType(typeFactory)));
        }
        if (bl) {
            this.right = this.right.convertType(cExpressionContext, this.type);
        }
        if (this.left.requiresAccessor()) {
            object = this.left.getAccessor(new JExpression[]{this.right}, this.oper);
            ((JExpression)object).analyse(cExpressionContext);
            return object;
        }
        return this;
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitCompoundAssignmentExpression(this, this.oper, this.left, this.right);
    }

    public void genCode(GenerationContext generationContext, boolean bl) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        TypeFactory typeFactory = generationContext.getTypeFactory();
        this.setLineNumber(codeSequence);
        this.left.genStartAndLoadStoreCode(generationContext, false);
        if (this.oper == 1 && this.type.equals(typeFactory.createReferenceType(10))) {
            this.right.genCode(generationContext, false);
            if (!this.right.getType(typeFactory).isReference()) {
                codeSequence.plantMethodRefInstruction(184, "java/lang/String", "valueOf", "(" + this.right.getType(typeFactory).getSignature() + ")Ljava/lang/String;");
            } else if (!this.right.getType(typeFactory).equals(typeFactory.createReferenceType(10))) {
                codeSequence.plantMethodRefInstruction(184, "java/lang/String", "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;");
            }
            codeSequence.plantMethodRefInstruction(182, "java/lang/String", "concat", "(Ljava/lang/String;)Ljava/lang/String;");
        } else {
            if (this.type.isNumeric() && this.left.getType(typeFactory).isNumeric()) {
                ((CNumericType)this.left.getType(typeFactory)).genCastTo((CNumericType)this.type, generationContext);
            }
            this.right.genCode(generationContext, false);
            int n = -1;
            switch (this.oper) {
                case 3: {
                    n = JMultExpression.getOpcode(this.getType(typeFactory));
                    break;
                }
                case 4: {
                    n = JDivideExpression.getOpcode(this.getType(typeFactory));
                    break;
                }
                case 5: {
                    n = JModuloExpression.getOpcode(this.getType(typeFactory));
                    break;
                }
                case 1: {
                    n = JAddExpression.getOpcode(this.getType(typeFactory));
                    break;
                }
                case 2: {
                    n = JMinusExpression.getOpcode(this.getType(typeFactory));
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    if (this.type.isNumeric() && this.right.getType(typeFactory).isNumeric() && this.right.getType(typeFactory).getTypeID() == 6) {
                        ((CNumericType)this.right.getType(typeFactory)).genCastTo((CNumericType)this.type, generationContext);
                    }
                    n = JShiftExpression.getOpcode(this.oper, this.getType(typeFactory));
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    n = JBitwiseExpression.getOpcode(this.oper, this.getType(typeFactory));
                }
            }
            codeSequence.plantNoArgInstruction(n);
            if (this.type.isNumeric() && this.left.getType(typeFactory).isNumeric()) {
                ((CNumericType)this.type).genCastTo((CNumericType)this.left.getType(typeFactory), generationContext);
            }
        }
        this.left.genEndStoreCode(generationContext, bl);
    }

    public JCompoundAssignmentExpression(TokenReference tokenReference, int n, JExpression jExpression, JExpression jExpression2) {
        super(tokenReference, jExpression, jExpression2);
        this.oper = n;
    }

    public JCompoundAssignmentExpression(TokenReference tokenReference, int n, JExpression jExpression, JExpression jExpression2, CType cType) {
        super(tokenReference, jExpression, jExpression2);
        this.oper = n;
        this.type = cType;
    }
}

