/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CBodyContext;
import at.dms.kjc.CLineError;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JStatement;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;

public class JCompoundStatement
extends JStatement {
    private JStatement[] body;

    public void analyse(CBodyContext cBodyContext) throws PositionedError {
        int n = 0;
        while (n < this.body.length) {
            if (!cBodyContext.isReachable()) {
                throw new CLineError(this.body[n].getTokenReference(), KjcMessages.STATEMENT_UNREACHABLE);
            }
            try {
                this.body[n].analyse(cBodyContext);
            }
            catch (CLineError cLineError) {
                cBodyContext.reportTrouble(cLineError);
            }
            ++n;
        }
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitCompoundStatement(this, this.body);
    }

    public void genCode(GenerationContext generationContext) {
        int n = 0;
        while (n < this.body.length) {
            this.body[n].genCode(generationContext);
            ++n;
        }
    }

    public JCompoundStatement(TokenReference tokenReference, JStatement[] jStatementArray) {
        super(tokenReference, null);
        this.body = jStatementArray == null ? JStatement.EMPTY : jStatementArray;
    }
}

