/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CNullType;
import at.dms.kjc.CNumericType;
import at.dms.kjc.CPrimitiveType;
import at.dms.kjc.CSimpleBodyContext;
import at.dms.kjc.CType;
import at.dms.kjc.CodeLabel;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JExpression;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.TypeFactory;

public class JConditionalExpression
extends JExpression {
    private CType type;
    private JExpression cond;
    private JExpression left;
    private JExpression right;

    public CType getType(TypeFactory typeFactory) {
        return this.type;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JConditionalExpression[");
        stringBuffer.append(this.cond.toString());
        stringBuffer.append(", ");
        stringBuffer.append(this.left.toString());
        stringBuffer.append(", ");
        stringBuffer.append(this.right.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        TypeFactory typeFactory = cExpressionContext.getTypeFactory();
        CPrimitiveType cPrimitiveType = typeFactory.getPrimitiveType(0);
        this.cond = this.cond.analyse(cExpressionContext);
        CSimpleBodyContext cSimpleBodyContext = new CSimpleBodyContext(cExpressionContext.getBodyContext(), cExpressionContext.getEnvironment(), cExpressionContext.getBodyContext());
        CExpressionContext cExpressionContext2 = new CExpressionContext(cSimpleBodyContext, cExpressionContext.getEnvironment(), cExpressionContext.isLeftSide(), cExpressionContext.discardValue());
        this.left = this.left.analyse(cExpressionContext2);
        this.right = this.right.analyse(cExpressionContext);
        cExpressionContext.getBodyContext().merge(cSimpleBodyContext);
        boolean bl = false;
        if (this.cond.getType(typeFactory) == cPrimitiveType) {
            bl = true;
        }
        this.check(cExpressionContext, bl, KjcMessages.TRINARY_BADCOND);
        CType cType = this.left.getType(typeFactory);
        CType cType2 = this.right.getType(typeFactory);
        CPrimitiveType cPrimitiveType2 = typeFactory.getPrimitiveType(7);
        CPrimitiveType cPrimitiveType3 = typeFactory.getPrimitiveType(1);
        CPrimitiveType cPrimitiveType4 = typeFactory.getPrimitiveType(5);
        CPrimitiveType cPrimitiveType5 = typeFactory.getPrimitiveType(2);
        if (cType.equals(cType2)) {
            this.type = cType;
        } else if (cType.isNumeric() && cType2.isNumeric()) {
            if (cType == cPrimitiveType3 && cType2 == cPrimitiveType2 || cType2 == cPrimitiveType3 && cType == cPrimitiveType2) {
                this.type = cPrimitiveType2;
            } else if ((cType == cPrimitiveType3 || cType == cPrimitiveType2 || cType == cPrimitiveType5) && cType2 == cPrimitiveType4 && this.right.isConstant() && this.right.isAssignableTo(cExpressionContext, cType)) {
                this.type = cType;
            } else if ((cType2 == cPrimitiveType3 || cType2 == cPrimitiveType2 || cType2 == cPrimitiveType5) && cType == cPrimitiveType4 && this.left.isConstant() && this.left.isAssignableTo(cExpressionContext, cType2)) {
                this.type = cType2;
            } else {
                this.type = CNumericType.binaryPromote(cExpressionContext, cType, cType2);
                boolean bl2 = false;
                if (this.type != null) {
                    bl2 = true;
                }
                this.check(cExpressionContext, bl2, KjcMessages.TRINARY_INCOMP, cType, cType2);
            }
            this.left = this.left.convertType(cExpressionContext, this.type);
            this.right = this.right.convertType(cExpressionContext, this.type);
        } else if (cType.isReference() && cType2.isReference()) {
            CNullType cNullType = typeFactory.getNullType();
            if (cType == cNullType) {
                this.type = cType2;
            } else if (cType2 == cNullType) {
                this.type = cType;
            } else if (cType.isAssignableTo(cExpressionContext, cType2)) {
                this.type = cType2;
            } else if (cType2.isAssignableTo(cExpressionContext, cType)) {
                this.type = cType;
            } else {
                this.check(cExpressionContext, false, KjcMessages.TRINARY_INCOMP, cType, cType2);
            }
        } else {
            this.check(cExpressionContext, false, KjcMessages.TRINARY_INCOMP, cType, cType2);
        }
        if (this.cond.isConstant() && this.left.isConstant() && this.right.isConstant()) {
            return this.cond.booleanValue() ? this.left : this.right;
        }
        return this;
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitConditionalExpression(this, this.cond, this.left, this.right);
    }

    public void genCode(GenerationContext generationContext, boolean bl) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        this.setLineNumber(codeSequence);
        CodeLabel codeLabel = new CodeLabel();
        CodeLabel codeLabel2 = new CodeLabel();
        this.cond.genBranch(false, generationContext, codeLabel);
        this.left.genCode(generationContext, bl);
        codeSequence.plantJumpInstruction(167, codeLabel2);
        codeSequence.plantLabel(codeLabel);
        this.right.genCode(generationContext, bl);
        codeSequence.plantLabel(codeLabel2);
    }

    public JConditionalExpression(TokenReference tokenReference, JExpression jExpression, JExpression jExpression2, JExpression jExpression3) {
        super(tokenReference);
        this.cond = jExpression;
        this.left = jExpression2;
        this.right = jExpression3;
    }
}

