/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.JavaStyleComment;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CBodyContext;
import at.dms.kjc.CContext;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JLoopStatement;
import at.dms.kjc.JStatement;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;

public class JContinueStatement
extends JStatement {
    private final String label;
    private JStatement target;

    public void analyse(CBodyContext cBodyContext) throws PositionedError {
        if (this.label != null) {
            this.target = cBodyContext.getLabeledStatement(this.label);
            boolean bl = false;
            if (this.target != null) {
                bl = true;
            }
            this.check((CContext)cBodyContext, bl, KjcMessages.LABEL_UNKNOWN, this.label);
            this.check(cBodyContext, this.target instanceof JLoopStatement, KjcMessages.CONTINUE_NOTLOOP);
        } else {
            this.target = cBodyContext.getNearestContinuableStatement();
            boolean bl = false;
            if (this.target != null) {
                bl = true;
            }
            this.check(cBodyContext, bl, KjcMessages.CANNOT_CONTINUE);
        }
        cBodyContext.addContinue(this.target);
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitContinueStatement(this, this.label);
    }

    public void genCode(GenerationContext generationContext) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        this.setLineNumber(codeSequence);
        codeSequence.plantBreak(this.target, generationContext);
        codeSequence.plantJumpInstruction(167, this.target.getContinueLabel());
        this.target = null;
    }

    public JContinueStatement(TokenReference tokenReference, String string, JavaStyleComment[] javaStyleCommentArray) {
        super(tokenReference, javaStyleCommentArray);
        this.label = string;
    }
}

