/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.CWarning;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CNumericType;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JBinaryArithmeticExpression;
import at.dms.kjc.JExpression;
import at.dms.kjc.JLiteral;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.TypeFactory;

public class JDivideExpression
extends JBinaryArithmeticExpression {
    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        TypeFactory typeFactory = cExpressionContext.getTypeFactory();
        this.left = this.left.analyse(cExpressionContext);
        this.right = this.right.analyse(cExpressionContext);
        try {
            this.type = JDivideExpression.computeType(cExpressionContext, this.left.getType(typeFactory), this.right.getType(typeFactory));
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
        if (this.type.isOrdinal() && this.right.isConstant() && ((JLiteral)this.right).isDefault()) {
            cExpressionContext.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.DIVIDE_BY_ZERO_INT));
        }
        this.left = this.left.convertType(cExpressionContext, this.type);
        this.right = this.right.convertType(cExpressionContext, this.type);
        if (this.left.isConstant() && this.right.isConstant() && (!this.right.getType(typeFactory).isOrdinal() || !((JLiteral)this.right).isDefault())) {
            return this.constantFolding(typeFactory);
        }
        return this;
    }

    public static CType computeType(CExpressionContext cExpressionContext, CType cType, CType cType2) throws UnpositionedError {
        if (cType.isNumeric() && cType2.isNumeric()) {
            return CNumericType.binaryPromote(cExpressionContext, cType, cType2);
        }
        throw new UnpositionedError(KjcMessages.DIVIDE_BADTYPE, cType, cType2);
    }

    public int compute(int n, int n2) {
        return n / n2;
    }

    public long compute(long l, long l2) {
        return l / l2;
    }

    public float compute(float f, float f2) {
        return f / f2;
    }

    public double compute(double d, double d2) {
        return d / d2;
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitBinaryExpression(this, "/", this.left, this.right);
    }

    public static int getOpcode(CType cType) {
        switch (cType.getTypeID()) {
            case 7: {
                return 110;
            }
            case 6: {
                return 109;
            }
            case 8: {
                return 111;
            }
        }
        return 108;
    }

    public void genCode(GenerationContext generationContext, boolean bl) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        TypeFactory typeFactory = generationContext.getTypeFactory();
        this.setLineNumber(codeSequence);
        this.left.genCode(generationContext, false);
        this.right.genCode(generationContext, false);
        codeSequence.plantNoArgInstruction(JDivideExpression.getOpcode(this.getType(typeFactory)));
        if (bl) {
            codeSequence.plantPopInstruction(this.getType(typeFactory));
        }
    }

    public JDivideExpression(TokenReference tokenReference, JExpression jExpression, JExpression jExpression2) {
        super(tokenReference, jExpression, jExpression2);
    }
}

