/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.CWarning;
import at.dms.compiler.JavaStyleComment;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CBlockError;
import at.dms.kjc.CBodyContext;
import at.dms.kjc.CContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CLoopContext;
import at.dms.kjc.CodeLabel;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JAssignmentExpression;
import at.dms.kjc.JExpression;
import at.dms.kjc.JLoopStatement;
import at.dms.kjc.JStatement;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.TypeFactory;

public class JDoStatement
extends JLoopStatement {
    private JExpression cond;
    private JStatement body;

    public void analyse(CBodyContext cBodyContext) throws PositionedError {
        try {
            TypeFactory typeFactory = cBodyContext.getTypeFactory();
            CLoopContext cLoopContext = new CLoopContext(cBodyContext, cBodyContext.getEnvironment(), this);
            this.body.analyse(cLoopContext);
            if (cLoopContext.isContinueTarget()) {
                if (cLoopContext.isReachable()) {
                    cLoopContext.merge(cLoopContext.getContinueContextSummary());
                } else {
                    cLoopContext.adopt(cLoopContext.getContinueContextSummary());
                    cLoopContext.setReachable(true);
                }
            }
            this.cond = this.cond.analyse(new CExpressionContext(cLoopContext, cBodyContext.getEnvironment()));
            boolean bl = false;
            if (this.cond.getType(typeFactory) == typeFactory.getPrimitiveType(0)) {
                bl = true;
            }
            this.check((CContext)cLoopContext, bl, KjcMessages.DO_COND_NOTBOOLEAN, this.cond.getType(typeFactory));
            if (this.cond instanceof JAssignmentExpression) {
                cLoopContext.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.ASSIGNMENT_IN_CONDITION));
            }
            cLoopContext.close(this.getTokenReference());
            if (this.cond.isConstant() && this.cond.booleanValue()) {
                cBodyContext.setReachable(false);
            }
            if (cLoopContext.isBreakTarget()) {
                if (cBodyContext.isReachable()) {
                    cBodyContext.merge(cLoopContext.getBreakContextSummary());
                } else {
                    cBodyContext.adopt(cLoopContext.getBreakContextSummary());
                }
            }
        }
        catch (CBlockError cBlockError) {
            cBodyContext.reportTrouble(cBlockError);
        }
    }

    public void accept(KjcVisitor kjcVisitor) {
        super.accept(kjcVisitor);
        kjcVisitor.visitDoStatement(this, this.cond, this.body);
    }

    public void genCode(GenerationContext generationContext) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        this.setLineNumber(codeSequence);
        codeSequence.pushContext(this);
        CodeLabel codeLabel = new CodeLabel();
        codeSequence.plantLabel(codeLabel);
        this.body.genCode(generationContext);
        codeSequence.plantLabel(this.getContinueLabel());
        this.cond.genBranch(true, generationContext, codeLabel);
        codeSequence.plantLabel(this.getBreakLabel());
        codeSequence.popContext(this);
    }

    public JDoStatement(TokenReference tokenReference, JExpression jExpression, JStatement jStatement, JavaStyleComment[] javaStyleCommentArray) {
        super(tokenReference, javaStyleCommentArray);
        this.cond = jExpression;
        this.body = jStatement;
    }
}

