/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.classfile.PushLiteralInstruction;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JByteLiteral;
import at.dms.kjc.JCharLiteral;
import at.dms.kjc.JExpression;
import at.dms.kjc.JFloatLiteral;
import at.dms.kjc.JIntLiteral;
import at.dms.kjc.JLiteral;
import at.dms.kjc.JLongLiteral;
import at.dms.kjc.JShortLiteral;
import at.dms.kjc.JStringLiteral;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.TypeFactory;
import at.dms.util.InconsistencyException;

public class JDoubleLiteral
extends JLiteral {
    private static final long ZERO_BITS = Double.doubleToLongBits(0.0);
    private final double value;

    private final boolean isZeroLiteral(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            switch (cArray[n]) {
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return false;
                }
                case 'D': 
                case 'E': 
                case 'd': 
                case 'e': {
                    return true;
                }
            }
            ++n;
        }
        return true;
    }

    public CType getType(TypeFactory typeFactory) {
        return typeFactory.getPrimitiveType(3);
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean isDefault() {
        boolean bl = false;
        if (Double.doubleToLongBits(this.value) == ZERO_BITS) {
            bl = true;
        }
        return bl;
    }

    public JExpression convertType(CExpressionContext cExpressionContext, CType cType) {
        switch (cType.getTypeID()) {
            case 2: {
                return new JByteLiteral(this.getTokenReference(), (byte)this.value);
            }
            case 3: {
                return new JShortLiteral(this.getTokenReference(), (short)this.value);
            }
            case 4: {
                return new JCharLiteral(this.getTokenReference(), (char)this.value);
            }
            case 5: {
                return new JIntLiteral(this.getTokenReference(), (int)this.value);
            }
            case 6: {
                return new JLongLiteral(this.getTokenReference(), (long)this.value);
            }
            case 7: {
                return new JFloatLiteral(this.getTokenReference(), (float)this.value);
            }
            case 8: {
                return this;
            }
            case 9: {
                if (cType != cExpressionContext.getTypeFactory().createReferenceType(10)) {
                    throw new InconsistencyException("cannot convert from double to " + cType);
                }
                return new JStringLiteral(this.getTokenReference(), "" + this.value);
            }
        }
        throw new InconsistencyException("cannot convert from double to " + cType);
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitDoubleLiteral(this.value);
    }

    public void genCode(GenerationContext generationContext, boolean bl) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        if (!bl) {
            this.setLineNumber(codeSequence);
            codeSequence.plantInstruction(new PushLiteralInstruction(this.value));
        }
    }

    public JDoubleLiteral(TokenReference tokenReference, String string) throws PositionedError {
        super(tokenReference);
        try {
            this.value = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PositionedError(tokenReference, KjcMessages.INVALID_DOUBLE_LITERAL, (Object)string);
        }
        if (Double.isInfinite(this.value)) {
            throw new PositionedError(tokenReference, KjcMessages.DOUBLE_LITERAL_OVERFLOW, (Object)string);
        }
        if (this.value == 0.0 && !this.isZeroLiteral(string)) {
            throw new PositionedError(tokenReference, KjcMessages.DOUBLE_LITERAL_UNDERFLOW, (Object)string);
        }
    }

    public JDoubleLiteral(TokenReference tokenReference, double d) {
        super(tokenReference);
        this.value = d;
    }
}

