/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.CWarning;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CNumericType;
import at.dms.kjc.CPrimitiveType;
import at.dms.kjc.CReferenceType;
import at.dms.kjc.CType;
import at.dms.kjc.CodeLabel;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JBinaryExpression;
import at.dms.kjc.JBooleanLiteral;
import at.dms.kjc.JExpression;
import at.dms.kjc.JLiteral;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.TypeFactory;
import at.dms.util.InconsistencyException;

public class JEqualityExpression
extends JBinaryExpression {
    protected final boolean equal;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JEqualityExpression[");
        stringBuffer.append(this.left.toString());
        stringBuffer.append(this.equal ? " == " : " != ");
        stringBuffer.append(this.right.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        this.left = this.left.analyse(cExpressionContext);
        this.right = this.right.analyse(cExpressionContext);
        TypeFactory typeFactory = cExpressionContext.getTypeFactory();
        CType cType = this.left.getType(typeFactory);
        CType cType2 = this.right.getType(typeFactory);
        CPrimitiveType cPrimitiveType = typeFactory.getPrimitiveType(0);
        CReferenceType cReferenceType = typeFactory.createReferenceType(10);
        if (cType.isNumeric()) {
            this.check(cExpressionContext, cType2.isNumeric(), KjcMessages.EQUALITY_TYPE, cType, cType2);
            CType cType3 = CNumericType.binaryPromote(cExpressionContext, cType, cType2);
            this.left = this.left.convertType(cExpressionContext, cType3);
            this.right = this.right.convertType(cExpressionContext, cType3);
        } else if (cType == cPrimitiveType) {
            boolean bl = false;
            if (cType2 == cPrimitiveType) {
                bl = true;
            }
            this.check(cExpressionContext, bl, KjcMessages.EQUALITY_TYPE, cType, cType2);
            if (this.left instanceof JBooleanLiteral || this.right instanceof JBooleanLiteral) {
                cExpressionContext.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.COMPARING_BOOLEAN_CONSTANT));
            }
        } else {
            boolean bl = false;
            if (cType.isReference() && cType2.isReference()) {
                bl = true;
            }
            this.check(cExpressionContext, bl, KjcMessages.EQUALITY_TYPE, cType, cType2);
            boolean bl2 = false;
            if (cType2.isCastableTo(cType) || cType.isCastableTo(cType2)) {
                bl2 = true;
            }
            this.check(cExpressionContext, bl2, KjcMessages.EQUALITY_TYPE, cType, cType2);
            if (this.left.getType(typeFactory).equals(cReferenceType) && this.right.getType(typeFactory).equals(cReferenceType) && (this.left.isConstant() || this.right.isConstant())) {
                cExpressionContext.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.STRING_COMPARISON));
            }
        }
        this.type = typeFactory.getPrimitiveType(0);
        if (this.left.isConstant() && this.right.isConstant()) {
            return this.constantFolding(typeFactory);
        }
        return this;
    }

    public JExpression constantFolding(TypeFactory typeFactory) {
        boolean bl;
        switch (this.left.getType(typeFactory).getTypeID()) {
            case 5: {
                boolean bl2 = false;
                if (this.left.intValue() == this.right.intValue()) {
                    bl2 = true;
                }
                bl = bl2;
                break;
            }
            case 6: {
                boolean bl3 = false;
                if (this.left.longValue() == this.right.longValue()) {
                    bl3 = true;
                }
                bl = bl3;
                break;
            }
            case 7: {
                boolean bl4 = false;
                if (this.left.floatValue() == this.right.floatValue()) {
                    bl4 = true;
                }
                bl = bl4;
                break;
            }
            case 8: {
                boolean bl5 = false;
                if (this.left.doubleValue() == this.right.doubleValue()) {
                    bl5 = true;
                }
                bl = bl5;
                break;
            }
            case 11: {
                bl = this.left.booleanValue() ^ this.right.booleanValue() ^ true;
                break;
            }
            case 9: {
                if (this.left.getType(typeFactory) != typeFactory.createReferenceType(10)) {
                    throw new InconsistencyException("unexpected type " + this.left.getType(typeFactory));
                }
                bl = this.left.stringValue().equals(this.right.stringValue());
                break;
            }
            default: {
                throw new InconsistencyException("unexpected type " + this.left.getType(typeFactory));
            }
        }
        return new JBooleanLiteral(this.getTokenReference(), this.equal ? bl : bl ^ true);
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitEqualityExpression(this, this.equal, this.left, this.right);
    }

    public void genCode(GenerationContext generationContext, boolean bl) {
        this.genBooleanResultCode(generationContext, bl);
    }

    protected void genBranch(JExpression jExpression, JExpression jExpression2, boolean bl, GenerationContext generationContext, CodeLabel codeLabel) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        TypeFactory typeFactory = generationContext.getTypeFactory();
        this.setLineNumber(codeSequence);
        if (jExpression.getType(typeFactory).getTypeID() == 12) {
            jExpression2.genCode(generationContext, false);
            codeSequence.plantJumpInstruction(199 - (bl ^ this.equal ^ 1), codeLabel);
        } else if (jExpression2.getType(typeFactory).getTypeID() == 12) {
            jExpression.genCode(generationContext, false);
            codeSequence.plantJumpInstruction(199 - (bl ^ this.equal ^ 1), codeLabel);
        } else if (jExpression.isConstant() && (jExpression.getType(typeFactory).getTypeID() == 5 || jExpression.getType(typeFactory).getTypeID() == 11) && ((JLiteral)jExpression).isDefault()) {
            jExpression2.genCode(generationContext, false);
            codeSequence.plantJumpInstruction(154 - (bl ^ this.equal ^ 1), codeLabel);
        } else if (jExpression2.isConstant() && (jExpression2.getType(typeFactory).getTypeID() == 5 || jExpression2.getType(typeFactory).getTypeID() == 11) && ((JLiteral)jExpression2).isDefault()) {
            jExpression.genCode(generationContext, false);
            codeSequence.plantJumpInstruction(154 - (bl ^ this.equal ^ 1), codeLabel);
        } else {
            jExpression.genCode(generationContext, false);
            jExpression2.genCode(generationContext, false);
            switch (jExpression.getType(typeFactory).getTypeID()) {
                case 9: 
                case 10: 
                case 12: {
                    codeSequence.plantJumpInstruction(166 - (bl ^ this.equal ^ 1), codeLabel);
                    break;
                }
                case 7: {
                    codeSequence.plantNoArgInstruction(149);
                    codeSequence.plantJumpInstruction(154 - (bl ^ this.equal ^ 1), codeLabel);
                    break;
                }
                case 6: {
                    codeSequence.plantNoArgInstruction(148);
                    codeSequence.plantJumpInstruction(154 - (bl ^ this.equal ^ 1), codeLabel);
                    break;
                }
                case 8: {
                    codeSequence.plantNoArgInstruction(151);
                    codeSequence.plantJumpInstruction(154 - (bl ^ this.equal ^ 1), codeLabel);
                    break;
                }
                default: {
                    codeSequence.plantJumpInstruction(160 - (bl ^ this.equal ^ 1), codeLabel);
                }
            }
        }
    }

    public JEqualityExpression(TokenReference tokenReference, boolean bl, JExpression jExpression, JExpression jExpression2) {
        super(tokenReference, jExpression, jExpression2);
        this.equal = bl;
    }
}

