/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.CWarning;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CArrayType;
import at.dms.kjc.CClass;
import at.dms.kjc.CConstructorContext;
import at.dms.kjc.CContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CField;
import at.dms.kjc.CInitializerContext;
import at.dms.kjc.CMethod;
import at.dms.kjc.CReferenceType;
import at.dms.kjc.CSourceClass;
import at.dms.kjc.CSourceField;
import at.dms.kjc.CType;
import at.dms.kjc.CTypeVariable;
import at.dms.kjc.CVariableInfo;
import at.dms.kjc.CodeLabel;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JCastExpression;
import at.dms.kjc.JCheckedExpression;
import at.dms.kjc.JExpression;
import at.dms.kjc.JLiteral;
import at.dms.kjc.JMethodCallExpression;
import at.dms.kjc.JOwnerExpression;
import at.dms.kjc.JSuperExpression;
import at.dms.kjc.JThisExpression;
import at.dms.kjc.JTypeNameExpression;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.TypeFactory;
import at.dms.util.InconsistencyException;

public class JFieldAccessExpression
extends JExpression {
    private boolean constantPrefix;
    private boolean analysed;
    private CType type;
    private boolean startCode;
    protected JExpression prefix;
    protected String ident;
    protected CField field;
    protected CMethod accessor;
    protected SetAccessorData accessorData;

    public String getIdent() {
        return this.ident;
    }

    public CType getType(TypeFactory typeFactory) {
        return this.type;
    }

    public boolean isConstant() {
        boolean bl = false;
        if (this.constantPrefix && this.field.isFinal() && this.field.getValue() != null && this.field.getValue().isConstant()) {
            bl = true;
        }
        return bl;
    }

    public boolean isLValue(CExpressionContext cExpressionContext) {
        if (!this.field.isFinal() || this.field.isSynthetic()) {
            return true;
        }
        if (cExpressionContext.getClassContext().getCClass() == this.field.getOwner() && !((CSourceField)this.field).isFullyDeclared()) {
            return CVariableInfo.mayBeInitialized(cExpressionContext.getBodyContext().getFieldInfo(((CSourceField)this.field).getPosition())) ^ true;
        }
        return false;
    }

    public boolean isFinal() {
        return this.field.isFinal();
    }

    public boolean isInitialized(CExpressionContext cExpressionContext) {
        if (!(this.field instanceof CSourceField) || this.field.isStatic()) {
            return true;
        }
        if (cExpressionContext.getClassContext().getCClass() == this.field.getOwner() && !((CSourceField)this.field).isFullyDeclared()) {
            return CVariableInfo.isInitialized(cExpressionContext.getBodyContext().getFieldInfo(((CSourceField)this.field).getPosition()));
        }
        return true;
    }

    public void setInitialized(CExpressionContext cExpressionContext) {
        if (this.field instanceof CSourceField && cExpressionContext.getClassContext().getCClass() == this.field.getOwner() && !((CSourceField)this.field).isFullyDeclared() || this.field.isFinal()) {
            cExpressionContext.setFieldInfo(((CSourceField)this.field).getPosition(), 3);
        }
    }

    public CField getField() {
        return this.field;
    }

    public JLiteral getLiteral() {
        return (JLiteral)this.field.getValue();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JFieldAccessExpression[");
        stringBuffer.append(this.prefix);
        stringBuffer.append(", ");
        stringBuffer.append(this.ident);
        if (this.isConstant()) {
            stringBuffer.append(" = ");
            stringBuffer.append(this.field);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        TypeFactory typeFactory = cExpressionContext.getTypeFactory();
        if (this.analysed) {
            return this;
        }
        JExpression jExpression = this.prefix;
        CClass cClass = cExpressionContext.getClassContext().getCClass();
        this.findPrefix(cClass, new CExpressionContext(cExpressionContext, cExpressionContext.getEnvironment(), false, false));
        this.checkAccess(cClass, cExpressionContext);
        if (cExpressionContext.getMethodContext() instanceof CInitializerContext || cExpressionContext.getMethodContext() instanceof CConstructorContext) {
            boolean bl = false;
            if (cExpressionContext.isLeftSide() || !this.field.isFinal() || this.field.isSynthetic() || this.field.getOwner() != cClass || !(this.prefix instanceof JThisExpression) || cExpressionContext.getMethodContext() instanceof CConstructorContext && this.field.isStatic() || !(this.field instanceof CSourceField) || CVariableInfo.isInitialized(cExpressionContext.getBodyContext().getFieldInfo(((CSourceField)this.field).getPosition()))) {
                bl = true;
            }
            this.check((CContext)cExpressionContext, bl, KjcMessages.UNINITIALIZED_FIELD_USED, this.field.getIdent());
            boolean bl2 = false;
            if (cExpressionContext.isLeftSide() || cExpressionContext.getMethodContext() instanceof CConstructorContext || this.field.isSynthetic() || this.field.getOwner() != cClass || jExpression != null && !(jExpression instanceof JThisExpression) || !(this.field instanceof CSourceField) || this.field.isAnalysed()) {
                bl2 = true;
            }
            this.check((CContext)cExpressionContext, bl2, KjcMessages.USE_BEFORE_DEF, this.field.getIdent());
        }
        boolean bl = false;
        if (this.field.isStatic() || !(this.prefix instanceof JTypeNameExpression)) {
            bl = true;
        }
        this.check((CContext)cExpressionContext, bl, KjcMessages.FIELD_NOSTATIC, this.ident);
        if (this.field.isStatic() && !(this.prefix instanceof JTypeNameExpression)) {
            cExpressionContext.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.INSTANCE_PREFIXES_STATIC_FIELD, this.ident, this.prefix.getType(typeFactory)));
        }
        if (this.field instanceof CSourceField && !cExpressionContext.discardValue()) {
            ((CSourceField)this.field).setUsed();
        }
        this.type = this.field.getType();
        if (this.isConstant()) {
            return this.field.getValue();
        }
        if (this.field.requiresAccessor(cClass, this.prefix instanceof JSuperExpression)) {
            JExpression[] jExpressionArray;
            CSourceClass cSourceClass = this.field.getAccessorOwner((CSourceClass)cClass);
            if (cExpressionContext.isLeftSide()) {
                this.accessor = null;
                this.accessorData = new SetAccessorData();
                this.accessorData.target = cSourceClass;
                this.accessorData.isSuper = this.prefix instanceof JSuperExpression;
                this.accessorData.typeFactory = cExpressionContext.getTypeFactory();
                return this;
            }
            CMethod cMethod = this.field.getAccessor(cExpressionContext.getTypeFactory(), cSourceClass, false, this.prefix instanceof JSuperExpression, -1);
            if (this.prefix instanceof JSuperExpression) {
                this.prefix = new JFieldAccessExpression(this.getTokenReference(), (JExpression)new JThisExpression(this.getTokenReference()), cClass.getField("this$0"));
            }
            TokenReference tokenReference = this.getTokenReference();
            if (this.field.isStatic()) {
                jExpressionArray = JExpression.EMPTY;
            } else {
                JExpression[] jExpressionArray2 = new JExpression[1];
                jExpressionArray = jExpressionArray2;
                jExpressionArray2[0] = this.prefix;
            }
            JMethodCallExpression jMethodCallExpression = new JMethodCallExpression(tokenReference, null, cMethod, jExpressionArray);
            jMethodCallExpression.analyse(cExpressionContext);
            return jMethodCallExpression;
        }
        CType cType = this.field.getType();
        if (cType.isTypeVariable()) {
            CReferenceType cReferenceType = this.prefix.getType(typeFactory).getCClass().getSubstitution((CTypeVariable)cType, this.prefix.getType(typeFactory).getAllArguments());
            try {
                if (this.field.getType() != cReferenceType && this.field.getType().getErasure(cExpressionContext) != cReferenceType.getErasure(cExpressionContext) && !cExpressionContext.discardValue()) {
                    this.analysed = true;
                    return new JCastExpression(this.getTokenReference(), new JCheckedExpression(this.getTokenReference(), this), cReferenceType).analyse(cExpressionContext);
                }
                this.type = cReferenceType;
            }
            catch (UnpositionedError unpositionedError) {
                throw unpositionedError.addPosition(this.getTokenReference());
            }
        } else if (cType.isArrayType() && ((CArrayType)cType).getBaseType().isTypeVariable()) {
            CReferenceType cReferenceType = this.prefix.getType(typeFactory).getCClass().getSubstitution((CTypeVariable)((CArrayType)cType).getBaseType(), this.prefix.getType(typeFactory).getAllArguments());
            cReferenceType = new CArrayType(cReferenceType, ((CArrayType)cType).getArrayBound());
            try {
                if (this.field.getType().getErasure(cExpressionContext) != cReferenceType.getErasure(cExpressionContext) && !cExpressionContext.discardValue()) {
                    this.analysed = true;
                    return new JCastExpression(this.getTokenReference(), new JCheckedExpression(this.getTokenReference(), this), cReferenceType).analyse(cExpressionContext);
                }
                this.type = cReferenceType;
            }
            catch (UnpositionedError unpositionedError) {
                throw unpositionedError.addPosition(this.getTokenReference());
            }
        } else if (cType.isClassType() && (!this.field.isStatic() || cType.isGenericType())) {
            CReferenceType[][] cReferenceTypeArray = this.prefix.getType(typeFactory).getAllArguments();
            if (!cType.isArrayType()) {
                if (cType.isGenericType() || cReferenceTypeArray.length > 0) {
                    this.type = ((CReferenceType)cType).createSubstitutedType(cClass, (CReferenceType)this.prefix.getType(typeFactory), cClass.getAbstractType().getAllArguments());
                }
            } else if (((CReferenceType)cType).isArrayType() && ((CArrayType)cType).getBaseType().isGenericType()) {
                CType cType2 = ((CArrayType)cType).getBaseType();
                this.type = new CArrayType(((CReferenceType)cType2).createSubstitutedType(cClass, (CReferenceType)this.prefix.getType(typeFactory), cClass.getAbstractType().getAllArguments()), ((CArrayType)cType).getArrayBound());
            }
        }
        return this;
    }

    public boolean requiresAccessor() {
        boolean bl = false;
        if (this.accessor != null || this.accessorData != null) {
            bl = true;
        }
        return bl;
    }

    public JExpression getAccessor(JExpression[] jExpressionArray, int n) {
        JExpression[] jExpressionArray2;
        if (this.getField().isStatic()) {
            jExpressionArray2 = jExpressionArray;
        } else {
            jExpressionArray2 = new JExpression[jExpressionArray.length + 1];
            System.arraycopy(jExpressionArray, 0, jExpressionArray2, 1, jExpressionArray.length);
            jExpressionArray2[0] = this.prefix;
        }
        this.accessor = this.field.getAccessor(this.accessorData.typeFactory, this.accessorData.target, true, this.accessorData.isSuper, n);
        JMethodCallExpression jMethodCallExpression = new JMethodCallExpression(this.getTokenReference(), (JExpression)new JTypeNameExpression(this.getTokenReference(), this.field.getOwner().getAbstractType()), this.accessor.getIdent(), jExpressionArray2);
        return jMethodCallExpression;
    }

    protected void findPrefix(CClass cClass, CExpressionContext cExpressionContext) throws PositionedError {
        TypeFactory typeFactory = cExpressionContext.getTypeFactory();
        if (this.prefix != null) {
            this.prefix = this.prefix.analyse(cExpressionContext);
            this.check((CContext)cExpressionContext, this.prefix.getType(typeFactory).isClassType(), KjcMessages.FIELD_BADACCESS, this.prefix.getType(typeFactory));
            this.constantPrefix = this.prefix instanceof JTypeNameExpression;
        } else {
            this.constantPrefix = true;
            try {
                this.field = cExpressionContext.lookupField(cClass, null, this.ident);
                if (this.field == null) {
                    this.field = cExpressionContext.getClassContext().lookupOuterField(cClass, null, this.ident);
                }
            }
            catch (UnpositionedError unpositionedError) {
                throw unpositionedError.addPosition(this.getTokenReference());
            }
            boolean bl = false;
            if (this.field != null) {
                bl = true;
            }
            this.check((CContext)cExpressionContext, bl, KjcMessages.FIELD_UNKNOWN, this.ident);
            if (!this.field.isStatic()) {
                boolean bl2 = false;
                if (!cClass.isStatic() || cClass.descendsFrom(this.field.getOwner())) {
                    bl2 = true;
                }
                this.check((CContext)cExpressionContext, bl2, KjcMessages.FIELD_STATICERR, this.ident);
                this.prefix = new JOwnerExpression(this.getTokenReference(), this.field.getOwner());
            } else {
                this.prefix = new JTypeNameExpression(this.getTokenReference(), this.field.getOwnerType());
            }
            this.prefix = this.prefix.analyse(cExpressionContext);
        }
    }

    public void checkAccess(CClass cClass, CExpressionContext cExpressionContext) throws PositionedError {
        TypeFactory typeFactory = cExpressionContext.getTypeFactory();
        CClass cClass2 = this.prefix.getType(typeFactory).getCClass();
        try {
            this.field = cClass2.lookupField(cClass, this.prefix instanceof JSuperExpression || this.prefix instanceof JThisExpression ? null : cClass2, this.ident);
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
        boolean bl = false;
        if (this.field != null) {
            bl = true;
        }
        this.check((CContext)cExpressionContext, bl, KjcMessages.FIELD_UNKNOWN, this.ident);
        try {
            this.field.setType(this.field.getType().checkType(cExpressionContext));
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
        if (cExpressionContext.getMethodContext() instanceof CConstructorContext && this.prefix instanceof JThisExpression && !this.field.isStatic()) {
            this.check((CContext)cExpressionContext, ((CConstructorContext)cExpressionContext.getMethodContext()).isSuperConstructorCalled(), KjcMessages.CONSTRUCTOR_EXPLICIT_CALL, this.field.getIdent());
        }
        if (cExpressionContext.getMethodContext() instanceof CInitializerContext && cClass == this.field.getOwner()) {
            boolean bl2 = false;
            if (this.field.isAnalysed() || cExpressionContext.isLeftSide() || this.field.isSynthetic() || this.field instanceof CSourceField && CVariableInfo.isInitialized(cExpressionContext.getBodyContext().getFieldInfo(((CSourceField)this.field).getPosition()))) {
                bl2 = true;
            }
            this.check((CContext)cExpressionContext, bl2, KjcMessages.USE_BEFORE_DEF, this.field.getIdent());
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof JFieldAccessExpression && this.field.equals(((JFieldAccessExpression)object).field) && this.prefix.equals(((JFieldAccessExpression)object).prefix)) {
            bl = true;
        }
        return bl;
    }

    public boolean booleanValue() {
        if (!this.isConstant()) {
            throw new InconsistencyException(this + " is not a boolean literal");
        }
        return this.field.getValue().booleanValue();
    }

    public byte byteValue() {
        if (!this.isConstant()) {
            throw new InconsistencyException(this + " is not a byte literal");
        }
        return this.field.getValue().byteValue();
    }

    public char charValue() {
        if (!this.isConstant()) {
            throw new InconsistencyException(this + " is not a char literal");
        }
        return this.field.getValue().charValue();
    }

    public double doubleValue() {
        if (!this.isConstant()) {
            throw new InconsistencyException(this + " is not a double literal");
        }
        return this.field.getValue().doubleValue();
    }

    public float floatValue() {
        if (!this.isConstant()) {
            throw new InconsistencyException(this + " is not a float literal");
        }
        return this.field.getValue().floatValue();
    }

    public int intValue() {
        if (!this.isConstant()) {
            throw new InconsistencyException(this + " is not an int literal");
        }
        return this.field.getValue().intValue();
    }

    public long longValue() {
        if (!this.isConstant()) {
            throw new InconsistencyException(this + " is not a long literal");
        }
        return this.field.getValue().longValue();
    }

    public short shortValue() {
        if (!this.isConstant()) {
            throw new InconsistencyException(this + " is not a short literal");
        }
        return this.field.getValue().shortValue();
    }

    public String stringValue() {
        if (!this.isConstant()) {
            throw new InconsistencyException(this + " is not a string literal");
        }
        return this.field.getValue().stringValue();
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitFieldExpression(this, this.prefix, this.getIdent());
    }

    public void genCode(GenerationContext generationContext, boolean bl) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        this.setLineNumber(codeSequence);
        if (!this.field.isStatic()) {
            this.prefix.genCode(generationContext, false);
            if (bl) {
                CodeLabel codeLabel = new CodeLabel();
                codeSequence.plantJumpInstruction(199, codeLabel);
                codeSequence.plantNoArgInstruction(1);
                codeSequence.plantNoArgInstruction(191);
                codeSequence.plantLabel(codeLabel);
            }
        } else if (this.prefix != null) {
            this.prefix.genCode(generationContext, true);
        }
        if (!bl) {
            this.field.genLoad(generationContext);
        }
    }

    public void genStartStoreCode(GenerationContext generationContext) {
        if (!this.field.isStatic()) {
            this.prefix.genCode(generationContext, false);
        } else if (this.prefix != null) {
            this.prefix.genCode(generationContext, true);
        }
    }

    public void genStartAndLoadStoreCode(GenerationContext generationContext, boolean bl) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        this.genStartStoreCode(generationContext);
        if (!this.field.isStatic()) {
            codeSequence.plantNoArgInstruction(89);
        }
        if (!bl) {
            this.field.genLoad(generationContext);
        }
    }

    public void genEndStoreCode(GenerationContext generationContext, boolean bl) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        TypeFactory typeFactory = generationContext.getTypeFactory();
        if (!bl) {
            int n = this.field.isStatic() ? (this.getType(typeFactory).getSize() == 2 ? 92 : 89) : (this.getType(typeFactory).getSize() == 2 ? 93 : 90);
            codeSequence.plantNoArgInstruction(n);
        }
        this.field.genStore(generationContext);
    }

    public JFieldAccessExpression(TokenReference tokenReference, JExpression jExpression, String string) {
        super(tokenReference);
        this.prefix = jExpression;
        this.ident = string;
        this.constantPrefix = false;
        this.accessor = null;
        this.analysed = false;
    }

    public JFieldAccessExpression(TokenReference tokenReference, String string) {
        this(tokenReference, null, string);
    }

    public JFieldAccessExpression(TokenReference tokenReference, JExpression jExpression, CField cField) {
        super(tokenReference);
        this.prefix = jExpression;
        this.ident = cField.getIdent();
        this.constantPrefix = false;
        this.accessor = null;
        this.field = cField;
        this.type = cField.getType();
        this.analysed = true;
    }

    static class SetAccessorData {
        CSourceClass target;
        TypeFactory typeFactory;
        boolean isSuper;

        SetAccessorData() {
        }
    }
}

