/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.CWarning;
import at.dms.compiler.JavaStyleComment;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CBodyContext;
import at.dms.kjc.CContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CSimpleBodyContext;
import at.dms.kjc.CodeLabel;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JAssignmentExpression;
import at.dms.kjc.JExpression;
import at.dms.kjc.JStatement;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.TypeFactory;

public class JIfStatement
extends JStatement {
    private JExpression cond;
    private JStatement thenClause;
    private JStatement elseClause;

    public void analyse(CBodyContext cBodyContext) throws PositionedError {
        TypeFactory typeFactory = cBodyContext.getTypeFactory();
        this.cond = this.cond.analyse(new CExpressionContext(cBodyContext, cBodyContext.getEnvironment()));
        boolean bl = false;
        if (this.cond.getType(typeFactory) == typeFactory.getPrimitiveType(0)) {
            bl = true;
        }
        this.check((CContext)cBodyContext, bl, KjcMessages.IF_COND_NOTBOOLEAN, this.cond.getType(typeFactory));
        if (this.cond instanceof JAssignmentExpression) {
            cBodyContext.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.ASSIGNMENT_IN_CONDITION));
        }
        CSimpleBodyContext cSimpleBodyContext = new CSimpleBodyContext(cBodyContext, cBodyContext.getEnvironment(), cBodyContext);
        this.thenClause.analyse(cSimpleBodyContext);
        if (this.elseClause == null) {
            cBodyContext.merge(cSimpleBodyContext);
        } else {
            this.elseClause.analyse(cBodyContext);
            if (cSimpleBodyContext.isReachable() && cBodyContext.isReachable()) {
                cBodyContext.merge(cSimpleBodyContext);
            } else if (cSimpleBodyContext.isReachable()) {
                cBodyContext.adopt(cSimpleBodyContext);
            }
        }
    }

    public void accept(KjcVisitor kjcVisitor) {
        super.accept(kjcVisitor);
        kjcVisitor.visitIfStatement(this, this.cond, this.thenClause, this.elseClause);
    }

    public void genCode(GenerationContext generationContext) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        this.setLineNumber(codeSequence);
        if (this.cond.isConstant()) {
            if (this.cond.booleanValue()) {
                this.thenClause.genCode(generationContext);
            } else if (this.elseClause != null) {
                this.elseClause.genCode(generationContext);
            }
        } else {
            CodeLabel codeLabel = new CodeLabel();
            CodeLabel codeLabel2 = new CodeLabel();
            this.cond.genBranch(false, generationContext, codeLabel);
            this.thenClause.genCode(generationContext);
            codeSequence.plantJumpInstruction(167, codeLabel2);
            codeSequence.plantLabel(codeLabel);
            if (this.elseClause != null) {
                this.elseClause.genCode(generationContext);
            }
            codeSequence.plantLabel(codeLabel2);
        }
    }

    public JIfStatement(TokenReference tokenReference, JExpression jExpression, JStatement jStatement, JStatement jStatement2, JavaStyleComment[] javaStyleCommentArray) {
        super(tokenReference, javaStyleCommentArray);
        this.cond = jExpression;
        this.thenClause = jStatement;
        this.elseClause = jStatement2;
    }
}

