/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.classfile.PushLiteralInstruction;
import at.dms.compiler.NumberParser;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JByteLiteral;
import at.dms.kjc.JCharLiteral;
import at.dms.kjc.JDoubleLiteral;
import at.dms.kjc.JExpression;
import at.dms.kjc.JFloatLiteral;
import at.dms.kjc.JIntLiteral;
import at.dms.kjc.JLiteral;
import at.dms.kjc.JShortLiteral;
import at.dms.kjc.JStringLiteral;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.TypeFactory;
import at.dms.util.InconsistencyException;

public class JLongLiteral
extends JLiteral {
    private final boolean invert;
    private final long value;

    public JLongLiteral getOppositeLiteral() throws PositionedError {
        return new JLongLiteral(this.getTokenReference(), this.invert ? Long.MIN_VALUE : -this.value);
    }

    public CType getType(TypeFactory typeFactory) {
        return typeFactory.getPrimitiveType(6);
    }

    public long longValue() {
        return this.value;
    }

    public boolean isDefault() {
        boolean bl = false;
        if (this.value == 0L) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JLongLiteral[");
        if (this.invert) {
            stringBuffer.append("9223372036854775808L (= 2^63)");
        } else {
            stringBuffer.append(this.value);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        this.check((CContext)cExpressionContext, this.invert ^ true, KjcMessages.INVALID_LONG_LITERAL, "9223372036854775808L (= 2^63)");
        return this;
    }

    public JExpression convertType(CExpressionContext cExpressionContext, CType cType) {
        if (this.invert) {
            throw new InconsistencyException();
        }
        switch (cType.getTypeID()) {
            case 2: {
                return new JByteLiteral(this.getTokenReference(), (byte)this.value);
            }
            case 3: {
                return new JShortLiteral(this.getTokenReference(), (short)this.value);
            }
            case 4: {
                return new JCharLiteral(this.getTokenReference(), (char)this.value);
            }
            case 5: {
                return new JIntLiteral(this.getTokenReference(), (int)this.value);
            }
            case 6: {
                return this;
            }
            case 7: {
                return new JFloatLiteral(this.getTokenReference(), this.value);
            }
            case 8: {
                return new JDoubleLiteral(this.getTokenReference(), this.value);
            }
            case 9: {
                if (cType != cExpressionContext.getTypeFactory().createReferenceType(10)) {
                    throw new InconsistencyException("cannot convert from long to " + cType);
                }
                return new JStringLiteral(this.getTokenReference(), "" + this.value);
            }
        }
        throw new InconsistencyException("cannot convert from long to " + cType);
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitLongLiteral(this.value);
    }

    public void genCode(GenerationContext generationContext, boolean bl) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        if (!bl) {
            this.setLineNumber(codeSequence);
            codeSequence.plantInstruction(new PushLiteralInstruction(this.value));
        }
    }

    public JLongLiteral(TokenReference tokenReference, String string) throws PositionedError {
        super(tokenReference);
        if (string.startsWith("0")) {
            try {
                this.value = NumberParser.decodeLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PositionedError(tokenReference, KjcMessages.INVALID_LONG_LITERAL, (Object)string);
            }
            this.invert = false;
        } else {
            long l;
            try {
                l = NumberParser.decodeLong("-" + string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PositionedError(tokenReference, KjcMessages.INVALID_LONG_LITERAL, (Object)string);
            }
            if (l == Long.MIN_VALUE) {
                this.value = l;
                this.invert = true;
            } else {
                this.value = -l;
                this.invert = false;
            }
        }
    }

    public JLongLiteral(TokenReference tokenReference, long l) {
        super(tokenReference);
        this.value = l;
        this.invert = false;
    }
}

