/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.classfile.MultiarrayInstruction;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CArrayType;
import at.dms.kjc.CContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JArrayInitializer;
import at.dms.kjc.JExpression;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.TypeFactory;

public class JNewArrayExpression
extends JExpression {
    private CArrayType type;
    private JExpression[] dims;
    private JArrayInitializer init;

    public CType getType(TypeFactory typeFactory) {
        return this.type;
    }

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        boolean bl = this.analyseDimensions(cExpressionContext);
        try {
            this.type = (CArrayType)this.type.checkType(cExpressionContext);
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
        if (this.init == null) {
            this.check(cExpressionContext, bl, KjcMessages.MULTIARRAY_BOUND_MISSING);
        } else {
            this.check(cExpressionContext, bl ^ true, KjcMessages.ARRAY_BOUND_AND_INITIALIZER);
            this.init.setType(this.type);
            this.init.analyse(cExpressionContext);
        }
        return this;
    }

    private final boolean analyseDimensions(CExpressionContext cExpressionContext) throws PositionedError {
        TypeFactory typeFactory = cExpressionContext.getTypeFactory();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < this.dims.length) {
            if (this.dims[n] == null) {
                bl = true;
            } else {
                this.check(cExpressionContext, bl ^ true, KjcMessages.MULTIARRAY_BOUND_MISSING);
                this.dims[n] = this.dims[n].analyse(cExpressionContext);
                this.check((CContext)cExpressionContext, this.dims[n].getType(typeFactory).isAssignableTo(cExpressionContext, cExpressionContext.getTypeFactory().getPrimitiveType(5)), KjcMessages.ARRAY_BADTYPE, this.dims[n].getType(typeFactory));
                bl2 = true;
            }
            ++n;
        }
        return bl2;
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitNewArrayExpression(this, this.type.getBaseType(), this.dims, this.init);
    }

    public void genCode(GenerationContext generationContext, boolean bl) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        this.setLineNumber(codeSequence);
        if (this.init == null) {
            JNewArrayExpression.allocArray(generationContext, this.type, this.dims);
            if (bl) {
                codeSequence.plantPopInstruction(this.type);
            }
        } else {
            this.init.genCode(generationContext, bl);
        }
    }

    public static void allocArray(GenerationContext generationContext, CArrayType cArrayType, JExpression[] jExpressionArray) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        int n = 0;
        while (n < jExpressionArray.length) {
            if (jExpressionArray[n] != null) {
                jExpressionArray[n].genCode(generationContext, false);
            }
            ++n;
        }
        if (cArrayType.getArrayBound() > 1) {
            n = 0;
            int n2 = 0;
            while (n2 < jExpressionArray.length && jExpressionArray[n2] != null) {
                ++n;
                ++n2;
            }
            codeSequence.plantInstruction(new MultiarrayInstruction(cArrayType.getSignature(), n));
        } else {
            codeSequence.plantNewArrayInstruction(cArrayType.getElementType());
        }
    }

    public JNewArrayExpression(TokenReference tokenReference, CType cType, JExpression[] jExpressionArray, JArrayInitializer jArrayInitializer) {
        super(tokenReference);
        this.type = new CArrayType(cType, jExpressionArray.length);
        this.dims = jExpressionArray;
        this.init = jArrayInitializer;
    }
}

