/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CNumericType;
import at.dms.kjc.CType;
import at.dms.kjc.CodeLabel;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JBinaryExpression;
import at.dms.kjc.JBooleanLiteral;
import at.dms.kjc.JExpression;
import at.dms.kjc.JLiteral;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.TypeFactory;
import at.dms.util.InconsistencyException;

public class JRelationalExpression
extends JBinaryExpression {
    protected final int oper;

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        TypeFactory typeFactory = cExpressionContext.getTypeFactory();
        this.left = this.left.analyse(cExpressionContext);
        this.right = this.right.analyse(cExpressionContext);
        boolean bl = false;
        if (this.left.getType(typeFactory).isNumeric() && this.right.getType(typeFactory).isNumeric()) {
            bl = true;
        }
        this.check(cExpressionContext, bl, KjcMessages.RELATIONAL_TYPE, this.left.getType(typeFactory), this.right.getType(typeFactory));
        this.type = cExpressionContext.getTypeFactory().getPrimitiveType(0);
        CType cType = CNumericType.binaryPromote(cExpressionContext, this.left.getType(typeFactory), this.right.getType(typeFactory));
        this.left = this.left.convertType(cExpressionContext, cType);
        this.right = this.right.convertType(cExpressionContext, cType);
        if (this.left.isConstant() && this.right.isConstant()) {
            return this.constantFolding(typeFactory);
        }
        return this;
    }

    public JExpression constantFolding(TypeFactory typeFactory) {
        boolean bl;
        switch (this.left.getType(typeFactory).getTypeID()) {
            case 5: {
                bl = this.compute(this.left.intValue(), this.right.intValue());
                break;
            }
            case 6: {
                bl = this.compute(this.left.longValue(), this.right.longValue());
                break;
            }
            case 7: {
                bl = this.compute(this.left.floatValue(), this.right.floatValue());
                break;
            }
            case 8: {
                bl = this.compute(this.left.doubleValue(), this.right.doubleValue());
                break;
            }
            default: {
                throw new InconsistencyException("unexpected type " + this.left.getType(typeFactory));
            }
        }
        return new JBooleanLiteral(this.getTokenReference(), bl);
    }

    public boolean compute(int n, int n2) {
        switch (this.oper) {
            case 14: {
                boolean bl = false;
                if (n < n2) {
                    bl = true;
                }
                return bl;
            }
            case 15: {
                boolean bl = false;
                if (n <= n2) {
                    bl = true;
                }
                return bl;
            }
            case 16: {
                boolean bl = false;
                if (n > n2) {
                    bl = true;
                }
                return bl;
            }
            case 17: {
                boolean bl = false;
                if (n >= n2) {
                    bl = true;
                }
                return bl;
            }
        }
        throw new InconsistencyException();
    }

    public boolean compute(long l, long l2) {
        switch (this.oper) {
            case 14: {
                boolean bl = false;
                if (l < l2) {
                    bl = true;
                }
                return bl;
            }
            case 15: {
                boolean bl = false;
                if (l <= l2) {
                    bl = true;
                }
                return bl;
            }
            case 16: {
                boolean bl = false;
                if (l > l2) {
                    bl = true;
                }
                return bl;
            }
            case 17: {
                boolean bl = false;
                if (l >= l2) {
                    bl = true;
                }
                return bl;
            }
        }
        throw new InconsistencyException();
    }

    public boolean compute(float f, float f2) {
        switch (this.oper) {
            case 14: {
                boolean bl = false;
                if (f < f2) {
                    bl = true;
                }
                return bl;
            }
            case 15: {
                boolean bl = false;
                if (f <= f2) {
                    bl = true;
                }
                return bl;
            }
            case 16: {
                boolean bl = false;
                if (f > f2) {
                    bl = true;
                }
                return bl;
            }
            case 17: {
                boolean bl = false;
                if (f >= f2) {
                    bl = true;
                }
                return bl;
            }
        }
        throw new InconsistencyException();
    }

    public boolean compute(double d, double d2) {
        switch (this.oper) {
            case 14: {
                boolean bl = false;
                if (d < d2) {
                    bl = true;
                }
                return bl;
            }
            case 15: {
                boolean bl = false;
                if (d <= d2) {
                    bl = true;
                }
                return bl;
            }
            case 16: {
                boolean bl = false;
                if (d > d2) {
                    bl = true;
                }
                return bl;
            }
            case 17: {
                boolean bl = false;
                if (d >= d2) {
                    bl = true;
                }
                return bl;
            }
        }
        throw new InconsistencyException();
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitRelationalExpression(this, this.oper, this.left, this.right);
    }

    public void genCode(GenerationContext generationContext, boolean bl) {
        this.genBooleanResultCode(generationContext, bl);
    }

    protected void genBranch(JExpression jExpression, JExpression jExpression2, boolean bl, GenerationContext generationContext, CodeLabel codeLabel) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        TypeFactory typeFactory = generationContext.getTypeFactory();
        this.setLineNumber(codeSequence);
        if (jExpression.getType(typeFactory).getTypeID() == 5 && jExpression.isConstant() && ((JLiteral)jExpression).isDefault()) {
            int n;
            jExpression2.genCode(generationContext, false);
            switch (this.oper) {
                case 14: {
                    n = 158 - bl;
                    break;
                }
                case 15: {
                    n = bl + 155;
                    break;
                }
                case 16: {
                    n = 156 - bl;
                    break;
                }
                case 17: {
                    n = bl + 157;
                    break;
                }
                default: {
                    throw new InconsistencyException("bad operator " + this.oper);
                }
            }
            codeSequence.plantJumpInstruction(n, codeLabel);
        } else if (jExpression.getType(typeFactory).getTypeID() == 5 && jExpression2.isConstant() && ((JLiteral)jExpression2).isDefault()) {
            int n;
            jExpression.genCode(generationContext, false);
            switch (this.oper) {
                case 14: {
                    n = 156 - bl;
                    break;
                }
                case 15: {
                    n = bl + 157;
                    break;
                }
                case 16: {
                    n = 158 - bl;
                    break;
                }
                case 17: {
                    n = bl + 155;
                    break;
                }
                default: {
                    throw new InconsistencyException("bad operator " + this.oper);
                }
            }
            codeSequence.plantJumpInstruction(n, codeLabel);
        } else {
            jExpression.genCode(generationContext, false);
            jExpression2.genCode(generationContext, false);
            if (jExpression.getType(typeFactory).getTypeID() == 5) {
                int n;
                switch (this.oper) {
                    case 14: {
                        n = 162 - bl;
                        break;
                    }
                    case 15: {
                        n = bl + 163;
                        break;
                    }
                    case 16: {
                        n = 164 - bl;
                        break;
                    }
                    case 17: {
                        n = bl + 161;
                        break;
                    }
                    default: {
                        throw new InconsistencyException("bad operator " + this.oper);
                    }
                }
                codeSequence.plantJumpInstruction(n, codeLabel);
            } else {
                int n;
                if (jExpression.getType(typeFactory).getTypeID() == 6) {
                    n = 148;
                } else if (jExpression.getType(typeFactory).getTypeID() == 7) {
                    switch (this.oper) {
                        case 14: 
                        case 15: {
                            n = 150;
                            break;
                        }
                        case 16: 
                        case 17: {
                            n = 149;
                            break;
                        }
                        default: {
                            throw new InconsistencyException("bad operator " + this.oper);
                        }
                    }
                } else if (jExpression.getType(typeFactory).getTypeID() == 8) {
                    switch (this.oper) {
                        case 14: 
                        case 15: {
                            n = 152;
                            break;
                        }
                        case 16: 
                        case 17: {
                            n = 151;
                            break;
                        }
                        default: {
                            throw new InconsistencyException("bad operator " + this.oper);
                        }
                    }
                } else {
                    throw new InconsistencyException("bad type " + jExpression.getType(typeFactory));
                }
                codeSequence.plantNoArgInstruction(n);
                switch (this.oper) {
                    case 14: {
                        n = 156 - bl;
                        break;
                    }
                    case 15: {
                        n = bl + 157;
                        break;
                    }
                    case 16: {
                        n = 158 - bl;
                        break;
                    }
                    case 17: {
                        n = bl + 155;
                        break;
                    }
                    default: {
                        throw new InconsistencyException("bad operator " + this.oper);
                    }
                }
                codeSequence.plantJumpInstruction(n, codeLabel);
            }
        }
    }

    public JRelationalExpression(TokenReference tokenReference, int n, JExpression jExpression, JExpression jExpression2) {
        super(tokenReference, jExpression, jExpression2);
        this.oper = n;
    }
}

