/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.JavaStyleComment;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CBodyContext;
import at.dms.kjc.CContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CInitializerContext;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JExpression;
import at.dms.kjc.JLocalVariable;
import at.dms.kjc.JStatement;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.TypeFactory;

public class JReturnStatement
extends JStatement {
    protected JExpression expr;

    public CType getType(TypeFactory typeFactory) {
        return this.expr != null ? this.expr.getType(typeFactory) : typeFactory.getVoidType();
    }

    public void analyse(CBodyContext cBodyContext) throws PositionedError {
        CType cType = cBodyContext.getMethodContext().getCMethod().getReturnType();
        TypeFactory typeFactory = cBodyContext.getTypeFactory();
        this.check(cBodyContext, cBodyContext.getMethodContext() instanceof CInitializerContext ^ true, KjcMessages.RETURN_INITIALIZER);
        if (this.expr != null) {
            boolean bl = false;
            if (cType.getTypeID() != 1) {
                bl = true;
            }
            this.check(cBodyContext, bl, KjcMessages.RETURN_NONEMPTY_VOID);
            CExpressionContext cExpressionContext = new CExpressionContext(cBodyContext, cBodyContext.getEnvironment());
            this.expr = this.expr.analyse(cExpressionContext);
            this.check((CContext)cBodyContext, this.expr.isExpression(), KjcMessages.NOT_AN_EXPRESSION, this.expr);
            this.check(cBodyContext, this.expr.isAssignableTo(cExpressionContext, cType), KjcMessages.RETURN_BADTYPE, this.expr.getType(typeFactory), cType);
            this.expr = this.expr.convertType(cExpressionContext, cType);
        } else {
            boolean bl = false;
            if (cType.getTypeID() == 1) {
                bl = true;
            }
            this.check(cBodyContext, bl, KjcMessages.RETURN_EMPTY_NONVOID);
        }
        cBodyContext.setReachable(false);
    }

    public void accept(KjcVisitor kjcVisitor) {
        super.accept(kjcVisitor);
        kjcVisitor.visitReturnStatement(this, this.expr);
    }

    public void genCode(GenerationContext generationContext) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        TypeFactory typeFactory = generationContext.getTypeFactory();
        this.setLineNumber(codeSequence);
        if (this.expr != null) {
            this.expr.genCode(generationContext, false);
            codeSequence.plantReturn(this, generationContext);
            codeSequence.plantNoArgInstruction(this.expr.getType(typeFactory).getReturnOpcode());
        } else {
            codeSequence.plantReturn(this, generationContext);
            codeSequence.plantNoArgInstruction(177);
        }
    }

    public void load(GenerationContext generationContext, JLocalVariable jLocalVariable) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        TypeFactory typeFactory = generationContext.getTypeFactory();
        codeSequence.plantLocalVar(this.expr.getType(typeFactory).getLoadOpcode(), jLocalVariable);
    }

    public void store(GenerationContext generationContext, JLocalVariable jLocalVariable) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        TypeFactory typeFactory = generationContext.getTypeFactory();
        codeSequence.plantLocalVar(this.expr.getType(typeFactory).getStoreOpcode(), jLocalVariable);
    }

    public JReturnStatement(TokenReference tokenReference, JExpression jExpression, JavaStyleComment[] javaStyleCommentArray) {
        super(tokenReference, javaStyleCommentArray);
        this.expr = jExpression;
    }
}

