/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CNumericType;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JBinaryArithmeticExpression;
import at.dms.kjc.JExpression;
import at.dms.kjc.JIntLiteral;
import at.dms.kjc.JLongLiteral;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.TypeFactory;
import at.dms.util.InconsistencyException;

public class JShiftExpression
extends JBinaryArithmeticExpression {
    protected int oper;

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        TypeFactory typeFactory = cExpressionContext.getTypeFactory();
        this.left = this.left.analyse(cExpressionContext);
        this.right = this.right.analyse(cExpressionContext);
        try {
            this.type = JShiftExpression.computeType(cExpressionContext, this.left.getType(typeFactory), this.right.getType(typeFactory));
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
        this.left = this.left.convertType(cExpressionContext, this.type);
        this.right = this.right.convertType(cExpressionContext, cExpressionContext.getTypeFactory().getPrimitiveType(5));
        if (this.left.isConstant() && this.right.isConstant()) {
            return this.constantFolding(typeFactory);
        }
        return this;
    }

    public static CType computeType(CExpressionContext cExpressionContext, CType cType, CType cType2) throws UnpositionedError {
        if (cType.isOrdinal() && cType2.isOrdinal()) {
            cType = CNumericType.unaryPromote(cExpressionContext, cType);
            return cType;
        }
        throw new UnpositionedError(KjcMessages.SHIFT_BADTYPE, cType, cType2);
    }

    public JExpression constantFolding(TypeFactory typeFactory) {
        if (this.left.getType(typeFactory) == typeFactory.getPrimitiveType(6)) {
            long l = this.right.getType(typeFactory) == typeFactory.getPrimitiveType(6) ? this.compute(this.left.longValue(), (int)this.right.longValue()) : this.compute(this.left.longValue(), this.right.intValue());
            return new JLongLiteral(this.getTokenReference(), l);
        }
        int n = this.right.getType(typeFactory) == typeFactory.getPrimitiveType(6) ? this.compute(this.left.intValue(), (int)this.right.longValue()) : this.compute(this.left.intValue(), this.right.intValue());
        return new JIntLiteral(this.getTokenReference(), n);
    }

    public int compute(int n, int n2) {
        switch (this.oper) {
            case 8: {
                return n << n2;
            }
            case 6: {
                return n >> n2;
            }
            case 7: {
                return n >>> n2;
            }
        }
        throw new InconsistencyException();
    }

    public long compute(long l, int n) {
        switch (this.oper) {
            case 8: {
                return l << n;
            }
            case 6: {
                return l >> n;
            }
            case 7: {
                return l >>> n;
            }
        }
        throw new InconsistencyException();
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitShiftExpression(this, this.oper, this.left, this.right);
    }

    public static int getOpcode(int n, CType cType) {
        if (cType.getTypeID() == 6) {
            switch (n) {
                case 8: {
                    return 121;
                }
                case 6: {
                    return 123;
                }
                case 7: {
                    return 125;
                }
            }
        } else {
            switch (n) {
                case 8: {
                    return 120;
                }
                case 6: {
                    return 122;
                }
                case 7: {
                    return 124;
                }
            }
        }
        return -1;
    }

    public void genCode(GenerationContext generationContext, boolean bl) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        TypeFactory typeFactory = generationContext.getTypeFactory();
        this.setLineNumber(codeSequence);
        this.left.genCode(generationContext, false);
        this.right.genCode(generationContext, false);
        codeSequence.plantNoArgInstruction(JShiftExpression.getOpcode(this.oper, this.getType(typeFactory)));
        if (bl) {
            codeSequence.plantPopInstruction(this.getType(typeFactory));
        }
    }

    public JShiftExpression(TokenReference tokenReference, int n, JExpression jExpression, JExpression jExpression2) {
        super(tokenReference, jExpression, jExpression2);
        this.oper = n;
    }
}

