/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.classfile.PushLiteralInstruction;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JExpression;
import at.dms.kjc.JLiteral;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.TypeFactory;
import at.dms.util.InconsistencyException;

public class JStringLiteral
extends JLiteral {
    private String value;

    public CType getType(TypeFactory typeFactory) {
        return typeFactory.createReferenceType(10);
    }

    public String stringValue() {
        return this.value;
    }

    public boolean isDefault() {
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JStringLiteral[");
        stringBuffer.append(this.value);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public JExpression analyse(CExpressionContext cExpressionContext) {
        return this;
    }

    public void accept(KjcVisitor kjcVisitor) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.value.length()) {
            char c = this.value.charAt(n);
            switch (c) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        this.value = stringBuffer.toString();
        kjcVisitor.visitStringLiteral(this.value);
    }

    public void genCode(GenerationContext generationContext, boolean bl) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        if (!bl) {
            this.setLineNumber(codeSequence);
            codeSequence.plantInstruction(new PushLiteralInstruction(this.value));
        }
    }

    public JStringLiteral(TokenReference tokenReference, String string) {
        this(tokenReference, string, false);
    }

    public JStringLiteral(TokenReference tokenReference, String string, boolean bl) {
        super(tokenReference);
        if (string == null) {
            throw new InconsistencyException();
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < string.length()) {
                int n2 = string.charAt(n);
                if (n2 == 92 && n + 1 < string.length() - 1) {
                    n2 = string.charAt(++n);
                    switch (n2) {
                        case 110: {
                            n2 = 10;
                            break;
                        }
                        case 114: {
                            n2 = 13;
                            break;
                        }
                        case 116: {
                            n2 = 9;
                            break;
                        }
                        case 98: {
                            n2 = 8;
                            break;
                        }
                        case 102: {
                            n2 = 12;
                            break;
                        }
                        case 34: {
                            n2 = 34;
                            break;
                        }
                        case 39: {
                            n2 = 39;
                            break;
                        }
                        case 92: {
                            n2 = 92;
                        }
                    }
                }
                stringBuffer.append((char)n2);
                ++n;
            }
            this.value = stringBuffer.toString();
            this.value = this.value.substring(1, this.value.length() - 1);
        } else {
            this.value = string;
        }
    }
}

