/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CLineError;
import at.dms.kjc.CSwitchGroupContext;
import at.dms.kjc.CType;
import at.dms.kjc.JExpression;
import at.dms.kjc.JPhylum;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.TypeFactory;
import at.dms.util.InconsistencyException;
import at.dms.util.MessageDescription;

public class JSwitchLabel
extends JPhylum {
    private JExpression expr;

    public boolean isDefault() {
        boolean bl = false;
        if (this.expr == null) {
            bl = true;
        }
        return bl;
    }

    public Integer getLabel(TypeFactory typeFactory) {
        return new Integer(this.getLabelValue(typeFactory));
    }

    public void analyse(CSwitchGroupContext cSwitchGroupContext) throws PositionedError {
        TypeFactory typeFactory = cSwitchGroupContext.getTypeFactory();
        if (this.expr != null) {
            this.expr = this.expr.analyse(new CExpressionContext(cSwitchGroupContext, cSwitchGroupContext.getEnvironment()));
            this.check(cSwitchGroupContext, this.expr.isConstant(), KjcMessages.SWITCH_LABEL_EXPR_NOTCONST);
            this.check((CContext)cSwitchGroupContext, this.expr.isAssignableTo(cSwitchGroupContext, cSwitchGroupContext.getType()), KjcMessages.SWITCH_LABEL_OVERFLOW, this.expr.getType(typeFactory));
            try {
                cSwitchGroupContext.addLabel(new Integer(this.getLabelValue(typeFactory)));
            }
            catch (UnpositionedError unpositionedError) {
                throw unpositionedError.addPosition(this.getTokenReference());
            }
        }
        try {
            cSwitchGroupContext.addDefault();
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
    }

    protected void fail(CContext cContext, MessageDescription messageDescription, Object[] objectArray) throws PositionedError {
        throw new CLineError(this.getTokenReference(), messageDescription, objectArray);
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitSwitchLabel(this, this.expr);
    }

    private final int getLabelValue(TypeFactory typeFactory) {
        CType cType = this.expr.getType(typeFactory);
        if (cType == typeFactory.getPrimitiveType(1)) {
            return this.expr.byteValue();
        }
        if (cType == typeFactory.getPrimitiveType(2)) {
            return this.expr.charValue();
        }
        if (cType == typeFactory.getPrimitiveType(7)) {
            return this.expr.shortValue();
        }
        if (cType == typeFactory.getPrimitiveType(5)) {
            return this.expr.intValue();
        }
        throw new InconsistencyException("unexpected type " + cType);
    }

    public JSwitchLabel(TokenReference tokenReference, JExpression jExpression) {
        super(tokenReference);
        this.expr = jExpression;
    }
}

