/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CNumericType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.GenerationContext;
import at.dms.kjc.JDoubleLiteral;
import at.dms.kjc.JExpression;
import at.dms.kjc.JFloatLiteral;
import at.dms.kjc.JIntLiteral;
import at.dms.kjc.JLongLiteral;
import at.dms.kjc.JUnaryExpression;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.TypeFactory;
import at.dms.util.InconsistencyException;

public class JUnaryMinusExpression
extends JUnaryExpression {
    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        TypeFactory typeFactory = cExpressionContext.getTypeFactory();
        if (this.expr instanceof JIntLiteral) {
            return ((JIntLiteral)this.expr).getOppositeLiteral();
        }
        if (this.expr instanceof JLongLiteral) {
            return ((JLongLiteral)this.expr).getOppositeLiteral();
        }
        this.expr = this.expr.analyse(cExpressionContext);
        this.check((CContext)cExpressionContext, this.expr.getType(typeFactory).isNumeric(), KjcMessages.UNARY_BADTYPE_PM, this.expr.getType(typeFactory));
        this.type = CNumericType.unaryPromote(cExpressionContext, this.expr.getType(typeFactory));
        this.expr = this.expr.convertType(cExpressionContext, this.type);
        if (this.expr.isConstant()) {
            switch (this.type.getTypeID()) {
                case 5: {
                    this.expr = new JIntLiteral(this.getTokenReference(), -this.expr.intValue());
                    break;
                }
                case 6: {
                    this.expr = new JLongLiteral(this.getTokenReference(), -this.expr.longValue());
                    break;
                }
                case 7: {
                    this.expr = new JFloatLiteral(this.getTokenReference(), -this.expr.floatValue());
                    break;
                }
                case 8: {
                    this.expr = new JDoubleLiteral(this.getTokenReference(), -this.expr.doubleValue());
                    break;
                }
                default: {
                    throw new InconsistencyException("unexpected type " + this.type);
                }
            }
            return this.expr;
        }
        return this;
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitUnaryMinusExpression(this, this.expr);
    }

    public void genCode(GenerationContext generationContext, boolean bl) {
        CodeSequence codeSequence = generationContext.getCodeSequence();
        TypeFactory typeFactory = generationContext.getTypeFactory();
        this.setLineNumber(codeSequence);
        this.expr.genCode(generationContext, false);
        switch (this.type.getTypeID()) {
            case 7: {
                codeSequence.plantNoArgInstruction(118);
                break;
            }
            case 6: {
                codeSequence.plantNoArgInstruction(117);
                break;
            }
            case 8: {
                codeSequence.plantNoArgInstruction(119);
                break;
            }
            default: {
                codeSequence.plantNoArgInstruction(116);
            }
        }
        if (bl) {
            codeSequence.plantPopInstruction(this.getType(typeFactory));
        }
    }

    public JUnaryMinusExpression(TokenReference tokenReference, JExpression jExpression) {
        super(tokenReference, jExpression);
    }
}

