/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.classfile.ClassInfo;
import at.dms.classfile.ClassPath;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CBinaryClass;
import at.dms.kjc.CBinaryTypeContext;
import at.dms.kjc.CClass;
import at.dms.kjc.CSourceClass;
import at.dms.kjc.ClassReader;
import at.dms.kjc.SignatureParser;
import at.dms.kjc.TypeFactory;
import at.dms.util.InconsistencyException;
import at.dms.util.Utils;
import java.util.HashSet;
import java.util.Hashtable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class KjcClassReader
extends Utils
implements ClassReader {
    private Hashtable allLoadedClasses;
    private HashSet allLoadedPackages;
    private ClassPath classpath;
    private final SignatureParser signatureParser;

    public CClass loadClass(TypeFactory typeFactory, String string) {
        CClass cClass = (CClass)this.allLoadedClasses.get(string);
        if (cClass != null) {
            return cClass != CClass.CLS_UNDEFINED ? cClass : null;
        }
        ClassInfo classInfo = this.classpath.loadClass(string, true);
        cClass = classInfo == null ? CClass.CLS_UNDEFINED : new CBinaryClass(this.signatureParser, this, typeFactory, classInfo);
        this.allLoadedClasses.put(string, cClass);
        if (cClass instanceof CBinaryClass) {
            try {
                ((CBinaryClass)cClass).checkTypes(new CBinaryTypeContext(this, typeFactory, null, cClass));
            }
            catch (UnpositionedError unpositionedError) {
                unpositionedError.addPosition(TokenReference.NO_REF);
                unpositionedError.printStackTrace();
                throw new InconsistencyException("Error while reading class");
            }
        }
        return cClass;
    }

    public boolean addSourceClass(CSourceClass cSourceClass) {
        CClass cClass = this.allLoadedClasses.put(cSourceClass.getQualifiedName(), cSourceClass);
        this.allLoadedPackages.add(cSourceClass.getPackage());
        boolean bl = false;
        if (cClass == null || cSourceClass.getOwner() != null || !(cClass instanceof CSourceClass) || cClass.getSourceFile() == cSourceClass.getSourceFile()) {
            bl = true;
        }
        return bl;
    }

    public boolean hasClassFile(String string) {
        CClass cClass = (CClass)this.allLoadedClasses.get(string);
        boolean bl = false;
        if (cClass != null && cClass != CClass.CLS_UNDEFINED || this.classpath.loadClass(string, true) != null) {
            bl = true;
        }
        return bl;
    }

    public SignatureParser getSignatureParser() {
        return this.signatureParser;
    }

    public boolean packageExists(String string) {
        if (this.allLoadedPackages.contains(string)) {
            return true;
        }
        return this.classpath.packageExists(string);
    }

    private final /* synthetic */ void this() {
        this.allLoadedClasses = new Hashtable(2000);
        this.allLoadedPackages = new HashSet(2000);
    }

    public KjcClassReader(String string, String string2, SignatureParser signatureParser) {
        this.this();
        this.classpath = new ClassPath(string, string2);
        this.signatureParser = signatureParser;
    }
}

