/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.kjc.ClassReader;
import at.dms.kjc.KjcOptions;
import at.dms.kjc.LanguageExtensions;
import at.dms.kjc.SignatureParser;
import at.dms.kjc.TypeFactory;
import at.dms.util.InconsistencyException;

public class KjcEnvironment {
    public static final int AS_NONE = 0;
    public static final int AS_SIMPLE = 1;
    public static final int AS_ALL = 2;
    public static final int SOURCE_1_1 = 101;
    public static final int SOURCE_1_2 = 102;
    public static final int SOURCE_1_3 = 103;
    public static final int SOURCE_1_4 = 104;
    private final ClassReader classReader;
    private final TypeFactory typeFactory;
    private final KjcOptions options;
    private final int assertion;
    private final LanguageExtensions languageExtensions;

    public ClassReader getClassReader() {
        return this.classReader;
    }

    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public SignatureParser getSignatureParser() {
        return this.classReader.getSignatureParser();
    }

    public LanguageExtensions getLanguageExtFactory() {
        return this.languageExtensions;
    }

    public int getSourceVersion() {
        if (this.options.source.equals("1.1")) {
            return 101;
        }
        if (this.options.source.equals("1.2")) {
            return 102;
        }
        if (this.options.source.equals("1.3")) {
            return 103;
        }
        if (this.options.source.equals("1.4")) {
            return 104;
        }
        throw new InconsistencyException("Wrong source language in options");
    }

    public int getAssertExtension() {
        return this.assertion;
    }

    public boolean isGenericEnabled() {
        return this.options.generic;
    }

    public KjcEnvironment(ClassReader classReader, TypeFactory typeFactory, KjcOptions kjcOptions) {
        this.classReader = classReader;
        this.typeFactory = typeFactory;
        this.options = kjcOptions;
        this.languageExtensions = new LanguageExtensions();
        this.assertion = kjcOptions.assertion.equals("simple") ? 1 : (kjcOptions.assertion.equals("all") ? 2 : 0);
    }
}

