/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.kjc.CArrayType;
import at.dms.kjc.CReferenceType;
import at.dms.kjc.CType;
import at.dms.kjc.CTypeVariable;
import at.dms.kjc.CTypeVariableAlias;
import at.dms.kjc.SignatureParser;
import at.dms.kjc.TypeFactory;
import at.dms.util.InconsistencyException;
import java.util.ArrayList;

public class KjcSignatureParser
implements SignatureParser {
    private int current;

    public final CType parseSignature(TypeFactory typeFactory, String string) {
        return this.parseSignature(typeFactory, string, 0, string.length());
    }

    protected CType parseSignature(TypeFactory typeFactory, String string, int n, int n2) {
        CType cType;
        int n3 = 0;
        while (string.charAt(n) == '[') {
            ++n3;
            ++n;
        }
        switch (string.charAt(n)) {
            case 'V': {
                cType = typeFactory.getVoidType();
                break;
            }
            case 'B': {
                cType = typeFactory.getPrimitiveType(1);
                break;
            }
            case 'C': {
                cType = typeFactory.getPrimitiveType(2);
                break;
            }
            case 'D': {
                cType = typeFactory.getPrimitiveType(3);
                break;
            }
            case 'F': {
                cType = typeFactory.getPrimitiveType(4);
                break;
            }
            case 'I': {
                cType = typeFactory.getPrimitiveType(5);
                break;
            }
            case 'J': {
                cType = typeFactory.getPrimitiveType(6);
                break;
            }
            case 'L': {
                cType = typeFactory.createType(string.substring(n + 1, n2 - 1), true);
                break;
            }
            case 'S': {
                cType = typeFactory.getPrimitiveType(7);
                break;
            }
            case 'Z': {
                cType = typeFactory.getPrimitiveType(0);
                break;
            }
            case 'T': {
                cType = new CTypeVariableAlias(string.substring(n + 1, n2 - 1));
                break;
            }
            default: {
                throw new InconsistencyException("Unknown signature: " + string.charAt(n));
            }
        }
        return n3 > 0 ? new CArrayType(cType, n3) : cType;
    }

    /*
     * Unable to fully structure code
     */
    protected CType parseGenericTypeSignature(TypeFactory var1_1, String var2_2, char[] var3_3) {
        block4: {
            var4_4 = this.current;
            var5_5 = null;
            while (var3_3[this.current] == '[') {
                ++this.current;
            }
            if (var3_3[this.current] == 'L' || var3_3[this.current] == 'T') ** GOTO lbl10
            ++this.current;
            break block4;
lbl-1000:
            // 1 sources

            {
                ++this.current;
lbl10:
                // 2 sources

                ** while (var3_3[this.current] != ';' && var3_3[this.current] != '<')
            }
lbl11:
            // 1 sources

            ++this.current;
        }
        if (var3_3[this.current - 1] != '<') {
            var5_5 = this.parseSignature(var1_1, var2_2, var4_4, this.current);
        } else {
            var6_6 = String.valueOf(var3_3, var4_4 + 1, this.current - var4_4 - 2);
            var7_7 = this.parseTypeArgumentSignature(var1_1, var2_2, var3_3);
            var5_5 = var1_1.createType(var6_6, new CReferenceType[][]{var7_7}, true);
        }
        return var5_5;
    }

    protected CReferenceType[] parseTypeArgumentSignature(TypeFactory typeFactory, String string, char[] cArray) {
        ArrayList<CType> arrayList = new ArrayList<CType>(10);
        while (cArray[this.current] != '>') {
            arrayList.add(this.parseGenericTypeSignature(typeFactory, string, cArray));
        }
        ++this.current;
        ++this.current;
        return arrayList.toArray(new CReferenceType[arrayList.size()]);
    }

    protected CTypeVariable[] parseTypeParameter(TypeFactory typeFactory, String string, char[] cArray) {
        if (cArray[this.current] == '<') {
            ArrayList<CTypeVariable> arrayList = new ArrayList<CTypeVariable>(10);
            ++this.current;
            while (cArray[this.current] != '>') {
                int n = this.current;
                while (cArray[n] != ':') {
                    ++n;
                }
                String string2 = string.substring(this.current, n);
                this.current = ++n;
                ArrayList<CType> arrayList2 = new ArrayList<CType>(5);
                arrayList2.add(this.parseGenericTypeSignature(typeFactory, string, cArray));
                while (cArray[this.current] == ':') {
                    ++this.current;
                    arrayList2.add(this.parseGenericTypeSignature(typeFactory, string, cArray));
                }
                CReferenceType[] cReferenceTypeArray = arrayList2.toArray(new CReferenceType[arrayList2.size()]);
                arrayList.add(new CTypeVariable(string2, cReferenceTypeArray));
            }
            CTypeVariable[] cTypeVariableArray = arrayList.toArray(new CTypeVariable[arrayList.size()]);
            int n = 0;
            while (n < cTypeVariableArray.length) {
                cTypeVariableArray[n].setIndex(n);
                ++n;
            }
            ++this.current;
            return cTypeVariableArray;
        }
        return CTypeVariable.EMPTY;
    }

    public SignatureParser.ClassSignature parseClassSignature(TypeFactory typeFactory, String string) {
        char[] cArray = string.toCharArray();
        this.current = 0;
        CTypeVariable[] cTypeVariableArray = this.parseTypeParameter(typeFactory, string, cArray);
        CReferenceType cReferenceType = (CReferenceType)this.parseGenericTypeSignature(typeFactory, string, cArray);
        ArrayList<CType> arrayList = new ArrayList<CType>(10);
        while (this.current < cArray.length) {
            arrayList.add(this.parseGenericTypeSignature(typeFactory, string, cArray));
        }
        CReferenceType[] cReferenceTypeArray = arrayList.toArray(new CReferenceType[arrayList.size()]);
        return new SignatureParser.ClassSignature(cReferenceType, cReferenceTypeArray, cTypeVariableArray);
    }

    public SignatureParser.MethodSignature parseMethodSignature(TypeFactory typeFactory, String string) {
        CReferenceType[] cReferenceTypeArray;
        char[] cArray = string.toCharArray();
        this.current = 0;
        CTypeVariable[] cTypeVariableArray = this.parseTypeParameter(typeFactory, string, cArray);
        ArrayList<CType> arrayList = new ArrayList<CType>();
        ++this.current;
        while (cArray[this.current] != ')') {
            arrayList.add(this.parseGenericTypeSignature(typeFactory, string, cArray));
        }
        CType[] cTypeArray = arrayList.toArray(new CType[arrayList.size()]);
        ++this.current;
        CType cType = this.parseGenericTypeSignature(typeFactory, string, cArray);
        ArrayList<CType> arrayList2 = arrayList;
        arrayList2.clear();
        if (cArray.length > this.current && cArray[this.current] == '^') {
            while (cArray.length > this.current) {
                arrayList2.add(this.parseGenericTypeSignature(typeFactory, string, cArray));
            }
            cReferenceTypeArray = arrayList2.toArray(new CReferenceType[arrayList2.size()]);
        } else {
            cReferenceTypeArray = CReferenceType.EMPTY;
        }
        return new SignatureParser.MethodSignature(cType, cTypeArray, cReferenceTypeArray, cTypeVariableArray);
    }
}

